/*
 * Decompiled with CFR 0.152.
 */
package atonkish.reputation.provider;

import atonkish.reputation.entity.passive.VillagerEntityInterface;
import atonkish.reputation.util.cache.VillagerCache;
import com.google.common.cache.Cache;
import java.util.Optional;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.mixin.EntityAccess;
import net.minecraft.class_124;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public enum VillagerSnitchProvider implements IEntityComponentProvider,
IDataProvider<class_1646>
{
    INSTANCE;

    public static final String IS_SNITCH_KEY = "ReputationModIsSnitch";

    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        class_2487 data = accessor.getData().raw();
        class_1657 player = accessor.getPlayer();
        class_1646 villager = (class_1646)accessor.getEntity();
        VillagerCache.Data villagerData = VillagerSnitchProvider.getVillagerData(data, player, villager);
        @Nullable class_2561 customName = villager.method_5797();
        String name = customName != null ? String.format("%s (%s)", customName.getString(), ((EntityAccess)villager).wthit_getTypeName().getString()) : villager.method_5477().getString();
        IWailaConfig.Formatter formatter = IWailaConfig.get().getFormatter();
        class_2561 text = formatter.entityName((Object)name);
        if (villagerData.isSnitch()) {
            String snitchTranslateKey = String.format("entity.%s.villager.snitch", "reputation");
            class_5250 mText = class_2561.method_43473();
            mText = mText.method_10852((class_2561)class_2561.method_43470((String)name).method_27695(new class_124[]{class_124.field_1068, class_124.field_1055}));
            mText = mText.method_27693(" ");
            mText = mText.method_10852((class_2561)class_2561.method_43471((String)snitchTranslateKey).method_27692(class_124.field_1079));
            text = mText;
        }
        tooltip.setLine(WailaConstants.OBJECT_NAME_TAG, text);
    }

    public final void appendData(IDataWriter data, IServerAccessor<class_1646> accessor, IPluginConfig config) {
        class_3222 player = accessor.getPlayer();
        class_1646 villager = (class_1646)accessor.getTarget();
        boolean isSnitch = ((VillagerEntityInterface)villager).isSnitch((class_1657)player);
        data.raw().method_10556(IS_SNITCH_KEY, isSnitch);
    }

    private static VillagerCache.Data getVillagerData(class_2487 data, class_1657 player, class_1646 villager) {
        Boolean isSnitch;
        Cache<class_1646, VillagerCache.Data> villagerCache = VillagerCache.getOrCreate(player);
        VillagerCache.Data villagerData = Optional.ofNullable((VillagerCache.Data)villagerCache.getIfPresent((Object)villager)).orElse(new VillagerCache.Data());
        Boolean bl = isSnitch = data.method_10545(IS_SNITCH_KEY) ? Boolean.valueOf(data.method_10577(IS_SNITCH_KEY)) : null;
        if (isSnitch != null) {
            villagerData.setIsSnitch(isSnitch);
        }
        villagerCache.put((Object)villager, (Object)villagerData);
        return villagerData;
    }
}

