/*
 * Decompiled with CFR 0.152.
 */
package atonkish.reputation.provider;

import atonkish.reputation.util.cache.IronGolemCache;
import com.google.common.cache.Cache;
import java.util.Optional;
import java.util.UUID;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.ITooltip;
import net.minecraft.class_124;
import net.minecraft.class_1439;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public enum IronGolemProvider implements IEntityComponentProvider,
IDataProvider<class_1439>
{
    INSTANCE;

    public static final String ANGRY_AT_KEY = "ReputationModAngryAt";

    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        class_2487 data = accessor.getData().raw();
        class_1657 player = accessor.getPlayer();
        class_1439 golem = (class_1439)accessor.getEntity();
        IronGolemCache.Data golemData = IronGolemProvider.getIronGolemData(data, player, golem);
        @Nullable UUID angryAt = golemData.getAngryAt();
        if (player.method_5667().equals(angryAt)) {
            String angryTranslateKey = String.format("entity.%s.iron_golem.angry", "reputation");
            class_5250 text = class_2561.method_43471((String)angryTranslateKey).method_27692(class_124.field_1079);
            tooltip.addLine((class_2561)text);
        }
    }

    public final void appendData(IDataWriter data, IServerAccessor<class_1439> accessor, IPluginConfig config) {
        class_1439 golem = (class_1439)accessor.getTarget();
        @Nullable UUID angryAt = golem.method_29508();
        if (angryAt != null) {
            data.raw().method_25927(ANGRY_AT_KEY, angryAt);
        }
    }

    private static IronGolemCache.Data getIronGolemData(class_2487 data, class_1657 player, class_1439 golem) {
        Cache<class_1439, IronGolemCache.Data> golemCache = IronGolemCache.getOrCreate(player);
        IronGolemCache.Data golemData = Optional.ofNullable((IronGolemCache.Data)golemCache.getIfPresent((Object)golem)).orElse(new IronGolemCache.Data());
        UUID angryAt = data.method_10545(ANGRY_AT_KEY) ? data.method_25926(ANGRY_AT_KEY) : null;
        golemData.setAngryAt(angryAt);
        golemCache.put((Object)golem, (Object)golemData);
        return golemData;
    }
}

