/*
 * Decompiled with CFR 0.152.
 */
package io.github.yxmna.yosbs.core;

import io.github.yxmna.yosbs.util.Logger;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class DefaultConfigSynchronizer {
    private final Logger logger;
    private final Path mcDir;
    private final Path configDir;
    private final List<Path> roots;
    private int visited = 0;
    private int copied = 0;

    public DefaultConfigSynchronizer(Logger logger, Path mcDir, Path configDir) {
        this.logger = logger;
        this.mcDir = mcDir;
        this.configDir = configDir;
        this.roots = Collections.unmodifiableList(Arrays.asList(configDir.resolve("yosbs"), configDir.resolve("yosbr")));
    }

    public void apply() {
        this.logger.info("Searching for default configuration files ...", new Object[0]);
        for (Path root : this.roots) {
            if (!Files.exists(root, new LinkOption[0])) {
                this.logger.debug("Root folder not found, skipping: {}", root);
                continue;
            }
            try {
                Files.walkFileTree(root, new CopyVisitor(root));
            }
            catch (IOException e) {
                this.logger.error("Error while processing {}", root, e);
            }
        }
        if (this.visited == 0) {
            this.logger.info("No default configuration files were found.", new Object[0]);
        } else if (this.copied == 0) {
            this.logger.info("All {} configuration file(s) were already present.", this.visited);
        } else {
            this.logger.info("Copied {} new configuration file(s); {} already existed.", this.copied, this.visited - this.copied);
        }
        this.logger.info("Finished.", new Object[0]);
    }

    private Path mapToDestination(Path root, Path sourceFile) {
        Path rel = root.relativize(sourceFile);
        if (rel.getNameCount() > 0 && "config".equals(rel.getName(0).toString())) {
            return this.configDir.resolve(rel.subpath(1, rel.getNameCount()));
        }
        return this.mcDir.resolve(rel);
    }

    private final class CopyVisitor
    extends SimpleFileVisitor<Path> {
        private final Path currentRoot;

        CopyVisitor(Path currentRoot) {
            this.currentRoot = currentRoot;
        }

        @Override
        public FileVisitResult visitFile(Path src, BasicFileAttributes attrs) throws IOException {
            if (!attrs.isRegularFile()) {
                return FileVisitResult.CONTINUE;
            }
            DefaultConfigSynchronizer.this.visited++;
            Path dst = DefaultConfigSynchronizer.this.mapToDestination(this.currentRoot, src);
            if (dst == null) {
                DefaultConfigSynchronizer.this.logger.debug("File outside mapping scope, ignored: {}", src);
                return FileVisitResult.CONTINUE;
            }
            if (Files.exists(dst, new LinkOption[0])) {
                DefaultConfigSynchronizer.this.logger.info("Configuration file already present, skipping: {}", DefaultConfigSynchronizer.this.mcDir.relativize(dst));
                return FileVisitResult.CONTINUE;
            }
            try {
                Files.createDirectories(dst.getParent(), new FileAttribute[0]);
                Path tmp = dst.resolveSibling(dst.getFileName() + ".tmp");
                Files.copy(src, tmp, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                Files.move(tmp, dst, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                DefaultConfigSynchronizer.this.copied++;
                DefaultConfigSynchronizer.this.logger.info("Copied {} to {}", this.currentRoot.getParent().relativize(src), DefaultConfigSynchronizer.this.mcDir.relativize(dst));
            }
            catch (IOException e) {
                DefaultConfigSynchronizer.this.logger.error("Failed to copy {} to {}", src, dst, e);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            DefaultConfigSynchronizer.this.logger.error("Cannot access {}", file, exc);
            return FileVisitResult.CONTINUE;
        }
    }
}

