/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.hud;

import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Objects;
import lol.bai.badpackets.api.PacketSender;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.access.ClientAccessor;
import mcp.mobius.waila.access.DataWriter;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IInstanceRegistry;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.component.EmptyComponent;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.gui.hud.InspectComponent;
import mcp.mobius.waila.gui.hud.Tooltip;
import mcp.mobius.waila.gui.hud.TooltipPosition;
import mcp.mobius.waila.network.Packets;
import mcp.mobius.waila.registry.PluginAware;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.ExceptionUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public class ComponentHandler {
    public static void requestBlockData(ClientAccessor accessor) {
        Registrar registrar = Registrar.get();
        class_2248 block = accessor.getBlock();
        Object blockEntity = accessor.getBlockEntity();
        int rate = Waila.CONFIG.get().getGeneral().getRateLimit();
        if (blockEntity == null || !accessor.isTimeElapsed(rate) || !Waila.CONFIG.get().getGeneral().isDisplayTooltip()) {
            return;
        }
        if (registrar.blockData.get(block).isEmpty() && registrar.blockData.get(blockEntity).isEmpty()) {
            return;
        }
        accessor.resetTimer();
        accessor.setDataAccess(false);
        DataWriter.CLIENT.reset();
        class_1657 player = accessor.getPlayer();
        for (IInstanceRegistry.Entry<IBlockComponentProvider> entry : registrar.blockDataCtx.get(block)) {
            DataWriter.CLIENT.tryAppend(player, entry.instance(), accessor, PluginConfig.CLIENT, IBlockComponentProvider::appendDataContext);
        }
        for (IInstanceRegistry.Entry<IBlockComponentProvider> entry : registrar.blockDataCtx.get(blockEntity)) {
            DataWriter.CLIENT.tryAppend(player, entry.instance(), accessor, PluginConfig.CLIENT, IBlockComponentProvider::appendDataContext);
        }
        DataWriter.CLIENT.send(PacketSender.c2s(), player);
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_17813(accessor.getBlockHitResult());
        PacketSender.c2s().send(Packets.BLOCK, buf);
        accessor.setDataAccess(true);
    }

    public static void gatherBlock(ClientAccessor accessor, Tooltip tooltip, TooltipPosition position) {
        class_2248 block = accessor.getBlock();
        Object blockEntity = accessor.getBlockEntity();
        ComponentHandler.handleBlock(accessor, tooltip, block, position);
        if (blockEntity != null) {
            ComponentHandler.handleBlock(accessor, tooltip, blockEntity, position);
        }
    }

    private static void handleBlock(ClientAccessor accessor, Tooltip tooltip, Object obj, TooltipPosition position) {
        Registrar registrar = Registrar.get();
        List<IInstanceRegistry.Entry<PluginAware<IBlockComponentProvider>>> providers = registrar.blockComponent.get((Object)position).get(obj);
        for (IInstanceRegistry.Entry<PluginAware<IBlockComponentProvider>> entry : providers) {
            PluginAware<IBlockComponentProvider> origin = entry.instance();
            IBlockComponentProvider provider = origin.instance();
            tooltip.origin = origin;
            try {
                switch (position) {
                    case HEAD: {
                        provider.appendHead(tooltip, accessor, PluginConfig.CLIENT);
                        break;
                    }
                    case BODY: {
                        provider.appendBody(tooltip, accessor, PluginConfig.CLIENT);
                        break;
                    }
                    case TAIL: {
                        provider.appendTail(tooltip, accessor, PluginConfig.CLIENT);
                    }
                }
            }
            catch (Throwable e) {
                ExceptionUtil.dump(e, provider.getClass().toString(), tooltip);
            }
            tooltip.origin = null;
        }
    }

    public static void requestEntityData(class_1297 entity, ClientAccessor accessor) {
        Registrar registrar = Registrar.get();
        Object trueEntity = accessor.getEntity();
        int rate = Waila.CONFIG.get().getGeneral().getRateLimit();
        if (trueEntity == null || !accessor.isTimeElapsed(rate)) {
            return;
        }
        if (registrar.entityData.get(trueEntity).isEmpty()) {
            return;
        }
        accessor.resetTimer();
        accessor.setDataAccess(false);
        DataWriter.CLIENT.reset();
        class_1657 player = accessor.getPlayer();
        for (IInstanceRegistry.Entry<IEntityComponentProvider> entry : registrar.entityDataCtx.get(entity)) {
            DataWriter.CLIENT.tryAppend(player, entry.instance(), accessor, PluginConfig.CLIENT, IEntityComponentProvider::appendDataContext);
        }
        DataWriter.CLIENT.send(PacketSender.c2s(), player);
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10804(entity.method_5628());
        class_243 hitPos = accessor.getEntityHitResult().method_17784();
        buf.writeDouble(hitPos.field_1352);
        buf.writeDouble(hitPos.field_1351);
        buf.writeDouble(hitPos.field_1350);
        PacketSender.c2s().send(Packets.ENTITY, buf);
        accessor.setDataAccess(true);
    }

    public static void gatherEntity(class_1297 entity, ClientAccessor accessor, Tooltip tooltip, TooltipPosition position) {
        Registrar registrar = Registrar.get();
        List<IInstanceRegistry.Entry<PluginAware<IEntityComponentProvider>>> providers = registrar.entityComponent.get((Object)position).get(entity);
        for (IInstanceRegistry.Entry<PluginAware<IEntityComponentProvider>> entry : providers) {
            PluginAware<IEntityComponentProvider> origin = entry.instance();
            IEntityComponentProvider provider = origin.instance();
            tooltip.origin = origin;
            try {
                switch (position) {
                    case HEAD: {
                        provider.appendHead(tooltip, accessor, PluginConfig.CLIENT);
                        break;
                    }
                    case BODY: {
                        provider.appendBody(tooltip, accessor, PluginConfig.CLIENT);
                        break;
                    }
                    case TAIL: {
                        provider.appendTail(tooltip, accessor, PluginConfig.CLIENT);
                    }
                }
            }
            catch (Throwable e) {
                ExceptionUtil.dump(e, provider.getClass().toString(), tooltip);
            }
            tooltip.origin = null;
        }
    }

    public static ITooltipComponent getIcon(class_239 target) {
        Registrar registrar = Registrar.get();
        ClientAccessor data = ClientAccessor.INSTANCE;
        PluginConfig config = PluginConfig.CLIENT;
        if (target.method_17783() == class_239.class_240.field_1331) {
            List<IInstanceRegistry.Entry<PluginAware<IEntityComponentProvider>>> providers = registrar.entityIcon.get(data.getEntity());
            for (IInstanceRegistry.Entry<PluginAware<IEntityComponentProvider>> provider : providers) {
                PluginAware<IEntityComponentProvider> origin = provider.instance();
                ITooltipComponent icon = InspectComponent.maybeWrap(origin.instance().getIcon(data, config), origin, null);
                if (icon == null) continue;
                return icon;
            }
        } else {
            Object blockEntity;
            class_2680 state = data.getBlockState();
            if (state.method_26215()) {
                return EmptyComponent.INSTANCE;
            }
            ITooltipComponent result = null;
            int priority = 0;
            for (IInstanceRegistry.Entry<PluginAware<IBlockComponentProvider>> provider : registrar.blockIcon.get(state.method_26204())) {
                PluginAware<IBlockComponentProvider> origin = provider.instance();
                ITooltipComponent icon = origin.instance().getIcon(ClientAccessor.INSTANCE, PluginConfig.CLIENT);
                if (icon == null) continue;
                result = InspectComponent.maybeWrap(icon, origin, null);
                priority = provider.priority();
                break;
            }
            if ((blockEntity = data.getBlockEntity()) != null) {
                for (IInstanceRegistry.Entry<PluginAware<IBlockComponentProvider>> provider : registrar.blockIcon.get(blockEntity)) {
                    if (provider.priority() >= priority) break;
                    PluginAware<IBlockComponentProvider> origin = provider.instance();
                    ITooltipComponent icon = origin.instance().getIcon(ClientAccessor.INSTANCE, PluginConfig.CLIENT);
                    if (icon == null) continue;
                    result = InspectComponent.maybeWrap(icon, origin, null);
                    break;
                }
            }
            if (result != null) {
                return result;
            }
        }
        return EmptyComponent.INSTANCE;
    }

    @Nullable
    public static class_1297 getOverrideEntity(class_239 target) {
        if (target == null || target.method_17783() != class_239.class_240.field_1331) {
            return null;
        }
        Registrar registrar = Registrar.get();
        class_1297 entity = ((class_3966)target).method_17782();
        List<IInstanceRegistry.Entry<IEntityComponentProvider>> overrideProviders = registrar.entityOverride.get(entity);
        for (IInstanceRegistry.Entry<IEntityComponentProvider> provider : overrideProviders) {
            class_1297 override = provider.instance().getOverride(ClientAccessor.INSTANCE, PluginConfig.CLIENT);
            if (override == null) continue;
            return override;
        }
        return entity;
    }

    public static class_2680 getOverrideBlock(class_239 target) {
        Registrar registrar = Registrar.get();
        class_638 world = Objects.requireNonNull(class_310.method_1551().field_1687);
        class_2338 pos = ((class_3965)target).method_17777();
        class_2680 state = world.method_8320(pos);
        class_2680 override = null;
        int priority = 0;
        List<IInstanceRegistry.Entry<IBlockComponentProvider>> providers = registrar.blockOverride.get(state.method_26204());
        for (IInstanceRegistry.Entry<IBlockComponentProvider> provider : providers) {
            class_2680 blockOverride = provider.instance().getOverride(ClientAccessor.INSTANCE, PluginConfig.CLIENT);
            if (blockOverride == null) continue;
            override = blockOverride;
            priority = provider.priority();
            break;
        }
        class_2586 blockEntity = world.method_8321(pos);
        providers = registrar.blockOverride.get(blockEntity);
        for (IInstanceRegistry.Entry<IBlockComponentProvider> provider : providers) {
            if (provider.priority() >= priority) break;
            class_2680 beOverride = provider.instance().getOverride(ClientAccessor.INSTANCE, PluginConfig.CLIENT);
            if (beOverride == null) continue;
            override = beOverride;
            break;
        }
        return override != null ? override : state;
    }
}

