/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.whatdidijustkill.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import com.tristankechlo.whatdidijustkill.IPlatformHelper;
import com.tristankechlo.whatdidijustkill.WhatDidIJustKill;
import com.tristankechlo.whatdidijustkill.config.WhatDidIJustKillConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ConfigManager {
    private static final File CONFIG_DIR = IPlatformHelper.INSTANCE.getConfigDirectory().toFile();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    private static final String FILE_NAME = "whatdidijustkill.json";
    private static final File CONFIG_FILE = new File(CONFIG_DIR, "whatdidijustkill.json");

    public static boolean loadAndVerifyConfig() {
        ConfigManager.createConfigFolder();
        if (!CONFIG_FILE.exists()) {
            WhatDidIJustKillConfig.setToDefault();
            ConfigManager.writeConfigToFile();
            WhatDidIJustKill.LOGGER.warn("No config '{}' was found, created a new one.", (Object)FILE_NAME);
            return true;
        }
        AtomicBoolean successFul = new AtomicBoolean(true);
        try {
            ConfigManager.loadConfigFromFile(() -> successFul.set(false));
            if (successFul.get()) {
                WhatDidIJustKill.LOGGER.info("Config '{}' was successfully loaded.", (Object)FILE_NAME);
            } else {
                WhatDidIJustKill.LOGGER.error("Config '{}' did not load correctly. Using default config.", (Object)FILE_NAME);
                ConfigManager.backupConfig();
                WhatDidIJustKillConfig.setToDefault();
                ConfigManager.writeConfigToFile();
            }
        }
        catch (Exception e) {
            WhatDidIJustKill.LOGGER.error(e.getMessage());
            WhatDidIJustKill.LOGGER.error("Error loading config '{}', config hasn't been loaded. Using default config.", (Object)FILE_NAME);
            ConfigManager.backupConfig();
            WhatDidIJustKillConfig.setToDefault();
            ConfigManager.writeConfigToFile();
            successFul.set(false);
        }
        return successFul.get();
    }

    private static void loadConfigFromFile(Runnable setUnSuccessful) throws FileNotFoundException {
        JsonParser parser = new JsonParser();
        JsonElement jsonElement = parser.parse((Reader)new FileReader(CONFIG_FILE));
        JsonObject json = jsonElement.getAsJsonObject();
        WhatDidIJustKillConfig.fromJson((JsonElement)json, setUnSuccessful);
    }

    private static boolean writeConfigToFile() {
        try {
            JsonElement jsonObject = WhatDidIJustKillConfig.toJson();
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(CONFIG_FILE));
            writer.setIndent("\t");
            GSON.toJson(jsonObject, writer);
            writer.close();
            return true;
        }
        catch (Exception e) {
            WhatDidIJustKill.LOGGER.error("There was an error writing the config to file: '{}'", (Object)FILE_NAME);
            WhatDidIJustKill.LOGGER.error(e.getMessage());
            return false;
        }
    }

    public static boolean resetConfig() {
        try {
            WhatDidIJustKillConfig.setToDefault();
            boolean success = ConfigManager.writeConfigToFile();
            WhatDidIJustKill.LOGGER.info("Config '{}' was set to default.", (Object)FILE_NAME);
            return success;
        }
        catch (Exception e) {
            WhatDidIJustKill.LOGGER.error("Error resetting config '{}'", (Object)FILE_NAME);
            WhatDidIJustKill.LOGGER.error(e.getMessage());
            return false;
        }
    }

    public static boolean reloadConfig() {
        try {
            return ConfigManager.loadAndVerifyConfig();
        }
        catch (Exception e) {
            WhatDidIJustKill.LOGGER.error("Error reloading config '{}'", (Object)FILE_NAME);
            WhatDidIJustKill.LOGGER.error(e.getMessage());
            return false;
        }
    }

    private static void createConfigFolder() {
        if (!CONFIG_DIR.exists() && !CONFIG_DIR.mkdirs()) {
            throw new RuntimeException("Could not create config folder: " + CONFIG_DIR.getAbsolutePath());
        }
    }

    private static void backupConfig() {
        String backupFileName = FILE_NAME.replace(".json", ".backup.txt");
        Path backupFilePath = Paths.get(CONFIG_DIR.getAbsolutePath(), backupFileName);
        try {
            List<String> lines = Files.readAllLines(CONFIG_FILE.toPath());
            Files.write(backupFilePath, lines, new OpenOption[0]);
            WhatDidIJustKill.LOGGER.warn("Created backup file '{}'", (Object)backupFileName);
        }
        catch (Exception e) {
            WhatDidIJustKill.LOGGER.error("Error creating backup file '{}'", (Object)backupFileName);
            WhatDidIJustKill.LOGGER.error(e.getMessage());
        }
    }
}

