/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.mixin;

import com.goby56.wakes.config.WakesConfig;
import com.goby56.wakes.config.enums.EffectSpawningRule;
import com.goby56.wakes.duck.ProducesWake;
import com.goby56.wakes.particle.custom.SplashPlaneParticle;
import com.goby56.wakes.utils.WakesUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3610;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1297.class})
public abstract class WakeSpawnerMixin
implements ProducesWake {
    @Shadow
    private class_243 field_22467;
    @Shadow
    private class_1937 field_6002;
    @Unique
    private boolean onFluidSurface = false;
    @Unique
    private class_243 prevPosOnSurface = null;
    @Unique
    private class_243 numericalVelocity = class_243.field_1353;
    @Unique
    private double horizontalNumericalVelocity = 0.0;
    @Unique
    private Float wakeHeight = null;
    @Unique
    private SplashPlaneParticle splashPlane;
    @Unique
    private boolean hasRecentlyTeleported = false;

    @Shadow
    public abstract String toString();

    @Shadow
    public abstract double method_23317();

    @Shadow
    public abstract class_238 method_5829();

    @Shadow
    public abstract double method_23321();

    @Shadow
    public abstract boolean method_5799();

    @Override
    public boolean wakes$onFluidSurface() {
        return this.onFluidSurface;
    }

    @Override
    public class_243 wakes$getNumericalVelocity() {
        return this.numericalVelocity;
    }

    @Override
    public double wakes$getHorizontalVelocity() {
        return this.horizontalNumericalVelocity;
    }

    @Override
    public class_243 wakes$getPrevPos() {
        return this.prevPosOnSurface;
    }

    @Override
    public void wakes$setPrevPos(class_243 pos) {
        this.prevPosOnSurface = pos;
    }

    @Override
    public Float wakes$wakeHeight() {
        return this.wakeHeight;
    }

    @Override
    public void wakes$setWakeHeight(float h) {
        this.wakeHeight = Float.valueOf(h);
    }

    @Override
    public void wakes$setSplashPlane(SplashPlaneParticle particle) {
        this.splashPlane = particle;
    }

    @Override
    public void wakes$setRecentlyTeleported(boolean b) {
        this.hasRecentlyTeleported = b;
    }

    @Override
    public SplashPlaneParticle wakes$getSplashPlane() {
        return this.splashPlane;
    }

    @Unique
    private boolean onFluidSurface() {
        double hitboxMaxY = this.method_5829().field_1325;
        class_2338 blockPos = class_2338.method_49637((double)this.method_23317(), (double)hitboxMaxY, (double)this.method_23321());
        class_3610 fluidState = this.field_6002.method_8316(blockPos);
        double fluidHeight = (float)blockPos.method_10264() + fluidState.method_15763((class_1922)this.field_6002, blockPos);
        return this.method_5799() && hitboxMaxY > fluidHeight;
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void tick(CallbackInfo info) {
        class_243 vel;
        this.onFluidSurface = this.onFluidSurface();
        class_1297 thisEntity = (class_1297)this;
        this.numericalVelocity = vel = this.calculateVelocity(thisEntity);
        this.horizontalNumericalVelocity = vel.method_37267();
        if (WakesConfig.disableMod) {
            return;
        }
        if (this.onFluidSurface && !this.hasRecentlyTeleported) {
            this.wakeHeight = Float.valueOf(WakesUtils.getFluidLevel(this.field_6002, thisEntity));
            class_243 currPos = new class_243(thisEntity.method_23317(), (double)this.wakeHeight.floatValue(), thisEntity.method_23321());
            this.spawnEffects(thisEntity);
            this.wakes$setPrevPos(currPos);
        } else {
            this.wakeHeight = null;
            this.prevPosOnSurface = null;
        }
        this.wakes$setRecentlyTeleported(false);
    }

    @Inject(at={@At(value="TAIL")}, method={"onSwimmingStart"})
    private void onSwimmingStart(CallbackInfo ci) {
        if (WakesConfig.disableMod) {
            return;
        }
        class_1297 thisEntity = (class_1297)this;
        EffectSpawningRule rule = WakesUtils.getEffectRuleFromSource(thisEntity);
        if (rule.simulateWakes) {
            if (this.wakeHeight == null) {
                this.wakeHeight = Float.valueOf(WakesUtils.getFluidLevel(this.field_6002, thisEntity));
            }
            WakesUtils.placeFallSplash((class_1297)this);
        }
    }

    @Unique
    private void spawnEffects(class_1297 thisEntity) {
        EffectSpawningRule rule = WakesUtils.getEffectRuleFromSource(thisEntity);
        if (rule.simulateWakes) {
            WakesUtils.placeWakeTrail(thisEntity);
        }
        if (rule.renderPlanes && this.splashPlane == null && this.horizontalNumericalVelocity > 0.01) {
            WakesUtils.spawnSplashPlane(this.field_6002, thisEntity);
        }
    }

    @Unique
    private class_243 calculateVelocity(class_1297 thisEntity) {
        if (thisEntity instanceof class_746) {
            return thisEntity.method_18798();
        }
        return this.prevPosOnSurface == null ? class_243.field_1353 : this.field_22467.method_1020(this.prevPosOnSurface);
    }
}

