/*
 * Decompiled with CFR 0.152.
 */
package net.villagerquests.util;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3988;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_898;
import net.villagerquests.access.MerchantAccessor;
import net.villagerquests.feature.QuestEntityModel;
import net.villagerquests.init.ConfigInit;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class QuestRenderHelper {
    private static final class_2960 QUEST_TEXTURE = new class_2960("villagerquests:textures/entity/quest_mark.png");

    public static void renderQuestMark(class_3988 merchantEntity, class_4587 matrixStack, class_898 dispatcher, class_327 textRenderer, class_4597 vertexConsumerProvider, QuestEntityModel<class_3988> questEntityModel, boolean hasLabel, int i) {
        int questMarkType;
        if (ConfigInit.CONFIG.showQuestIcon && (questMarkType = ((MerchantAccessor)merchantEntity).getQuestMarkType()) > 0 && Math.sqrt(dispatcher.method_23168((class_1297)merchantEntity)) < (double)ConfigInit.CONFIG.iconDistance && merchantEntity.method_37908().method_8320(merchantEntity.method_24515().method_10086(2)).method_26215()) {
            class_310 client = class_310.method_1551();
            class_746 player = client.field_1724;
            if (player != null) {
                matrixStack.method_22903();
                float height = ConfigInit.CONFIG.flatQuestIcon ? merchantEntity.method_17682() + 1.1f : merchantEntity.method_17682() + 2.0f;
                matrixStack.method_22904(0.0, (double)height, 0.0);
                if (hasLabel) {
                    matrixStack.method_22904(0.0, 0.3, 0.0);
                }
                matrixStack.method_22907(class_7833.field_40716.rotationDegrees(QuestRenderHelper.toEulerXyzDegrees(dispatcher.method_24197()).y()));
                if (ConfigInit.CONFIG.flatQuestIcon) {
                    matrixStack.method_22905(-0.1f, -0.1f, 0.1f);
                } else {
                    matrixStack.method_22905(-1.0f, -1.0f, 1.0f);
                }
                Matrix4f matrix4f = matrixStack.method_23760().method_23761();
                class_4588 vertexConsumers = vertexConsumerProvider.getBuffer(class_1921.method_23578((class_2960)QUEST_TEXTURE));
                if (ConfigInit.CONFIG.flatQuestIcon) {
                    class_2561 text = class_2561.method_30163((String)"?");
                    if (questMarkType == 2) {
                        text = class_2561.method_30163((String)"!");
                    }
                    float h = -textRenderer.method_27525((class_5348)text) / 2;
                    textRenderer.method_30882(text, h, 0.0f, -273152, false, matrix4f, vertexConsumerProvider, class_327.class_6415.field_33993, 0, i);
                } else {
                    questEntityModel.questionMark = true;
                    if (questMarkType == 2) {
                        questEntityModel.questionMark = false;
                    }
                    questEntityModel.method_2828(matrixStack, vertexConsumers, 0xF000F0, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                    questEntityModel.setAngles(merchantEntity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                }
                matrixStack.method_22909();
            }
        }
    }

    public static class_2561 getTimerText(int ticks) {
        int seconds = ticks / 20;
        if (seconds >= 3600) {
            return class_2561.method_43469((String)"ftbquests.quest.timer", (Object[])new Object[]{String.format("%02d:%02d:%02d", seconds / 3600, seconds % 3600 / 60, seconds % 60)}).method_27692(class_124.field_1080);
        }
        return class_2561.method_43469((String)"ftbquests.quest.timer", (Object[])new Object[]{String.format("%02d:%02d", seconds % 3600 / 60, seconds % 60)}).method_27692(class_124.field_1080);
    }

    private static Vector3f toEulerXyzDegrees(Quaternionf quaternionf) {
        Vector3f vec3f = QuestRenderHelper.toEulerXyz(quaternionf);
        return new Vector3f((float)Math.toDegrees(vec3f.x()), (float)Math.toDegrees(vec3f.y()), (float)Math.toDegrees(vec3f.z()));
    }

    private static Vector3f toEulerXyz(Quaternionf quaternionf) {
        float f = quaternionf.w() * quaternionf.w();
        float g = quaternionf.x() * quaternionf.x();
        float h = quaternionf.y() * quaternionf.y();
        float i = quaternionf.z() * quaternionf.z();
        float j = f + g + h + i;
        float k = 2.0f * quaternionf.w() * quaternionf.x() - 2.0f * quaternionf.y() * quaternionf.z();
        float l = (float)Math.asin(k / j);
        if (Math.abs(k) > 0.999f * j) {
            return new Vector3f(l, 2.0f * (float)Math.atan2(quaternionf.y(), quaternionf.w()), 0.0f);
        }
        return new Vector3f(l, (float)Math.atan2(2.0f * quaternionf.x() * quaternionf.z() + 2.0f * quaternionf.y() * quaternionf.w(), f - g - h + i), (float)Math.atan2(2.0f * quaternionf.x() * quaternionf.y() + 2.0f * quaternionf.w() * quaternionf.z(), f - g + h - i));
    }
}

