/*
 * Decompiled with CFR 0.152.
 */
package net.villagerquests.util;

import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import net.minecraft.class_3988;
import net.minecraft.server.MinecraftServer;
import net.villagerquests.access.QuestAccessor;
import net.villagerquests.access.TeamDataAccessor;
import net.villagerquests.data.VillagerQuestState;
import net.villagerquests.network.QuestServerPacket;

public class QuestHelper {
    public static int getVillagerQuestMarkType(class_3222 serverPlayerEntity, UUID uuid) {
        int questMarkType = 0;
        if (!serverPlayerEntity.method_37908().method_8608()) {
            TeamData teamData = ServerQuestFile.INSTANCE.getOrCreateTeamData((class_1297)serverPlayerEntity);
            if (teamData == null) {
                return -1;
            }
            boolean hasOpenQuest = false;
            for (int i = 0; i < ServerQuestFile.INSTANCE.getAllChapters().size(); ++i) {
                List quests = ((Chapter)ServerQuestFile.INSTANCE.getAllChapters().get(i)).getQuests();
                block1: for (int u = 0; u < quests.size(); ++u) {
                    Quest quest = (Quest)quests.get(u);
                    if (!((QuestAccessor)quest).isVillagerQuest() || !((QuestAccessor)quest).getVillagerQuestUuid().equals(uuid) || !((QuestAccessor)quest).isQuestVisible(teamData) || teamData.isCompleted((QuestObject)quest)) continue;
                    questMarkType = 1;
                    if (quest.isCompletedRaw(teamData)) {
                        Iterator iterator = quest.getRewards().iterator();
                        while (iterator.hasNext()) {
                            if (teamData.isRewardClaimed(serverPlayerEntity.method_5667(), (Reward)iterator.next())) continue;
                            questMarkType = 2;
                            break block1;
                        }
                        break;
                    }
                    if (teamData.isStarted((QuestObject)quest)) {
                        questMarkType = 0;
                        continue;
                    }
                    hasOpenQuest = true;
                }
                if (questMarkType == 2) break;
            }
            if (hasOpenQuest && questMarkType == 0) {
                questMarkType = 1;
            }
        }
        return questMarkType;
    }

    public static void removeVillagerQuestFromQuest(UUID villagerUuid) {
        for (int i = 0; i < ServerQuestFile.INSTANCE.getAllChapters().size(); ++i) {
            List quests = ((Chapter)ServerQuestFile.INSTANCE.getAllChapters().get(i)).getQuests();
            for (int u = 0; u < quests.size(); ++u) {
                Quest quest = (Quest)quests.get(u);
                if (!((QuestAccessor)quest).isVillagerQuest() || !((QuestAccessor)quest).getVillagerQuestUuid().equals(villagerUuid)) continue;
                ((QuestAccessor)quest).setVillagerQuest(false);
                ((QuestAccessor)quest).setVillagerQuestUuid(null);
                Iterator iterator = FTBQuestsAPI.api().getQuestFile(false).getAllTeamData().iterator();
                while (iterator.hasNext()) {
                    ((TeamDataAccessor)iterator.next()).setQuestStarted(quest.id, null);
                }
            }
        }
    }

    public static void updateTeamQuestMark(MinecraftServer server, TeamData data, UUID VillagerQuestUuid) {
        for (UUID uuid : ((Team)FTBTeamsAPI.api().getManager().getTeamByID(data.getTeamId()).get()).getMembers()) {
            int questMarkType = -1;
            if (server.method_3760().method_14602(uuid) != null) {
                questMarkType = QuestHelper.getVillagerQuestMarkType(server.method_3760().method_14602(uuid), VillagerQuestUuid);
                class_1297 class_12972 = server.method_3760().method_14602(uuid).method_51469().method_14190(VillagerQuestUuid);
                if (class_12972 instanceof class_3988) {
                    class_3988 merchantEntity = (class_3988)class_12972;
                    QuestServerPacket.writeS2CMerchantQuestMarkPacket(server.method_3760().method_14602(uuid), merchantEntity.method_5628(), questMarkType);
                }
            }
            VillagerQuestState.updatePlayerVillagerQuestMarkType(server, uuid, VillagerQuestUuid, questMarkType);
        }
    }
}

