/*
 * Decompiled with CFR 0.152.
 */
package net.villagerquests.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.net.ClaimRewardMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.libz.api.Tab;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3850;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_492;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import net.villagerquests.access.QuestAccessor;
import net.villagerquests.access.TeamDataAccessor;
import net.villagerquests.init.RenderInit;
import net.villagerquests.network.QuestClientPacket;
import net.villagerquests.screen.VillagerQuestScreenHandler;
import net.villagerquests.screen.widget.DescriptionWidget;
import net.villagerquests.util.QuestRenderHelper;

@Environment(value=EnvType.CLIENT)
public class VillagerQuestScreen
extends class_465<VillagerQuestScreenHandler>
implements Tab {
    private int indexStartOffset;
    private boolean scrolling;
    private int selectedIndex;
    private boolean showTabs;
    private Quest selectedQuest;
    private final WidgetButtonPage[] quests = new WidgetButtonPage[7];
    private AcceptButton acceptButton;
    private DeclineButton declineButton;
    private List<Quest> questList = new ArrayList<Quest>();
    private List<class_2561> descriptionList = new ArrayList<class_2561>();
    private TeamData teamData;

    public VillagerQuestScreen(VillagerQuestScreenHandler handler, class_1661 playerInventory, class_2561 title) {
        super((class_1703)handler, playerInventory, title);
        this.field_2792 = 276;
        this.teamData = ClientQuestFile.INSTANCE.selfTeamData;
        this.showTabs = true;
        for (int i = 0; i < ClientQuestFile.INSTANCE.getAllChapters().size(); ++i) {
            List quests = ((Chapter)ClientQuestFile.INSTANCE.getAllChapters().get(i)).getQuests();
            for (int u = 0; u < quests.size(); ++u) {
                Quest quest = (Quest)quests.get(u);
                if (!((QuestAccessor)quest).isVillagerQuest() || !((QuestAccessor)quest).getVillagerQuestUuid().equals(handler.offerer.method_5667()) || !((QuestAccessor)quest).isQuestVisible(this.teamData) || this.teamData.isCompleted((QuestObject)quest) && !quest.hasUnclaimedRewardsRaw(this.teamData, playerInventory.field_7546.method_5667()) && !quest.canBeRepeated()) continue;
                this.questList.add(quest);
            }
        }
    }

    public Class<?> getParentScreenClass() {
        return class_492.class;
    }

    public void method_25426() {
        super.method_25426();
        int i = (this.field_22789 - this.field_2792) / 2;
        int j = (this.field_22790 - this.field_2779) / 2;
        int k = j + 16 + 2;
        this.selectedQuest = null;
        this.descriptionList.clear();
        this.acceptButton = (AcceptButton)this.method_37063((class_364)new AcceptButton(i + 161, j + 139, button -> {
            if (this.selectedQuest != null) {
                if (this.selectedQuest.isCompletedRaw(this.teamData)) {
                    QuestClientPacket.writeC2SCompleteQuestPacket(this.selectedQuest.id);
                    for (Reward reward : this.selectedQuest.getRewards()) {
                        new ClaimRewardMessage(reward.id, true).sendToServer();
                    }
                    this.removeQuest(this.selectedQuest);
                } else {
                    ((TeamDataAccessor)this.teamData).setQuestStarted(this.selectedQuest.id, new Date());
                    QuestClientPacket.writeC2SAcceptQuestPacket(this.selectedQuest.id, true);
                    this.acceptButton.field_22763 = false;
                    this.declineButton.field_22763 = true;
                    this.declineButton.field_22764 = true;
                    this.acceptButton.method_25355((class_2561)class_2561.method_43471((String)"screen.villagerquests.completeButton"));
                }
            }
        }));
        this.acceptButton.method_25355((class_2561)class_2561.method_43471((String)"screen.villagerquests.acceptButton"));
        this.declineButton = (DeclineButton)this.method_37063((class_364)new DeclineButton(i + 247, j + 140, button -> {
            if (this.selectedQuest != null) {
                ((TeamDataAccessor)this.teamData).setQuestStarted(this.selectedQuest.id, null);
                QuestClientPacket.writeC2SAcceptQuestPacket(this.selectedQuest.id, false);
                this.declineButton.field_22764 = false;
                this.acceptButton.field_22764 = false;
                this.quests[this.selectedIndex].field_22763 = false;
                this.selectedQuest = null;
                this.descriptionList.clear();
            }
        }));
        for (int l = 0; l < 7; ++l) {
            this.quests[l] = (WidgetButtonPage)this.method_37063((class_364)new WidgetButtonPage(i + 5, k, l, this.questList.size() > l ? this.questList.get(l) : null, button -> {
                if (button instanceof WidgetButtonPage) {
                    WidgetButtonPage widgetButtonPage = (WidgetButtonPage)button;
                    this.selectedIndex = widgetButtonPage.getIndex() + this.indexStartOffset;
                    this.selectedQuest = this.questList.get(this.selectedIndex);
                    this.descriptionList.clear();
                    this.descriptionList.addAll(this.selectedQuest.getDescription());
                    if (this.selectedQuest.isCompletedRaw(this.teamData)) {
                        this.acceptButton.method_25355((class_2561)class_2561.method_43471((String)"screen.villagerquests.completeButton"));
                        this.acceptButton.field_22763 = true;
                        this.declineButton.field_22763 = true;
                        this.declineButton.field_22764 = true;
                    } else if (this.teamData.isStarted((QuestObject)this.selectedQuest)) {
                        this.acceptButton.method_25355((class_2561)class_2561.method_43471((String)"screen.villagerquests.completeButton"));
                        this.acceptButton.field_22763 = false;
                        this.declineButton.field_22763 = true;
                        this.declineButton.field_22764 = true;
                    } else {
                        this.acceptButton.method_25355((class_2561)class_2561.method_43471((String)"screen.villagerquests.acceptButton"));
                        this.acceptButton.field_22763 = true;
                        this.declineButton.field_22763 = false;
                        this.declineButton.field_22764 = false;
                    }
                    this.acceptButton.field_22764 = true;
                }
            }));
            k += 20;
        }
        this.method_37063((class_364)new DescriptionWidget(i + 111, j + 21, 154, 113, this.descriptionList, this.field_22793));
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        int i = (this.field_22789 - this.field_2792) / 2;
        int j = (this.field_22790 - this.field_2779) / 2;
        context.method_25290(RenderInit.VILLAGERQUEST_SCREEN_AND_ICONS, i, j, 0.0f, 0.0f, this.field_2792, this.field_2779, 512, 512);
        if (this.selectedQuest != null) {
            context.method_25290(RenderInit.VILLAGERQUEST_SCREEN_AND_ICONS, i + 107, j + 17, 276.0f, 0.0f, 162, 142, 512, 512);
        }
    }

    private void removeQuest(Quest quest) {
        if (quest.canBeRepeated()) {
            this.quests[this.selectedIndex].field_22763 = false;
        } else {
            this.quests[this.selectedIndex].field_22764 = false;
            this.questList.remove(this.selectedIndex);
        }
        this.acceptButton.field_22764 = false;
        this.declineButton.field_22764 = false;
        this.selectedQuest = null;
        this.descriptionList.clear();
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        class_3850 villagerData = null;
        int i = 0;
        if (((VillagerQuestScreenHandler)this.field_2797).offerer instanceof class_1646) {
            villagerData = ((class_1646)((VillagerQuestScreenHandler)this.field_2797).offerer).method_7231();
            i = villagerData.method_16925();
        }
        class_2561 title = ((VillagerQuestScreenHandler)this.field_2797).offerer.method_5477();
        if (i > 0 && i <= 5) {
            class_5250 text = title.method_27661().method_27693(" - ").method_10852((class_2561)class_2561.method_43471((String)("merchant.level." + i)));
            int j = this.field_22793.method_27525((class_5348)text);
            int k = 49 + this.field_2792 / 2 - j / 2;
            context.method_51439(this.field_22793, (class_2561)text, k, 6, 0x404040, false);
        } else {
            context.method_51439(this.field_22793, title, 49 + this.field_2792 / 2 - this.field_22793.method_27525((class_5348)this.field_22785) / 2, 6, 0x404040, false);
        }
        int l = this.field_22793.method_27525((class_5348)class_2561.method_43471((String)"screen.villagerquests"));
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"screen.villagerquests"), 5 - l / 2 + 48, 6, 0x404040, false);
    }

    private void renderScrollbar(class_332 context, int x, int y, List<Quest> questList) {
        int i = questList.size() + 1 - 7;
        if (i > 1) {
            int j = 139 - (27 + (i - 1) * 139 / i);
            int k = 1 + j / i + 139 / i;
            int m = Math.min(113, this.indexStartOffset * k);
            if (this.indexStartOffset == i - 1) {
                m = 113;
            }
            context.method_25290(RenderInit.VILLAGERQUEST_SCREEN_AND_ICONS, x + 94, y + 18 + m, 438.0f, 0.0f, 6, 27, 512, 512);
        } else {
            context.method_25290(RenderInit.VILLAGERQUEST_SCREEN_AND_ICONS, x + 94, y + 18, 444.0f, 0.0f, 6, 27, 512, 512);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        int i = this.questList.size();
        if (this.canScroll(i)) {
            int j = i - 7;
            this.indexStartOffset = (int)((double)this.indexStartOffset - amount);
            this.indexStartOffset = class_3532.method_15340((int)this.indexStartOffset, (int)0, (int)j);
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    private boolean canScroll(int listSize) {
        return listSize > 7;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        int i = this.questList.size();
        if (this.scrolling) {
            int j = this.field_2800 + 18;
            int k = j + 139;
            int l = i - 7;
            float f = ((float)mouseY - (float)j - 13.5f) / ((float)(k - j) - 27.0f);
            f = f * (float)l + 0.5f;
            this.indexStartOffset = class_3532.method_15340((int)((int)f), (int)0, (int)l);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        int i = (this.field_22789 - this.field_2792) / 2;
        int j = (this.field_22790 - this.field_2779) / 2;
        if (this.canScroll(this.questList.size()) && mouseX > (double)(i + 94) && mouseX < (double)(i + 94 + 6) && mouseY > (double)(j + 18) && mouseY <= (double)(j + 18 + 139 + 1)) {
            this.scrolling = true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        super.method_25394(context, mouseX, mouseY, delta);
        if (!this.questList.isEmpty()) {
            this.renderScrollbar(context, this.field_2776, this.field_2800, this.questList);
            int k = this.field_2800 + 19;
            int m = 0;
            for (Quest quest : this.questList) {
                if (this.canScroll(this.questList.size()) && (m < this.indexStartOffset || m >= 7 + this.indexStartOffset)) {
                    ++m;
                    continue;
                }
                if (this.field_22793.method_27525((class_5348)quest.getTitle()) > 82) {
                    context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)(this.field_22793.method_27523(quest.getTitle().getString(), 78) + "..")).method_10862(quest.getTitle().method_10866()), this.field_2776 + 9, k + 5, 0xFFFFFF, false);
                } else {
                    context.method_51439(this.field_22793, quest.getTitle(), this.field_2776 + 9, k + 5, 0xFFFFFF, false);
                }
                k += 20;
                ++m;
            }
            for (WidgetButtonPage widgetButtonPage : this.quests) {
                widgetButtonPage.field_22764 = widgetButtonPage.index < this.questList.size();
            }
            RenderSystem.enableDepthTest();
            this.method_2380(context, mouseX, mouseY);
        }
    }

    public void setShowTabs(boolean showTabs) {
        this.showTabs = showTabs;
    }

    public boolean showTabs() {
        return this.showTabs;
    }

    private class WidgetButtonPage
    extends class_4185 {
        final int index;
        final Quest quest;

        public WidgetButtonPage(int x, int y, int index, Quest quest, class_4185.class_4241 onPress) {
            super(x, y, 89, 20, class_5244.field_39003, onPress, field_40754);
            this.index = index;
            this.quest = quest;
            this.field_22764 = false;
        }

        public int getIndex() {
            return this.index;
        }

        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
            super.method_25394(context, mouseX, mouseY, delta);
        }

        protected void method_49604(class_332 context, class_327 textRenderer, int xMargin, int color) {
            super.method_49604(context, textRenderer, xMargin, color);
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            if (((VillagerQuestScreen)VillagerQuestScreen.this).field_22787.field_1772.method_27525((class_5348)this.quest.getTitle()) > 82) {
                list.add(this.quest.getTitle());
            }
            if (((VillagerQuestScreen)VillagerQuestScreen.this).field_22787.field_1724 != null && ((QuestAccessor)this.quest).getTimer() > 0) {
                if (!((TeamDataAccessor)TeamData.get((class_1657)((VillagerQuestScreen)VillagerQuestScreen.this).field_22787.field_1724)).getTimer().isEmpty() && ((TeamDataAccessor)TeamData.get((class_1657)((VillagerQuestScreen)VillagerQuestScreen.this).field_22787.field_1724)).getTimer().containsKey(this.quest.id)) {
                    list.add(QuestRenderHelper.getTimerText(((QuestAccessor)this.quest).getTimer() - Math.toIntExact(((VillagerQuestScreen)VillagerQuestScreen.this).field_22787.field_1724.method_37908().method_8510() - ((TeamDataAccessor)TeamData.get((class_1657)((VillagerQuestScreen)VillagerQuestScreen.this).field_22787.field_1724)).getTimer().get(this.quest.id))));
                } else {
                    list.add(QuestRenderHelper.getTimerText(((QuestAccessor)this.quest).getTimer()));
                }
            }
            if (!list.isEmpty()) {
                context.method_51434(textRenderer, VillagerQuestScreen.this.descriptionList, xMargin, color);
            }
        }
    }

    private class AcceptButton
    extends class_4185 {
        public AcceptButton(int x, int y, class_4185.class_4241 onPress) {
            super(x, y, 55, 17, class_5244.field_39003, onPress, field_40754);
            this.field_22764 = false;
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            class_310 minecraftClient = class_310.method_1551();
            context.method_51422(1.0f, 1.0f, 1.0f, this.field_22765);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            context.method_25293(RenderInit.VILLAGERQUEST_SCREEN_AND_ICONS, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), 0.0f, (float)(166 + this.getTextureY()), this.method_25368(), this.method_25364(), 512, 512);
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            int i = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
            this.method_48589(context, minecraftClient.field_1772, i | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
        }

        private int getTextureY() {
            int i = 1;
            if (!this.field_22763) {
                i = 0;
            } else if (this.method_25367()) {
                i = 2;
            }
            return i * 17;
        }
    }

    private class DeclineButton
    extends class_4185 {
        public DeclineButton(int x, int y, class_4185.class_4241 onPress) {
            super(x, y, 16, 15, class_5244.field_39003, onPress, field_40754);
            this.field_22764 = false;
            this.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"screen.villagerquests.declineButton")));
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            context.method_51422(1.0f, 1.0f, 1.0f, this.field_22765);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            context.method_25293(RenderInit.VILLAGERQUEST_SCREEN_AND_ICONS, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), 55.0f, (float)(166 + (this.method_49606() ? 15 : 0)), this.method_25368(), this.method_25364(), 512, 512);
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

