/*
 * Decompiled with CFR 0.152.
 */
package net.villagerquests.network;

import dev.ftb.mods.ftbquests.events.QuestProgressEventData;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import io.netty.buffer.Unpooled;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.libz.network.LibzServerPacket;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3988;
import net.minecraft.class_747;
import net.villagerquests.access.MerchantAccessor;
import net.villagerquests.access.MerchantScreenHandlerAccessor;
import net.villagerquests.access.QuestAccessor;
import net.villagerquests.access.TeamDataAccessor;
import net.villagerquests.data.VillagerQuestState;
import net.villagerquests.ftb.VillagerTalkTask;
import net.villagerquests.screen.VillagerQuestScreenHandler;
import net.villagerquests.util.QuestHelper;

public class QuestServerPacket {
    public static final class_2960 SET_SCREEN = new class_2960("villagerquest", "set_screen");
    public static final class_2960 CLOSE_SCREEN = new class_2960("villagerquest", "close_screen");
    public static final class_2960 SET_QUEST_OFFERER = new class_2960("villagerquest", "set_quest_offerer");
    public static final class_2960 SET_MERCHANT_QUEST_MARK = new class_2960("villagerquest", "set_merchant_quest_mark");
    public static final class_2960 UPDATE_MERCHANT_QUEST_MARK = new class_2960("villagerquest", "update_merchant_quest_mark");
    public static final class_2960 ACCEPT_QUEST = new class_2960("villagerquest", "accept_quest");
    public static final class_2960 COMPLETE_QUEST = new class_2960("villagerquest", "complete_quest");
    public static final class_2960 FAIL_QUEST = new class_2960("villagerquest", "fail_quest");
    public static final class_2960 OFFERS_TRADES = new class_2960("villagerquest", "offers_trades");
    public static final class_2960 TALK = new class_2960("villagerquest", "talk");
    public static final class_2960 COMPLETE_TALK = new class_2960("villagerquest", "complete_talk");
    public static final class_2960 OP_MERCHANT_SCREEN_PACKET = new class_2960("villagerquest", "op_merchant_screen");
    public static final class_2960 OP_MERCHANT_PACKET = new class_2960("villagerquest", "op_merchant");

    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SET_SCREEN, (server, player, handler, buffer, sender) -> {
            int villagerId = buffer.readInt();
            int mouseX = buffer.readInt();
            int mouseY = buffer.readInt();
            Boolean questScreen = buffer.readBoolean();
            server.execute(() -> {
                if (player.field_7512 instanceof MerchantScreenHandlerAccessor) {
                    ((MerchantScreenHandlerAccessor)player.field_7512).setSwitchingScreen(true);
                }
                if (questScreen.booleanValue()) {
                    player.method_17355((class_3908)new class_747((syncId, playerInventory, playerx) -> new VillagerQuestScreenHandler(syncId, playerInventory), class_2561.method_30163((String)"")));
                } else {
                    class_3988 merchantEntity = (class_3988)player.method_37908().method_8469(villagerId);
                    if (merchantEntity instanceof class_1646) {
                        class_1646 villagerEntity = (class_1646)merchantEntity;
                        villagerEntity.method_17449((class_1657)player, villagerEntity.method_5476(), villagerEntity.method_7231().method_16925());
                    } else {
                        merchantEntity.method_17449((class_1657)player, merchantEntity.method_5476(), 1);
                    }
                }
                LibzServerPacket.writeS2CMousePositionPacket((class_3222)player, (int)mouseX, (int)mouseY);
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ACCEPT_QUEST, (server, player, handler, buffer, sender) -> {
            long questId = buffer.readLong();
            boolean acceptQuest = buffer.readBoolean();
            server.execute(() -> {
                QuestAccessor questAccessor;
                Quest quest = ServerQuestFile.INSTANCE.getQuest(questId);
                TeamData teamData = TeamData.get((class_1657)player);
                Quest patt4819$temp = quest;
                if (patt4819$temp instanceof QuestAccessor && (questAccessor = (QuestAccessor)patt4819$temp).isQuestVisible(teamData)) {
                    ((TeamDataAccessor)teamData).setQuestStarted(questId, acceptQuest ? new Date() : null);
                    int questMarkType = QuestHelper.getVillagerQuestMarkType(player, questAccessor.getVillagerQuestUuid());
                    for (UUID uuid : ((Team)FTBTeamsAPI.api().getManager().getTeamByID(teamData.getTeamId()).get()).getMembers()) {
                        class_1297 patt5600$temp;
                        if (server.method_3760().method_14602(uuid) != null && (patt5600$temp = server.method_3760().method_14602(uuid).method_51469().method_14190(questAccessor.getVillagerQuestUuid())) instanceof class_3988) {
                            class_3988 merchantEntity = (class_3988)patt5600$temp;
                            QuestServerPacket.writeS2CMerchantQuestMarkPacket(server.method_3760().method_14602(uuid), merchantEntity.method_5628(), questMarkType);
                        }
                        VillagerQuestState.updatePlayerVillagerQuestMarkType(server, uuid, questAccessor.getVillagerQuestUuid(), questMarkType);
                    }
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)COMPLETE_QUEST, (server, player, handler, buffer, sender) -> {
            long questId = buffer.readLong();
            server.execute(() -> {
                QuestAccessor questAccessor;
                Quest quest = ServerQuestFile.INSTANCE.getQuest(questId);
                TeamData data = TeamData.get((class_1657)player);
                Quest patt6420$temp = quest;
                if (patt6420$temp instanceof QuestAccessor && (questAccessor = (QuestAccessor)patt6420$temp).isQuestVisible(data) && questAccessor.isVillagerQuest()) {
                    if (quest.isCompletedRaw(data) && !data.isCompleted((QuestObject)quest)) {
                        List onlineMembers = data.getOnlineMembers();
                        List notifiedPlayers = QuestObjectBase.shouldSendNotifications() ? onlineMembers : List.of();
                        QuestProgressEventData questProgressEventData = new QuestProgressEventData(new Date(), data, (QuestObject)quest, onlineMembers, notifiedPlayers);
                        quest.onCompleted(questProgressEventData);
                        QuestHelper.updateTeamQuestMark(server, data, questAccessor.getVillagerQuestUuid());
                    } else {
                        int questMarkType = QuestHelper.getVillagerQuestMarkType(player, questAccessor.getVillagerQuestUuid());
                        class_1297 patt7683$temp = player.method_51469().method_14190(questAccessor.getVillagerQuestUuid());
                        if (patt7683$temp instanceof class_3988) {
                            class_3988 merchantEntity = (class_3988)patt7683$temp;
                            QuestServerPacket.writeS2CMerchantQuestMarkPacket(player, merchantEntity.method_5628(), questMarkType);
                        }
                        VillagerQuestState.updatePlayerVillagerQuestMarkType(server, player.method_5667(), questAccessor.getVillagerQuestUuid(), questMarkType);
                    }
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)OP_MERCHANT_PACKET, (server, player, handler, buffer, sender) -> {
            int id = buffer.readInt();
            String merchantName = buffer.method_19772();
            boolean changeableName = buffer.readBoolean();
            boolean invincibility = buffer.readBoolean();
            boolean hasAi = buffer.readBoolean();
            boolean offersTrades = buffer.readBoolean();
            server.execute(() -> {
                class_1297 patt8654$temp;
                if (player.method_7338() && (patt8654$temp = player.method_51469().method_8469(id)) instanceof class_3988) {
                    class_3988 merchantEntity = (class_3988)patt8654$temp;
                    if (!merchantEntity.method_5477().getString().equals(merchantName)) {
                        ((MerchantAccessor)merchantEntity).setChangeableName(true);
                        merchantEntity.method_5665((class_2561)class_2561.method_43470((String)merchantName));
                    }
                    ((MerchantAccessor)merchantEntity).setChangeableName(changeableName);
                    merchantEntity.method_5684(invincibility);
                    merchantEntity.method_5977(!hasAi);
                    ((MerchantAccessor)merchantEntity).setOffersTrades(offersTrades);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)UPDATE_MERCHANT_QUEST_MARK, (server, player, handler, buffer, sender) -> {
            UUID villagerUuid = buffer.method_10790();
            server.execute(() -> {
                List list = server.method_3760().method_14571();
                for (int i = 0; i < list.size(); ++i) {
                    int questMarkType = -1;
                    if (((class_3222)list.get(i)).method_51469().method_14190(villagerUuid) != null) {
                        questMarkType = QuestHelper.getVillagerQuestMarkType((class_3222)list.get(i), villagerUuid);
                        QuestServerPacket.writeS2CMerchantQuestMarkPacket((class_3222)list.get(i), ((class_3222)list.get(i)).method_51469().method_14190(villagerUuid).method_5628(), questMarkType);
                    }
                    VillagerQuestState.updatePlayerVillagerQuestMarkType(server, ((class_3222)list.get(i)).method_5667(), villagerUuid, questMarkType);
                }
                for (UUID playerUuid : VillagerQuestState.getPlayerVillagerQuestState(server, villagerUuid).getMerchantQuestMarkMap().keySet()) {
                    if (server.method_3760().method_14602(playerUuid) != null) continue;
                    VillagerQuestState.getPlayerVillagerQuestState(server, playerUuid).getMerchantQuestMarkMap().put(villagerUuid, -1);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)COMPLETE_TALK, (server, player, handler, buffer, sender) -> {
            int merchantEntityId = buffer.readInt();
            long questId = buffer.readLong();
            server.execute(() -> {
                class_1297 patt11211$temp = player.method_51469().method_8469(merchantEntityId);
                if (patt11211$temp instanceof class_3988) {
                    class_3988 merchantEntity = (class_3988)patt11211$temp;
                    ServerQuestFile.INSTANCE.getQuest(questId).getTasks().forEach(task -> {
                        if (task instanceof VillagerTalkTask) {
                            VillagerTalkTask villagerTalkTask = (VillagerTalkTask)((Object)((Object)((Object)task)));
                            villagerTalkTask.talk(TeamData.get((class_1657)player), (class_1309)merchantEntity);
                            merchantEntity.method_8259(null);
                        }
                    });
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CLOSE_SCREEN, (server, player, handler, buffer, sender) -> {
            int merchantEntityId = buffer.readInt();
            server.execute(() -> {
                class_1297 patt11953$temp = player.method_51469().method_8469(merchantEntityId);
                if (patt11953$temp instanceof class_3988) {
                    class_3988 merchantEntity = (class_3988)patt11953$temp;
                    merchantEntity.method_8259(null);
                }
            });
        });
    }

    public static void writeS2COffererPacket(class_3222 serverPlayerEntity, int merchantEntityId) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(merchantEntityId);
        class_2658 packet = new class_2658(SET_QUEST_OFFERER, buf);
        serverPlayerEntity.field_13987.method_14364((class_2596)packet);
    }

    public static void writeS2CMerchantQuestMarkPacket(class_3222 serverPlayerEntity, int merchantEntityId, int questMarkType) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(merchantEntityId);
        buf.writeInt(questMarkType);
        class_2658 packet = new class_2658(SET_MERCHANT_QUEST_MARK, buf);
        serverPlayerEntity.field_13987.method_14364((class_2596)packet);
    }

    public static void writeS2COpMerchantScreenPacket(class_3222 serverPlayerEntity, class_3988 merchantEntity) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(merchantEntity.method_5628());
        buf.writeBoolean(((MerchantAccessor)merchantEntity).getChangeableName());
        buf.writeBoolean(merchantEntity.method_5655());
        buf.writeBoolean(((MerchantAccessor)merchantEntity).getOffersTrades());
        class_2658 packet = new class_2658(OP_MERCHANT_SCREEN_PACKET, buf);
        serverPlayerEntity.field_13987.method_14364((class_2596)packet);
    }

    public static void writeS2COffersTradesPacket(class_3222 serverPlayerEntity, int merchantEntityId, boolean offersTrades) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(merchantEntityId);
        buf.writeBoolean(offersTrades);
        class_2658 packet = new class_2658(OFFERS_TRADES, buf);
        serverPlayerEntity.field_13987.method_14364((class_2596)packet);
    }

    public static void writeS2CTalkPacket(class_3222 serverPlayerEntity, int merchantEntityId, long questId) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(merchantEntityId);
        buf.writeLong(questId);
        class_2658 packet = new class_2658(TALK, buf);
        serverPlayerEntity.field_13987.method_14364((class_2596)packet);
    }

    public static void writeS2CFailQuestPacket(class_3222 serverPlayerEntity, long questId) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeLong(questId);
        class_2658 packet = new class_2658(FAIL_QUEST, buf);
        serverPlayerEntity.field_13987.method_14364((class_2596)packet);
    }
}

