/*
 * Decompiled with CFR 0.152.
 */
package net.villagerquests.network;

import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.util.TextUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Iterator;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_3988;
import net.minecraft.class_437;
import net.villagerquests.access.MerchantAccessor;
import net.villagerquests.ftb.FailQuestToast;
import net.villagerquests.ftb.VillagerTalkTask;
import net.villagerquests.network.QuestServerPacket;
import net.villagerquests.screen.VillagerQuestOpScreen;
import net.villagerquests.screen.VillagerQuestTalkScreen;

@Environment(value=EnvType.CLIENT)
public class QuestClientPacket {
    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)QuestServerPacket.SET_QUEST_OFFERER, (client, handler, buf, sender) -> {
            int id = buf.readInt();
            client.execute(() -> {
                class_1297 patt1362$temp = client.field_1687.method_8469(id);
                if (patt1362$temp instanceof class_3988) {
                    class_3988 merchantEntity = (class_3988)patt1362$temp;
                    merchantEntity.method_8259((class_1657)client.field_1724);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)QuestServerPacket.SET_MERCHANT_QUEST_MARK, (client, handler, buf, sender) -> {
            int id = buf.readInt();
            int questMarkType = buf.readInt();
            client.execute(() -> {
                class_1297 patt1815$temp = client.field_1687.method_8469(id);
                if (patt1815$temp instanceof class_3988) {
                    class_3988 merchantEntity = (class_3988)patt1815$temp;
                    ((MerchantAccessor)merchantEntity).setQuestMarkType(questMarkType);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)QuestServerPacket.OP_MERCHANT_SCREEN_PACKET, (client, handler, buf, sender) -> {
            int id = buf.readInt();
            boolean defaultChangeableName = buf.readBoolean();
            boolean defaultInvincibility = buf.readBoolean();
            boolean defaultOffersTrades = buf.readBoolean();
            client.execute(() -> {
                class_1297 patt2525$temp;
                if (client.field_1724 != null && client.field_1724.method_7338() && client.field_1687 != null && (patt2525$temp = client.field_1687.method_8469(id)) instanceof class_3988) {
                    class_3988 merchantEntity = (class_3988)patt2525$temp;
                    client.method_1507((class_437)new VillagerQuestOpScreen(merchantEntity, defaultChangeableName, defaultInvincibility, defaultOffersTrades));
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)QuestServerPacket.OFFERS_TRADES, (client, handler, buf, sender) -> {
            int id = buf.readInt();
            boolean offersTrades = buf.readBoolean();
            client.execute(() -> {
                class_1297 patt3059$temp = client.field_1687.method_8469(id);
                if (patt3059$temp instanceof class_3988) {
                    class_3988 merchantEntity = (class_3988)patt3059$temp;
                    ((MerchantAccessor)merchantEntity).setOffersTrades(offersTrades);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)QuestServerPacket.TALK, (client, handler, buf, sender) -> {
            int id = buf.readInt();
            long questId = buf.readLong();
            client.execute(() -> {
                class_1297 patt3513$temp = client.field_1687.method_8469(id);
                if (patt3513$temp instanceof class_3988) {
                    class_3988 merchantEntity = (class_3988)patt3513$temp;
                    QuestObject patt3595$temp = ClientQuestFile.INSTANCE.get(questId);
                    if (patt3595$temp instanceof Quest) {
                        Quest quest = (Quest)patt3595$temp;
                        Iterator iterator = quest.getTasks().iterator();
                        TeamData teamData = ClientQuestFile.INSTANCE.selfTeamData;
                        while (iterator.hasNext()) {
                            Task task = (Task)iterator.next();
                            if (!(task instanceof VillagerTalkTask)) continue;
                            VillagerTalkTask villagerTalkTask = (VillagerTalkTask)task;
                            if (teamData.getProgress(task) >= task.getMaxProgress() || !teamData.canStartTasks(task.getQuest())) continue;
                            client.method_1507((class_437)new VillagerQuestTalkScreen(merchantEntity, questId, villagerTalkTask.getTalkTextList().stream().map(TextUtils::parseRawText).toList()));
                        }
                    }
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)QuestServerPacket.FAIL_QUEST, (client, handler, buf, sender) -> {
            long questId = buf.readLong();
            client.execute(() -> {
                QuestObject object = ClientQuestFile.INSTANCE.get(questId);
                if (object != null) {
                    client.method_1566().method_1999((class_368)new FailQuestToast(object));
                }
            });
        });
    }

    public static void writeC2SScreenPacket(class_3988 merchantEntity, int mouseX, int mouseY, boolean villagerScreen) {
        ((MerchantAccessor)merchantEntity).setOffersTrades(true);
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(merchantEntity.method_5628());
        buf.writeInt(mouseX);
        buf.writeInt(mouseY);
        buf.writeBoolean(villagerScreen);
        class_2817 packet = new class_2817(QuestServerPacket.SET_SCREEN, buf);
        class_310.method_1551().method_1562().method_2883((class_2596)packet);
    }

    public static void writeC2SAcceptQuestPacket(long questId, boolean acceptQuest) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeLong(questId);
        buf.writeBoolean(acceptQuest);
        class_2817 packet = new class_2817(QuestServerPacket.ACCEPT_QUEST, new class_2540((ByteBuf)buf));
        class_310.method_1551().method_1562().method_2883((class_2596)packet);
    }

    public static void writeC2SCompleteQuestPacket(long questId) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeLong(questId);
        class_2817 packet = new class_2817(QuestServerPacket.COMPLETE_QUEST, new class_2540((ByteBuf)buf));
        class_310.method_1551().method_1562().method_2883((class_2596)packet);
    }

    public static void writeC2SOpMerchantPacket(int merchantEntityId, String merchantName, boolean changeableName, boolean invincibility, boolean hasAi, boolean offersTrades) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(merchantEntityId);
        buf.method_10814(merchantName);
        buf.writeBoolean(changeableName);
        buf.writeBoolean(invincibility);
        buf.writeBoolean(hasAi);
        buf.writeBoolean(offersTrades);
        class_2817 packet = new class_2817(QuestServerPacket.OP_MERCHANT_PACKET, new class_2540((ByteBuf)buf));
        class_310.method_1551().method_1562().method_2883((class_2596)packet);
    }

    public static void writeC2SUpdateMerchantQuestMark(UUID uuid) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10797(uuid);
        class_2817 packet = new class_2817(QuestServerPacket.UPDATE_MERCHANT_QUEST_MARK, new class_2540((ByteBuf)buf));
        class_310.method_1551().method_1562().method_2883((class_2596)packet);
    }

    public static void writeC2STalkPacket(int merchantEntityId, long questId) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(merchantEntityId);
        buf.writeLong(questId);
        class_2817 packet = new class_2817(QuestServerPacket.COMPLETE_TALK, new class_2540((ByteBuf)buf));
        class_310.method_1551().method_1562().method_2883((class_2596)packet);
    }

    public static void writeC2SCloseScreenPacket(int merchantEntityId) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(merchantEntityId);
        class_2817 packet = new class_2817(QuestServerPacket.CLOSE_SCREEN, new class_2540((ByteBuf)buf));
        class_310.method_1551().method_1562().method_2883((class_2596)packet);
    }
}

