/*
 * Decompiled with CFR 0.152.
 */
package net.villagerquests.mixin.ftb.client;

import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.CursorType;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.client.gui.quests.ViewQuestPanel;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1301;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3966;
import net.minecraft.class_3988;
import net.villagerquests.access.MerchantAccessor;
import net.villagerquests.access.QuestAccessor;
import net.villagerquests.init.RenderInit;
import net.villagerquests.network.QuestClientPacket;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Environment(value=EnvType.CLIENT)
@Mixin(value={ViewQuestPanel.class})
public abstract class ViewQuestPanelMixin
extends Panel {
    @Shadow(remap=false)
    private Quest quest;
    @Shadow(remap=false)
    private TextField titleField;

    public ViewQuestPanelMixin(Panel panel) {
        super(panel);
    }

    @Inject(method={"addWidgets"}, at={@At(value="INVOKE", target="Ljava/lang/Math;min(II)I", shift=At.Shift.AFTER, ordinal=0)}, locals=LocalCapture.CAPTURE_FAILSOFT, remap=false)
    private void addWidgetsMixin(CallbackInfo info, QuestObjectBase prev, boolean canEdit) {
        int iconSize = Math.min(16, this.titleField.height + 2);
        ViewVillagerQuestButton buttonVillagerQuest = new ViewVillagerQuestButton(this.quest, canEdit);
        this.add((Widget)buttonVillagerQuest);
        buttonVillagerQuest.setPosAndSize(this.posX + iconSize + 8, 5, iconSize, iconSize);
    }

    private class ViewVillagerQuestButton
    extends SimpleTextButton {
        private final Quest quest;
        private final boolean canEdit;
        private boolean villagerQuest;

        public ViewVillagerQuestButton(Quest quest, boolean canEdit) {
            super((Panel)((ViewQuestPanel)ViewQuestPanelMixin.this), (class_2561)class_2561.method_43471((String)"ftbquests.quest.misc.villager_quest"), ItemIcon.getItemIcon((class_1792)class_1802.field_8529));
            this.villagerQuest = false;
            this.quest = quest;
            this.canEdit = canEdit;
            if (this.quest != null) {
                this.villagerQuest = ((QuestAccessor)this.quest).isVillagerQuest() && ((QuestAccessor)this.quest).getVillagerQuestUuid() != null;
            }
        }

        public void onClicked(MouseButton button) {
            if (this.canEdit) {
                this.playClickSound();
                String villagerUuidString = ((QuestAccessor)this.quest).getVillagerQuestUuid() != null ? ((QuestAccessor)this.quest).getVillagerQuestUuid().toString() : "";
                UUID oldVillagerUuid = ((QuestAccessor)this.quest).getVillagerQuestUuid();
                if (button.isRight() && villagerUuidString.equals("")) {
                    class_310 client = class_310.method_1551();
                    if (client.field_1765 != null && client.field_1765.method_17783() == class_239.class_240.field_1331) {
                        villagerUuidString = ((class_3966)client.field_1765).method_17782().method_5667().toString();
                    }
                }
                StringConfig c = new StringConfig(null);
                EditConfigFromStringScreen.open((ConfigFromString)c, (Object)villagerUuidString, (Object)"", (class_2561)class_2561.method_43471((String)"ftbquests.quest.misc.villager_uuid"), accepted -> {
                    if (accepted) {
                        UUID uuid;
                        block5: {
                            String villagerUuid = (String)c.getValue();
                            uuid = null;
                            try {
                                uuid = UUID.fromString(villagerUuid);
                                ((QuestAccessor)this.quest).setVillagerQuestUuid(uuid);
                                ((QuestAccessor)this.quest).setVillagerQuest(true);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                ((QuestAccessor)this.quest).setVillagerQuest(false);
                                ((QuestAccessor)this.quest).setVillagerQuestUuid(null);
                                if (oldVillagerUuid == null) break block5;
                                QuestClientPacket.writeC2SUpdateMerchantQuestMark(oldVillagerUuid);
                            }
                        }
                        new EditObjectMessage((QuestObjectBase)this.quest).sendToServer();
                        if (uuid != null) {
                            QuestClientPacket.writeC2SUpdateMerchantQuestMark(uuid);
                        }
                        if (oldVillagerUuid != null && oldVillagerUuid != uuid) {
                            QuestClientPacket.writeC2SUpdateMerchantQuestMark(oldVillagerUuid);
                        }
                    }
                    this.openGui();
                });
            } else if (this.villagerQuest) {
                this.playClickSound();
                class_310 client = class_310.method_1551();
                if (client.field_1724 != null && client.field_1724.method_37908() != null) {
                    List list = client.field_1724.method_37908().method_8390(class_3988.class, client.field_1724.method_5829().method_1014(16.0), class_1301.field_6155);
                    for (int i = 0; i < list.size(); ++i) {
                        if (!((class_3988)list.get(i)).method_5667().equals(((QuestAccessor)this.quest).getVillagerQuestUuid())) continue;
                        ((MerchantAccessor)list.get(i)).setOffererGlow();
                        break;
                    }
                }
            }
        }

        public boolean isEnabled() {
            return this.quest != null;
        }

        public void addMouseOverText(TooltipList list) {
            if (this.canEdit || this.villagerQuest) {
                super.addMouseOverText(list);
            }
        }

        public CursorType getCursor() {
            if (!this.canEdit && !this.villagerQuest) {
                return CursorType.ARROW;
            }
            return super.getCursor();
        }

        public void draw(class_332 context, Theme theme, int x, int y, int w, int h) {
            if (this.villagerQuest) {
                context.method_25290(RenderInit.VILLAGERQUEST_SCREEN_AND_ICONS, x, y, 504.0f, 0.0f, 8, 9, 512, 512);
            } else {
                context.method_25290(RenderInit.VILLAGERQUEST_SCREEN_AND_ICONS, x, y, 496.0f, 0.0f, 8, 9, 512, 512);
            }
        }
    }
}

