/*
 * Decompiled with CFR 0.152.
 */
package net.villagerquests.mixin.ftb;

import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3988;
import net.minecraft.server.MinecraftServer;
import net.villagerquests.access.QuestAccessor;
import net.villagerquests.access.TeamDataAccessor;
import net.villagerquests.data.VillagerQuestState;
import net.villagerquests.network.QuestServerPacket;
import net.villagerquests.util.QuestHelper;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={TeamData.class})
public class TeamDataMixin
implements TeamDataAccessor {
    private boolean acceptQuest = false;
    private HashMap<Long, Long> timer;
    @Shadow(remap=false)
    @Mutable
    @Final
    private BaseQuestFile file;
    @Shadow(remap=false)
    @Mutable
    @Final
    private Long2LongOpenHashMap started;
    @Shadow(remap=false)
    @Mutable
    @Final
    private Long2LongOpenHashMap completed;
    @Shadow(remap=false)
    @Mutable
    @Final
    private UUID teamId;

    @Inject(method={"Ldev/ftb/mods/ftbquests/quest/TeamData;<init>(Ljava/util/UUID;Ldev/ftb/mods/ftbquests/quest/BaseQuestFile;Ljava/lang/String;)V"}, at={@At(value="TAIL")}, remap=false)
    private void initMixin(UUID teamId, BaseQuestFile file, String name, CallbackInfo info) {
        this.acceptQuest = false;
        this.timer = new HashMap();
    }

    @Inject(method={"canStartTasks"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void canStartTasksMixin(Quest quest, CallbackInfoReturnable<Boolean> info) {
        if (((QuestAccessor)quest).isVillagerQuest() && !this.isStarted((QuestObject)quest)) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"Ldev/ftb/mods/ftbquests/quest/TeamData;claimReward(Lnet/minecraft/server/network/ServerPlayerEntity;Ldev/ftb/mods/ftbquests/quest/reward/Reward;Z)V"}, at={@At(value="INVOKE", target="Ldev/ftb/mods/ftbquests/quest/reward/Reward;claim(Lnet/minecraft/server/network/ServerPlayerEntity;Z)V")})
    private void claimRewardMixin(class_3222 serverPlayerEntity, Reward reward, boolean notify, CallbackInfo info) {
        QuestAccessor questAccessor;
        Quest quest = reward.getQuest();
        if (quest instanceof QuestAccessor && (questAccessor = (QuestAccessor)quest).isVillagerQuest()) {
            int questMarkType = QuestHelper.getVillagerQuestMarkType(serverPlayerEntity, questAccessor.getVillagerQuestUuid());
            VillagerQuestState.updatePlayerVillagerQuestMarkType(serverPlayerEntity.method_5682(), serverPlayerEntity.method_5667(), questAccessor.getVillagerQuestUuid(), questMarkType);
            class_1297 class_12972 = serverPlayerEntity.method_51469().method_14190(questAccessor.getVillagerQuestUuid());
            if (class_12972 instanceof class_3988) {
                class_3988 merchantEntity = (class_3988)class_12972;
                QuestServerPacket.writeS2CMerchantQuestMarkPacket(serverPlayerEntity, merchantEntity.method_5628(), questMarkType);
            }
        }
    }

    @Inject(method={"setStarted"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void setStartedMixin(long questId, @Nullable Date time, CallbackInfoReturnable<Boolean> info) {
        if (this.file.getQuest(questId) != null) {
            if (this.file.isServerSide() && !this.getOnlineMembers().isEmpty()) {
                if (time == null) {
                    this.timer.remove(questId);
                } else {
                    this.timer.put(questId, this.getOnlineMembers().stream().toList().get(0).method_5682().method_30002().method_8510());
                }
            }
            if (time != null && ((QuestAccessor)this.file.getQuest(questId)).isVillagerQuest()) {
                if (!this.acceptQuest) {
                    info.setReturnValue((Object)false);
                } else {
                    this.acceptQuest = false;
                }
            }
        }
    }

    @Inject(method={"setCompleted"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void setCompletedMixin(long id, @Nullable Date time, CallbackInfoReturnable<Boolean> info) {
        if (this.file.getQuest(id) != null) {
            this.timer.remove(id);
        }
    }

    @Inject(method={"mergeData"}, at={@At(value="TAIL")}, remap=false)
    private void mergeDataMixin(TeamData from, CallbackInfo info) {
        List<class_3222> onlinePlayers = this.getOnlineMembers().stream().toList();
        if (!onlinePlayers.isEmpty()) {
            MinecraftServer server = onlinePlayers.get(0).method_5682();
            this.started.forEach((questId, data) -> {
                QuestAccessor questAccessor;
                Quest patt5737$temp;
                if (!((TeamDataAccessor)from).getStarted().containsKey(questId.longValue()) && (patt5737$temp = this.file.getQuest(questId.longValue())) instanceof QuestAccessor && (questAccessor = (QuestAccessor)patt5737$temp).isVillagerQuest()) {
                    for (UUID playeUuid : ((Team)FTBTeamsAPI.api().getManager().getTeamByID(this.teamId).get()).getMembers()) {
                        int questMarkType = -1;
                        if (server.method_3760().method_14602(playeUuid) != null) {
                            questMarkType = QuestHelper.getVillagerQuestMarkType(server.method_3760().method_14602(playeUuid), questAccessor.getVillagerQuestUuid());
                            class_1297 patt6519$temp = server.method_3760().method_14602(playeUuid).method_51469().method_14190(questAccessor.getVillagerQuestUuid());
                            if (patt6519$temp instanceof class_3988) {
                                class_3988 merchantEntity = (class_3988)patt6519$temp;
                                QuestServerPacket.writeS2CMerchantQuestMarkPacket(server.method_3760().method_14602(playeUuid), merchantEntity.method_5628(), questMarkType);
                            }
                        }
                        VillagerQuestState.updatePlayerVillagerQuestMarkType(server, playeUuid, questAccessor.getVillagerQuestUuid(), questMarkType);
                    }
                }
            });
            this.completed.forEach((questId, data) -> {
                QuestAccessor questAccessor;
                Quest patt7181$temp;
                if (!((TeamDataAccessor)from).getCompleted().containsKey(questId.longValue()) && (patt7181$temp = this.file.getQuest(questId.longValue())) instanceof QuestAccessor && (questAccessor = (QuestAccessor)patt7181$temp).isVillagerQuest()) {
                    for (UUID playeUuid : ((Team)FTBTeamsAPI.api().getManager().getTeamByID(this.teamId).get()).getMembers()) {
                        int questMarkType = -1;
                        if (server.method_3760().method_14602(playeUuid) != null) {
                            questMarkType = QuestHelper.getVillagerQuestMarkType(server.method_3760().method_14602(playeUuid), questAccessor.getVillagerQuestUuid());
                            class_1297 patt7963$temp = server.method_3760().method_14602(playeUuid).method_51469().method_14190(questAccessor.getVillagerQuestUuid());
                            if (patt7963$temp instanceof class_3988) {
                                class_3988 merchantEntity = (class_3988)patt7963$temp;
                                QuestServerPacket.writeS2CMerchantQuestMarkPacket(server.method_3760().method_14602(playeUuid), merchantEntity.method_5628(), questMarkType);
                            }
                        }
                        VillagerQuestState.updatePlayerVillagerQuestMarkType(server, playeUuid, questAccessor.getVillagerQuestUuid(), questMarkType);
                    }
                }
            });
        }
    }

    @Inject(method={"serializeNBT"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILSOFT, remap=false)
    private void serializeNBTMixin(CallbackInfoReturnable<SNBTCompoundTag> info, SNBTCompoundTag snbtCompoundTag) {
        SNBTCompoundTag timerProgressNBT = new SNBTCompoundTag();
        Iterator<Map.Entry<Long, Long>> iterator = this.timer.entrySet().iterator();
        timerProgressNBT.method_10569("Size", this.timer.size());
        int count = 0;
        while (iterator.hasNext()) {
            Map.Entry<Long, Long> entry = iterator.next();
            timerProgressNBT.method_10544("QuestLong" + count, entry.getKey().longValue());
            timerProgressNBT.method_10544("QuestTime" + count, entry.getValue().longValue());
        }
        snbtCompoundTag.method_10566("Timer", (class_2520)timerProgressNBT);
    }

    @Inject(method={"deserializeNBT"}, at={@At(value="TAIL")}, remap=false)
    private void deserializeNBTMixin(SNBTCompoundTag nbt, CallbackInfo info) {
        this.timer.clear();
        SNBTCompoundTag timerProgressNBT = nbt.getCompound("Timer");
        for (int i = 0; i < timerProgressNBT.method_10550("Size"); ++i) {
            this.timer.put(timerProgressNBT.method_10537("QuestLong" + i), timerProgressNBT.method_10537("QuestTime" + i));
        }
    }

    @Inject(method={"write"}, at={@At(value="TAIL")}, remap=false)
    private void writeMixin(class_2540 buffer, boolean self, CallbackInfo info) {
        buffer.writeInt(this.timer.size());
        for (Map.Entry<Long, Long> entry : this.timer.entrySet()) {
            buffer.writeLong(entry.getKey().longValue());
            buffer.writeLong(entry.getValue().longValue());
        }
    }

    @Inject(method={"read"}, at={@At(value="TAIL")}, remap=false)
    private void readMixin(class_2540 buffer, boolean self, CallbackInfo info) {
        this.timer.clear();
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            this.timer.put(buffer.readLong(), buffer.readLong());
        }
    }

    @Override
    public void setQuestStarted(long questId, @Nullable Date time) {
        this.acceptQuest = true;
        this.setStarted(questId, time);
    }

    @Override
    public Long2LongOpenHashMap getStarted() {
        return this.started;
    }

    @Override
    public Long2LongOpenHashMap getCompleted() {
        return this.completed;
    }

    @Override
    public HashMap<Long, Long> getTimer() {
        return this.timer;
    }

    @Shadow(remap=false)
    public boolean setStarted(long questId, @Nullable Date time) {
        return false;
    }

    @Shadow(remap=false)
    public boolean isStarted(QuestObject object) {
        return false;
    }

    @Shadow(remap=false)
    public Collection<class_3222> getOnlineMembers() {
        return null;
    }
}

