/*
 * Decompiled with CFR 0.152.
 */
package net.villagerquests.mixin.ftb;

import dev.ftb.mods.ftbquests.events.QuestProgressEventData;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import java.util.Collections;
import java.util.Date;
import java.util.UUID;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.villagerquests.access.QuestAccessor;
import net.villagerquests.data.VillagerQuestState;
import net.villagerquests.network.QuestServerPacket;
import net.villagerquests.util.QuestHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ServerQuestFile.class})
public class ServerQuestFileMixin {
    @Shadow(remap=false)
    @Mutable
    @Final
    public MinecraftServer server;

    @Redirect(method={"lambda$playerLoggedIn$4"}, at=@At(value="INVOKE", target="Ldev/ftb/mods/ftbquests/quest/Quest;onCompleted(Ldev/ftb/mods/ftbquests/events/QuestProgressEventData;)V"), remap=false)
    private static void playerLoggedInMixin(Quest quest, QuestProgressEventData questProgressEventData, TeamData data, class_3222 player, Quest iteratingQuest) {
        if (!((QuestAccessor)iteratingQuest).isVillagerQuest()) {
            quest.onCompleted(new QuestProgressEventData(new Date(), data, (QuestObject)iteratingQuest, data.getOnlineMembers(), Collections.singletonList(player)));
        }
    }

    @Inject(method={"deleteObject"}, at={@At(value="INVOKE", target="Ldev/ftb/mods/ftbquests/quest/QuestObjectBase;deleteChildren()V")}, locals=LocalCapture.CAPTURE_FAILSOFT, remap=false)
    private void deleteObjectMixin(long id, CallbackInfo info, QuestObjectBase object) {
        Quest quest;
        if (object instanceof Quest && ((QuestAccessor)(quest = (Quest)object)).isVillagerQuest() && ((QuestAccessor)quest).getVillagerQuestUuid() != null) {
            UUID villagerUuid = ((QuestAccessor)quest).getVillagerQuestUuid();
            for (UUID playerUuid : VillagerQuestState.getPlayerVillagerQuestState(this.server, villagerUuid).getMerchantQuestMarkMap().keySet()) {
                int questMarkType = -1;
                if (this.server.method_3760().method_14602(playerUuid) != null) {
                    questMarkType = QuestHelper.getVillagerQuestMarkType(this.server.method_3760().method_14602(playerUuid), villagerUuid);
                    if (this.server.method_3760().method_14602(playerUuid).method_51469().method_14190(villagerUuid) != null) {
                        QuestServerPacket.writeS2CMerchantQuestMarkPacket(this.server.method_3760().method_14602(playerUuid), this.server.method_3760().method_14602(playerUuid).method_51469().method_14190(villagerUuid).method_5628(), questMarkType);
                    }
                }
                VillagerQuestState.updatePlayerVillagerQuestMarkType(this.server, playerUuid, villagerUuid, questMarkType);
            }
        }
    }
}

