/*
 * Decompiled with CFR 0.152.
 */
package net.villagerquests.mixin.ftb;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.villagerquests.access.QuestAccessor;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Quest.class})
public abstract class QuestMixin
extends QuestObject
implements QuestAccessor {
    private boolean villagerQuest;
    @Nullable
    private UUID villagerUuid;
    private int timer;
    @Shadow(remap=false)
    private boolean invisible;
    @Shadow(remap=false)
    private int invisibleUntilTasks;
    @Shadow(remap=false)
    @Mutable
    @Final
    private List<QuestObject> dependencies;
    @Shadow(remap=false)
    @Mutable
    @Final
    private List<Task> tasks;
    @Shadow(remap=false)
    private Tristate hideUntilDepsVisible;
    @Shadow(remap=false)
    private Chapter chapter;

    public QuestMixin(long id) {
        super(id);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=false)
    private void initMixin(long id, Chapter chapter, CallbackInfo info) {
        this.villagerQuest = false;
        this.villagerUuid = null;
        this.timer = 0;
    }

    @Inject(method={"writeData"}, at={@At(value="TAIL")})
    private void writeDataMixin(class_2487 nbt, CallbackInfo info) {
        nbt.method_10556("villagerquest", this.villagerQuest);
        if (this.villagerUuid != null) {
            nbt.method_25927("villageruuid", this.villagerUuid);
        }
        nbt.method_10569("Timer", this.timer);
    }

    @Inject(method={"readData"}, at={@At(value="TAIL")})
    private void readDataMixin(class_2487 nbt, CallbackInfo info) {
        this.villagerQuest = nbt.method_10577("villagerquest");
        if (nbt.method_10545("villageruuid")) {
            this.villagerUuid = nbt.method_25926("villageruuid");
        }
        this.timer = nbt.method_10550("Timer");
    }

    @Inject(method={"writeNetData"}, at={@At(value="TAIL")})
    private void writeNetDataMixin(class_2540 buffer, CallbackInfo info) {
        buffer.writeBoolean(this.villagerQuest);
        if (this.villagerQuest) {
            buffer.method_10797(this.villagerUuid);
        }
        buffer.writeInt(this.timer);
    }

    @Inject(method={"readNetData"}, at={@At(value="TAIL")})
    private void readNetDataMixin(class_2540 buffer, CallbackInfo info) {
        this.villagerQuest = buffer.readBoolean();
        if (this.villagerQuest) {
            this.villagerUuid = buffer.method_10790();
        }
        this.timer = buffer.readInt();
    }

    @Inject(method={"fillConfigGroup"}, at={@At(value="TAIL")}, remap=false)
    @Environment(value=EnvType.CLIENT)
    private void fillConfigGroupMixin(ConfigGroup config, CallbackInfo info) {
        ConfigGroup villagerQuest = config.getOrCreateSubgroup("villager_quest");
        villagerQuest.addBool("villager_quest", this.villagerQuest, v -> {
            this.villagerQuest = v;
        }, false).setNameKey("ftbquests.quest.misc.villager_quest");
        villagerQuest.addString("villager_uuid", this.villagerUuid != null ? this.villagerUuid.toString() : "", v -> {
            try {
                v = UUID.fromString(v).toString();
                this.villagerUuid = UUID.fromString(v);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                v = "";
                this.villagerUuid = null;
            }
        }, "").setNameKey("ftbquests.quest.misc.villager_uuid");
        villagerQuest.addInt("timer", this.timer, v -> {
            this.timer = v;
        }, 0, 0, Integer.MAX_VALUE).setNameKey("ftbquests.quest.misc.timer");
    }

    @Inject(method={"isVisible"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private void isVisibleMixin(TeamData data, CallbackInfoReturnable<Boolean> info) {
        if (((Boolean)info.getReturnValue()).booleanValue() && this.villagerQuest && !data.isStarted((QuestObject)this)) {
            info.setReturnValue((Object)false);
        }
    }

    @Override
    public boolean isVillagerQuest() {
        return this.villagerQuest;
    }

    @Override
    public void setVillagerQuest(boolean villagerQuest) {
        this.villagerQuest = villagerQuest;
    }

    @Override
    @Nullable
    public UUID getVillagerQuestUuid() {
        return this.villagerUuid;
    }

    @Override
    public void setVillagerQuestUuid(UUID uuid) {
        this.villagerUuid = uuid;
    }

    @Override
    public boolean isQuestVisible(TeamData data) {
        if (!data.isCompleted((QuestObject)this)) {
            if (this.invisible && this.invisibleUntilTasks == 0) {
                return false;
            }
            if (this.invisible) {
                int taskCount = 0;
                for (int i = 0; i < this.tasks.size(); ++i) {
                    if (data.isCompleted((QuestObject)this.tasks.get(i))) {
                        ++taskCount;
                    }
                    if (taskCount >= this.invisibleUntilTasks) continue;
                    return false;
                }
            }
            if (this.hideUntilDepsVisible.get(this.chapter.hideQuestUntilDepsVisible()) && !data.areDependenciesComplete((Quest)this)) {
                return false;
            }
            if (this.dependencies.size() > 0 && !this.dependencies.get(0).isVisible(data)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int getTimer() {
        return this.timer;
    }
}

