/*
 * Decompiled with CFR 0.152.
 */
package net.villagerquests.mixin;

import java.util.HashMap;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3988;
import net.villagerquests.access.MerchantAccessor;
import net.villagerquests.data.VillagerQuestState;
import net.villagerquests.init.ConfigInit;
import net.villagerquests.network.QuestServerPacket;
import net.villagerquests.util.QuestHelper;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3988.class})
public abstract class MerchantEntityMixin
extends class_1296
implements MerchantAccessor {
    private static final class_2940<Integer> TALK_TIME_LEFT = class_2945.method_12791(class_3988.class, (class_2941)class_2943.field_13327);
    private int offererGlowTime = 0;
    private int questMarkType = 0;
    private boolean changeableName = true;
    private boolean offersTrades = true;

    public MerchantEntityMixin(class_1299<? extends class_1296> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    protected void initDataTrackerMixin(CallbackInfo info) {
        this.field_6011.method_12784(TALK_TIME_LEFT, (Object)0);
    }

    @Inject(method={"setCustomer"}, at={@At(value="HEAD")})
    private void setCustomerMixin(@Nullable class_1657 customer, CallbackInfo info) {
        if (customer != null) {
            ((MerchantAccessor)customer).setCurrentOfferer((class_3988)this);
            if (!customer.method_37908().method_8608()) {
                QuestServerPacket.writeS2COffererPacket((class_3222)customer, this.method_5628());
            }
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    public void readCustomDataFromNbtMixin(class_2487 nbt, CallbackInfo info) {
        if (nbt.method_10545("ChangeableName")) {
            this.changeableName = nbt.method_10577("ChangeableName");
            this.offersTrades = nbt.method_10577("OffersTrades");
        }
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    public void writeCustomDataToNbtMixin(class_2487 nbt, CallbackInfo info) {
        nbt.method_10556("ChangeableName", this.changeableName);
        nbt.method_10556("OffersTrades", this.offersTrades);
    }

    @Inject(method={"onDeath"}, at={@At(value="TAIL")})
    private void onDeathMixin(class_1282 damageSource, CallbackInfo info) {
        if (!this.method_37908().method_8608()) {
            QuestHelper.removeVillagerQuestFromQuest(this.method_5667());
            VillagerQuestState.removeUuidFromServerVillagerQuestState(this.method_37908().method_8503(), this.method_5667());
        } else {
            this.setQuestMarkType(0);
        }
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        int questMarkType = 0;
        HashMap<UUID, Integer> merchantQuestMarkMap = VillagerQuestState.getPlayerVillagerQuestState(player.method_5682(), player.method_5667()).getMerchantQuestMarkMap();
        if (merchantQuestMarkMap.containsKey(this.method_5667())) {
            questMarkType = merchantQuestMarkMap.get(this.method_5667());
        } else {
            questMarkType = QuestHelper.getVillagerQuestMarkType(player, this.method_5667());
            merchantQuestMarkMap.put(this.method_5667(), questMarkType);
        }
        if (questMarkType != 0) {
            QuestServerPacket.writeS2CMerchantQuestMarkPacket(player, this.method_5628(), questMarkType);
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608() && this.offererGlowTime != 0 && (int)this.method_37908().method_8510() > this.offererGlowTime + ConfigInit.CONFIG.villagerQuestGlowTime) {
            this.offererGlowTime = 0;
            this.method_5729(6, false);
        }
        if (this.getTalkTime() > 0) {
            this.setTalkTime(this.getTalkTime() - 1);
        }
    }

    public void method_5665(class_2561 name) {
        if (this.changeableName) {
            super.method_5665(name);
        }
    }

    @Override
    public void setQuestMarkType(int questMarkType) {
        this.questMarkType = questMarkType;
    }

    @Override
    public int getQuestMarkType() {
        return this.questMarkType;
    }

    @Override
    public void setOffererGlow() {
        this.offererGlowTime = (int)this.method_37908().method_8510();
        this.method_5729(6, true);
    }

    @Override
    public void setChangeableName(boolean changeableName) {
        this.changeableName = changeableName;
    }

    @Override
    public boolean getChangeableName() {
        return this.changeableName;
    }

    @Override
    public void setOffersTrades(boolean offersTrades) {
        this.offersTrades = offersTrades;
    }

    @Override
    public boolean getOffersTrades() {
        return this.offersTrades;
    }

    @Override
    public void setTalkTime(int talkTime) {
        this.field_6011.method_12778(TALK_TIME_LEFT, (Object)talkTime);
    }

    @Override
    public int getTalkTime() {
        return (Integer)this.field_6011.method_12789(TALK_TIME_LEFT);
    }
}

