/*
 * Decompiled with CFR 0.152.
 */
package net.villagerquests.ftb;

import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ListConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbquests.client.gui.MultilineTextEditorScreen;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.util.NetUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.villagerquests.init.TaskInit;
import org.jetbrains.annotations.Nullable;

public class VillagerTalkTask
extends Task {
    private UUID villagerUuid = null;
    private String villagerName = "";
    private final List<String> villagerTalkText = new ArrayList<String>();

    public VillagerTalkTask(long id, Quest quest) {
        super(id, quest);
    }

    public TaskType getType() {
        return TaskInit.VILLAGER_TALK;
    }

    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        if (this.villagerUuid != null) {
            nbt.method_25927("villageruuid", this.villagerUuid);
            nbt.method_10582("villagername", this.villagerName);
            if (!this.villagerTalkText.isEmpty()) {
                class_2499 nbtList = new class_2499();
                for (String value : this.villagerTalkText) {
                    nbtList.add((Object)class_2519.method_23256((String)value));
                }
                nbt.method_10566("villagertalktext", (class_2520)nbtList);
            }
        }
    }

    public void readData(class_2487 nbt) {
        super.readData(nbt);
        if (nbt.method_10545("villageruuid")) {
            this.villagerUuid = nbt.method_25926("villageruuid");
            this.villagerName = nbt.method_10558("villagername");
            this.villagerTalkText.clear();
            class_2499 list = nbt.method_10554("villagertalktext", 8);
            for (int k = 0; k < list.size(); ++k) {
                this.villagerTalkText.add(list.method_10608(k));
            }
        }
    }

    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        buffer.writeBoolean(this.villagerUuid != null);
        if (this.villagerUuid != null) {
            buffer.method_10797(this.villagerUuid);
            buffer.method_10814(this.villagerName);
            buffer.writeBoolean(!this.villagerTalkText.isEmpty());
            if (!this.villagerTalkText.isEmpty()) {
                NetUtils.writeStrings((class_2540)buffer, this.villagerTalkText);
            }
        }
    }

    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        if (buffer.readBoolean()) {
            this.villagerUuid = buffer.method_10790();
            this.villagerName = buffer.method_19772();
            if (buffer.readBoolean()) {
                NetUtils.readStrings((class_2540)buffer, this.villagerTalkText);
            } else {
                this.villagerTalkText.clear();
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addString("villager_uuid", this.villagerUuid != null ? this.villagerUuid.toString() : "", v -> {
            block3: {
                try {
                    v = UUID.fromString(v).toString();
                    this.villagerUuid = UUID.fromString(v);
                    class_310 client = class_310.method_1551();
                    if (client.field_1687 == null || client.field_1724 == null) break block3;
                    List list = client.field_1687.method_8390(class_1646.class, client.field_1724.method_5829().method_1014(16.0), class_1301.field_6155);
                    for (int i = 0; i < list.size(); ++i) {
                        if (!((class_1646)list.get(i)).method_5667().equals(this.villagerUuid)) continue;
                        this.villagerName = ((class_1646)list.get(i)).method_5477().getString();
                        break;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    v = "";
                    this.villagerUuid = null;
                }
            }
        }, "").setNameKey("ftbquests.task.ftbquests.villager_talk.villager_uuid");
        StringConfig descType = new StringConfig();
        config.add("talk_text", (ConfigValue)new ListConfig<String, StringConfig>(descType){

            public void onClicked(MouseButton button, ConfigCallback callback) {
                new MultilineTextEditorScreen((class_2561)class_2561.method_43471((String)"ftbquests.task.ftbquests.villager_talk.talk_text"), (ListConfig)this, callback).openGui();
            }
        }, this.villagerTalkText, t -> {
            this.villagerTalkText.clear();
            this.villagerTalkText.addAll((Collection<String>)t);
        }, Collections.emptyList());
    }

    @Environment(value=EnvType.CLIENT)
    public class_5250 getAltTitle() {
        if (this.villagerUuid != null && !this.villagerName.equals("")) {
            return class_2561.method_43470((String)this.villagerName);
        }
        return class_2561.method_43471((String)"ftbquests.task.ftbquests.villager_talk.title");
    }

    @Environment(value=EnvType.CLIENT)
    public Icon getAltIcon() {
        return ItemIcon.getItemIcon((class_1792)class_1802.field_8285);
    }

    @Environment(value=EnvType.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
    }

    @Environment(value=EnvType.CLIENT)
    public List<String> getTalkTextList() {
        return this.villagerTalkText;
    }

    @Nullable
    public UUID getVillagerUuid() {
        return this.villagerUuid;
    }

    public void talk(TeamData teamData, class_1309 livingEntity) {
        if (!teamData.isCompleted((QuestObject)this) && this.villagerUuid != null && this.villagerUuid.equals(livingEntity.method_5667())) {
            teamData.addProgress((Task)this, 1L);
        }
    }
}

