/*
 * Decompiled with CFR 0.152.
 */
package net.villagerquests.data;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.server.MinecraftServer;
import net.villagerquests.data.VillagerQuestPlayerData;

public class VillagerQuestState
extends class_18 {
    private HashMap<UUID, VillagerQuestPlayerData> players = new HashMap();

    public class_2487 method_75(class_2487 nbt) {
        class_2487 playersNbt = new class_2487();
        this.players.forEach((uuid, villagerQuestPlayerData) -> {
            class_2487 merchantQuestMarkCompound = new class_2487();
            Iterator<Map.Entry<UUID, Integer>> iterator = villagerQuestPlayerData.getMerchantQuestMarkMap().entrySet().iterator();
            int count = 0;
            merchantQuestMarkCompound.method_10569("MerchantQuestMarkCount", villagerQuestPlayerData.getMerchantQuestMarkMap().size());
            while (iterator.hasNext()) {
                Map.Entry<UUID, Integer> entry = iterator.next();
                merchantQuestMarkCompound.method_25927("MerchantQuestMarkUuid" + count, entry.getKey());
                merchantQuestMarkCompound.method_10569("MerchantQuestMarkId" + count, entry.getValue().intValue());
                ++count;
            }
            nbt.method_10566("MerchantQuestMark", (class_2520)merchantQuestMarkCompound);
            playersNbt.method_10566(uuid.toString(), (class_2520)merchantQuestMarkCompound);
        });
        nbt.method_10566("players", (class_2520)playersNbt);
        return nbt;
    }

    public static VillagerQuestState createFromNbt(class_2487 nbt) {
        VillagerQuestState villagerQuestState = new VillagerQuestState();
        class_2487 playersNbt = nbt.method_10562("players");
        playersNbt.method_10541().forEach(key -> {
            VillagerQuestPlayerData playerData = new VillagerQuestPlayerData();
            class_2487 merchantQuestMarkCompound = playersNbt.method_10562(key).method_10562("MerchantQuestMark");
            int count = merchantQuestMarkCompound.method_10550("MerchantQuestMarkCount");
            for (int i = 0; i < count; ++i) {
                playerData.getMerchantQuestMarkMap().put(merchantQuestMarkCompound.method_25926("MerchantQuestMarkUuid" + i), merchantQuestMarkCompound.method_10550("MerchantQuestMarkId" + i));
            }
            UUID uuid = UUID.fromString(key);
            villagerQuestState.players.put(uuid, playerData);
        });
        return villagerQuestState;
    }

    public static VillagerQuestState getServerVillagerQuestState(MinecraftServer server) {
        class_26 persistentStateManager = server.method_3847(class_1937.field_25179).method_17983();
        VillagerQuestState state = (VillagerQuestState)persistentStateManager.method_17924(VillagerQuestState::createFromNbt, VillagerQuestState::new, "villagerquest");
        state.method_80();
        return state;
    }

    public static VillagerQuestPlayerData getPlayerVillagerQuestState(MinecraftServer server, UUID playerUuid) {
        VillagerQuestState serverState = VillagerQuestState.getServerVillagerQuestState(server);
        VillagerQuestPlayerData villagerQuestPlayerData = serverState.players.computeIfAbsent(playerUuid, uuid -> new VillagerQuestPlayerData());
        return villagerQuestPlayerData;
    }

    public static void updatePlayerVillagerQuestMarkType(MinecraftServer server, UUID playerUuid, UUID villagerUuid, int questMarkType) {
        VillagerQuestState.getPlayerVillagerQuestState(server, playerUuid).getMerchantQuestMarkMap().put(villagerUuid, questMarkType);
    }

    public static void updateUuidFromServerVillagerQuestState(MinecraftServer server, UUID villagerUuid, int questMarkType) {
        VillagerQuestState.getServerVillagerQuestState((MinecraftServer)server).players.forEach((playerUuid, villagerQuestPlayerData) -> villagerQuestPlayerData.getMerchantQuestMarkMap().put(villagerUuid, questMarkType));
    }

    public static void removeUuidFromServerVillagerQuestState(MinecraftServer server, UUID villagerUuid) {
        VillagerQuestState.getServerVillagerQuestState((MinecraftServer)server).players.forEach((playerUuid, villagerQuestPlayerData) -> villagerQuestPlayerData.getMerchantQuestMarkMap().remove(villagerUuid));
    }
}

