/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.client.screens.widgets.filter.IFilter;
import com.tiviacz.travelersbackpack.init.ModNetwork;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.network.IPacket;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class ServerboundFilterSettingsPacket
implements IPacket<ServerboundFilterSettingsPacket> {
    private final int slot;
    private final List<Integer> settings;

    public ServerboundFilterSettingsPacket(int slot, List<Integer> settings) {
        this.slot = slot;
        this.settings = settings;
    }

    public static ServerboundFilterSettingsPacket decode(class_2540 buffer) {
        int slot = buffer.readInt();
        List<Integer> settings = buffer.method_34059().intStream().boxed().collect(Collectors.toList());
        return new ServerboundFilterSettingsPacket(slot, settings);
    }

    @Override
    public void encode(ServerboundFilterSettingsPacket message, class_2540 buffer) {
        buffer.writeInt(message.slot);
        buffer.method_34060((IntList)new IntArrayList(message.settings.stream().mapToInt(Integer::intValue).toArray()));
    }

    @Override
    public class_2960 getPacketId() {
        return ModNetwork.FILTER_SETTINGS_ID;
    }

    public static void handle(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        ServerboundFilterSettingsPacket message = ServerboundFilterSettingsPacket.decode(buf);
        server.execute(() -> {
            BackpackBaseMenu menu;
            BackpackWrapper wrapper;
            class_1703 patt2178$temp = player.field_7512;
            if (patt2178$temp instanceof BackpackBaseMenu && !(wrapper = (menu = (BackpackBaseMenu)patt2178$temp).getWrapper()).getUpgrades().getStackInSlot(message.slot).method_7960()) {
                Object patt2842$temp;
                class_1799 upgradeStack = wrapper.getUpgrades().getStackInSlot(message.slot).method_7972();
                NbtHelper.set(upgradeStack, "FilterSettings", message.settings);
                wrapper.getUpgrades().setStackInSlot(message.slot, upgradeStack);
                if (((Optional)wrapper.getUpgradeManager().mappedUpgrades.get((Object)message.slot)).isPresent() && (patt2842$temp = ((Optional)wrapper.getUpgradeManager().mappedUpgrades.get((Object)message.slot)).get()) instanceof IFilter) {
                    IFilter filter = (IFilter)patt2842$temp;
                    filter.updateSettings();
                }
                menu.getWrapper().saveHandler.run();
            }
        });
    }
}

