/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.ITickableUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.items.upgrades.UpgradeItem;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public class UpgradeManager {
    public final BackpackWrapper wrapper;
    public final ItemStackHandler upgradesHandler;
    public BiMap<Integer, Optional<UpgradeBase<?>>> mappedUpgrades;
    public List<UpgradeBase<?>> upgrades = new ArrayList();

    public UpgradeManager(BackpackWrapper wrapper) {
        this.wrapper = wrapper;
        this.upgradesHandler = wrapper.getUpgrades();
        this.mappedUpgrades = HashBiMap.create();
        this.initializeUpgrades();
    }

    public BackpackWrapper getWrapper() {
        return this.wrapper;
    }

    public ItemStackHandler getUpgradesHandler() {
        return this.upgradesHandler;
    }

    public boolean hasUpgradeInSlot(int slot) {
        return this.mappedUpgrades.containsKey((Object)slot);
    }

    public <T extends UpgradeBase<T>> Optional<T> getUpgrade(Class<T> upgradeClass) {
        return this.upgrades.stream().filter(upgradeClass::isInstance).map(upgradeClass::cast).findFirst();
    }

    public boolean canAddUpgrade(UpgradeItem upgradeItem) {
        return this.upgrades.stream().noneMatch(u -> u.getClass().equals(upgradeItem.getUpgradeClass()));
    }

    public boolean invalidateUpgrade(int slot) {
        Optional upgrade = (Optional)this.mappedUpgrades.get((Object)slot);
        this.getWrapper().upgradesTracker.setStackInSlot(slot, class_1799.field_8037);
        if (upgrade == null) {
            return false;
        }
        upgrade.ifPresent(upg -> {
            this.mappedUpgrades.remove((Object)slot);
            upg.remove();
            this.upgrades.remove(upg);
        });
        return true;
    }

    public void initializeUpgrades() {
        for (int i = 0; i < this.getUpgradesHandler().getSlots(); ++i) {
            this.applyUpgrade(i);
        }
    }

    public void detectedChange(ItemStackHandler tracker, int slot) {
        boolean needsUpdate = this.applyUpgrade(slot);
        if (this.getTabStatus(tracker.getStackInSlot(slot)) != this.getTabStatus(this.getUpgradesHandler().getStackInSlot(slot))) {
            needsUpdate = true;
            class_1799 stackToSet = this.getUpgradesHandler().getStackInSlot(slot).method_7972();
            tracker.setStackInSlot(slot, stackToSet);
        }
        if (this.mappedUpgrades.containsKey((Object)slot) && !(this.getUpgradesHandler().getStackInSlot(slot).method_7909() instanceof UpgradeItem)) {
            needsUpdate = this.invalidateUpgrade(slot);
        }
        if (needsUpdate) {
            if (!this.getWrapper().getPlayersUsing().isEmpty()) {
                this.getWrapper().getPlayersUsing().stream().filter(player -> !player.method_37908().field_9236).forEach(player -> player.field_7512.method_7623());
            }
            this.getWrapper().requestMenuAndScreenUpdate();
        }
    }

    public boolean applyUpgrade(int slot) {
        UpgradeItem upgradeItem;
        AtomicBoolean atomic = new AtomicBoolean(false);
        class_1799 upgradeStack = this.getUpgradesHandler().getStackInSlot(slot);
        class_1792 class_17922 = upgradeStack.method_7909();
        if (class_17922 instanceof UpgradeItem && this.canAddUpgrade(upgradeItem = (UpgradeItem)class_17922)) {
            ((Optional)upgradeItem.getUpgrade().apply((Object)this, (Object)slot, (Object)upgradeStack)).ifPresent(upgrade -> {
                this.upgrades.add((UpgradeBase<?>)upgrade);
                this.mappedUpgrades.put((Object)slot, Optional.of(upgrade));
                atomic.set(true);
            });
        }
        return atomic.get();
    }

    public boolean getTabStatus(class_1799 stack) {
        return NbtHelper.getOrDefault(stack, "TabOpen", false);
    }

    public boolean hasTickingUpgrade() {
        return this.upgrades.stream().filter(upgradeBase -> upgradeBase instanceof ITickableUpgrade && upgradeBase instanceof IEnable).anyMatch(upgrade -> ((IEnable)((Object)upgrade)).isEnabled((UpgradeBase<?>)upgrade));
    }
}

