/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.components.Fluids;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackItemMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ToolSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.ITickableUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.items.upgrades.TanksUpgradeItem;
import com.tiviacz.travelersbackpack.items.upgrades.UpgradeItem;
import com.tiviacz.travelersbackpack.network.ClientboundSyncItemStackPacket;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import com.tiviacz.travelersbackpack.util.PacketDistributorHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class BackpackWrapper {
    public static final BackpackWrapper DUMMY = new BackpackWrapper(ModItems.STANDARD_TRAVELERS_BACKPACK.method_7854(), 3, null, null);
    protected class_1799 stack;
    public final ItemStackHandler inventory;
    public final ItemStackHandler upgrades;
    public final ItemStackHandler tools;
    public ItemStackHandler upgradesTracker;
    private final UpgradeManager upgradeManager;
    private class_1657 owner;
    public ArrayList<class_1657> playersUsing = new ArrayList();
    protected class_1937 level;
    private final int screenID;
    private long tanksCapacity = 0L;
    public int index = -1;
    public int[] dataLoad = new int[]{1, 1, 1};
    public Runnable saveHandler = () -> {};
    public Runnable abilityHandler = () -> {};
    public class_2338 backpackPos;
    public static final int STORAGE_ID = 0;
    public static final int UPGRADES_ID = 1;
    public static final int TOOLS_ID = 2;

    public BackpackWrapper(class_1799 stack, int screenID, @Nullable class_1657 player, @Nullable class_1937 level, int index) {
        this(stack, screenID, player, level);
        this.index = index;
    }

    public BackpackWrapper(class_1799 stack, int screenID, @Nullable class_1657 player, @Nullable class_1937 level) {
        this(stack, screenID, player, level, ComponentUtils.LOAD_ALL);
    }

    public BackpackWrapper(class_1799 stack, int screenID, @Nullable class_1657 player, @Nullable class_1937 level, int[] dataLoad) {
        if (player != null) {
            this.playersUsing.add(player);
        }
        if (screenID == 2) {
            this.setBackpackOwner(player);
        }
        this.stack = stack;
        if (!BackpackWrapper.isSizeInitialized(stack)) {
            BackpackWrapper.initializeSize(stack);
        }
        int storageSlots = (Integer)NbtHelper.get(stack, "StorageSlots");
        int upgradeSlots = (Integer)NbtHelper.get(stack, "UpgradeSlots");
        int toolSlots = (Integer)NbtHelper.get(stack, "ToolSlots");
        this.screenID = screenID;
        this.level = level;
        this.dataLoad = dataLoad;
        this.inventory = this.createHandler(storageSlots, 0);
        this.upgrades = this.createUpgradeHandler(upgradeSlots, 1);
        this.tools = this.createHandler(toolSlots, 2);
        this.upgradesTracker = new ItemStackHandler(this.upgrades.getSlots());
        this.loadHandlers();
        this.setBackpackTankCapacity();
        this.upgradeManager = new UpgradeManager(this);
        if (!NbtHelper.has(stack, "RenderInfo")) {
            this.setRenderInfo(RenderInfo.EMPTY.compoundTag());
        }
        if (NbtHelper.has(stack, "StarterUpgrades")) {
            List upgrades = (List)NbtHelper.get(stack, "StarterUpgrades");
            upgrades.forEach(this::setStarterUpgrade);
            NbtHelper.remove(stack, "StarterUpgrades");
        }
        this.converter(stack, storageSlots, toolSlots);
    }

    public void setBackpackStack(class_1799 backpack) {
        this.stack = backpack;
        this.getUpgradeManager().getUpgrade(TanksUpgrade.class).ifPresent(tanksUpgrade -> tanksUpgrade.syncClients(backpack));
    }

    public class_1799 getBackpackStack() {
        return this.stack;
    }

    public int getBackpackSlotIndex() {
        return this.index;
    }

    public void setBackpackOwner(class_1657 player) {
        this.owner = player;
    }

    @Nullable
    public class_1657 getBackpackOwner() {
        return this.owner;
    }

    public ArrayList<class_1657> getPlayersUsing() {
        return this.playersUsing;
    }

    public void addUser(class_1657 player) {
        if (!this.playersUsing.contains(player)) {
            this.playersUsing.add(player);
        }
    }

    public class_1937 getLevel() {
        return this.level;
    }

    public void loadHandler(String dataKey, int defaultSize, ItemStackHandler ... handlers) {
        if (NbtHelper.has(this.stack, dataKey)) {
            class_2487 contents = NbtHelper.getHandlerNbt(this.stack, dataKey);
            if (contents.method_10545("Size") && contents.method_10550("Size") < defaultSize) {
                contents = this.expandContents(contents, defaultSize, this.stack, dataKey);
            }
            for (ItemStackHandler handler : handlers) {
                handler.deserializeNBT(contents);
            }
        }
    }

    public void loadHandlers() {
        if (this.dataLoad[0] == 1) {
            this.loadStorage();
        }
        if (this.dataLoad[1] == 1) {
            this.loadUpgrades();
        }
        if (this.dataLoad[2] == 1) {
            this.loadTools();
        }
    }

    public void loadStorage() {
        this.loadHandler("Inventory", this.getStorageSize(), this.inventory);
    }

    public void loadUpgrades() {
        this.loadHandler("Upgrades", this.getUpgradesSize(), this.upgrades, this.upgradesTracker);
    }

    public void loadTools() {
        this.loadHandler("ToolsInventory", this.getToolSize(), this.tools);
    }

    public void loadAdditionally(int type) {
        if (this.dataLoad[type] == 0) {
            if (type == 0) {
                this.loadStorage();
            }
            if (type == 1) {
                this.loadUpgrades();
            }
            if (type == 2) {
                this.loadTools();
            }
            this.dataLoad[type] = 1;
        }
    }

    public class_2487 expandContents(class_2487 contents, int size, class_1799 backpack, String type) {
        if (contents.method_10550("Size") < size) {
            class_2371 stacks = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
            class_2499 tagList = contents.method_10554("Items", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                class_2487 itemTags = tagList.method_10602(i);
                int slot = itemTags.method_10550("Slot");
                if (slot < 0 || slot >= stacks.size()) continue;
                stacks.set(slot, (Object)class_1799.method_7915((class_2487)itemTags));
            }
            class_2487 expandedContents = NbtHelper.serializeHandler(new ItemStackHandler((class_2371<class_1799>)stacks));
            backpack.method_7948().method_10566(type, (class_2520)expandedContents);
            return expandedContents;
        }
        return contents;
    }

    public void setStarterUpgrade(class_1799 upgrade) {
        if (this.level == null) {
            return;
        }
        if (upgrade.method_7909().method_45382(this.level.method_45162())) {
            for (int i = 0; i < this.upgrades.getSlots(); ++i) {
                if (!this.upgrades.getStackInSlot(i).method_7960()) continue;
                this.upgrades.setStackInSlot(i, upgrade);
                this.upgradesTracker.setStackInSlot(i, upgrade);
                if (!(upgrade.method_7909() instanceof TanksUpgradeItem)) break;
                this.setRenderInfo(TanksUpgradeItem.writeToRenderData().compoundTag());
                break;
            }
        }
    }

    public int getStorageSize() {
        return NbtHelper.getOrDefault(this.stack, "StorageSlots", Tiers.LEATHER.getStorageSlots());
    }

    public int getUpgradesSize() {
        return NbtHelper.getOrDefault(this.stack, "UpgradeSlots", Tiers.LEATHER.getUpgradeSlots());
    }

    public int getToolSize() {
        return NbtHelper.getOrDefault(this.stack, "ToolSlots", Tiers.LEATHER.getToolSlots());
    }

    public ItemStackHandler getStorage() {
        return this.inventory;
    }

    public ItemStackHandler getUpgrades() {
        return this.upgrades;
    }

    public ItemStackHandler getTools() {
        return this.tools;
    }

    public UpgradeManager getUpgradeManager() {
        return this.upgradeManager;
    }

    public List<Integer> getUnsortableSlots() {
        return NbtHelper.getOrDefault(this.stack, "UnsortableSlots", List.of());
    }

    public List<Pair<Integer, Pair<class_1799, Boolean>>> getMemorySlots() {
        return NbtHelper.getOrDefault(this.stack, "MemorySlots", List.of());
    }

    public int getScreenID() {
        return this.screenID;
    }

    public class_2561 getBackpackScreenTitle() {
        return this.stack.method_7938() ? this.stack.method_7964() : class_2561.method_43471((String)"screen.travelersbackpack.title");
    }

    public void setUnsortableSlots(List<Integer> unsortables) {
        this.setData("UnsortableSlots", unsortables);
    }

    public void setMemorySlots(List<Pair<Integer, Pair<class_1799, Boolean>>> memory) {
        this.setData("MemorySlots", memory);
    }

    public <T> void setDataAndSync(String dataKey, T value) {
        this.setData(dataKey, value);
        this.sendDataToClients(dataKey);
    }

    public <T> void setData(String dataKey, T value) {
        NbtHelper.set(this.stack, dataKey, value);
        this.saveHandler.run();
        if (dataKey.equals("AbilityEnabled")) {
            this.abilityHandler.run();
        }
    }

    public boolean showToolSlots() {
        return NbtHelper.getOrDefault(this.stack, "ShowToolSlots", false);
    }

    public boolean showMoreButtons() {
        return NbtHelper.getOrDefault(this.stack, "ShowMoreButtons", false);
    }

    public boolean tanksVisible() {
        if (NbtHelper.has(this.stack, "RenderInfo")) {
            return ((RenderInfo)NbtHelper.get(this.stack, "RenderInfo")).hasTanks();
        }
        return this.getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent();
    }

    public long getBackpackTankCapacity() {
        return this.tanksCapacity;
    }

    public void setBackpackPos(class_2338 pos) {
        this.backpackPos = pos;
    }

    public class_2338 getBackpackPos() {
        return this.backpackPos;
    }

    public void setBackpackTankCapacity() {
        int rows = this.getRows() + (this.isExtended() ? 2 : 0);
        this.tanksCapacity = Tiers.of(NbtHelper.getOrDefault(this.stack, "Tier", 0)).getTankCapacityPerRow() * (long)rows;
    }

    public RenderInfo getRenderInfo() {
        return NbtHelper.getOrDefault(this.stack, "RenderInfo", RenderInfo.EMPTY);
    }

    public void setRenderInfo(class_2487 compound) {
        this.setDataAndSync("RenderInfo", new RenderInfo(compound));
    }

    public void removeRenderInfo() {
        this.setRenderInfo(new class_2487());
    }

    public boolean isAbilityEnabled() {
        return NbtHelper.getOrDefault(this.stack, "AbilityEnabled", TravelersBackpackConfig.getConfig().backpackAbilities.forceAbilityEnabled);
    }

    public boolean hasSleepingBag() {
        return NbtHelper.has(this.stack, "SleepingBagColor");
    }

    public int getSleepingBagColor() {
        return NbtHelper.getOrDefault(this.stack, "SleepingBagColor", class_1767.field_7964.method_7789());
    }

    public void setSleepingBagColor(int colorId) {
        this.setData("SleepingBagColor", colorId);
    }

    public boolean isOwner(class_1657 player) {
        if (this.getBackpackOwner() != null) {
            return this.getBackpackOwner().method_5628() == player.method_5628();
        }
        return true;
    }

    public boolean isDyed() {
        return NbtHelper.has(this.stack, "Color");
    }

    public int getDyeColor() {
        return NbtHelper.getOrDefault(this.stack, "Color", -1);
    }

    public int getCooldown() {
        return NbtHelper.getOrDefault(this.stack, "Cooldown", 0);
    }

    public void setCooldown(int cooldownInSeconds) {
        this.setDataAndSync("Cooldown", cooldownInSeconds);
    }

    public void decreaseCooldown() {
        if (this.getCooldown() > 0) {
            int currentCooldown = this.getCooldown();
            NbtHelper.set(this.stack, "Cooldown", currentCooldown - 1);
            this.saveHandler.run();
        }
    }

    public boolean canUpgradeTick() {
        return NbtHelper.has(this.stack, "UpgradeTickInterval");
    }

    public boolean hasTickingUpgrade() {
        return this.upgradeManager.hasTickingUpgrade();
    }

    public int getUpgradeTickInterval() {
        return NbtHelper.getOrDefault(this.stack, "UpgradeTickInterval", 100);
    }

    public void setUpgradeTickInterval(int ticks) {
        this.setDataAndSync("UpgradeTickInterval", ticks);
    }

    public void removeUpgradeTickInterval() {
        NbtHelper.remove(this.stack, "UpgradeTickInterval");
    }

    public boolean isExtended() {
        return this.getStorageSize() > 81;
    }

    public int getSlotsInRow() {
        if (this.isExtended()) {
            return 11;
        }
        return 9;
    }

    public int getRows() {
        return (int)Math.ceil((double)this.getStorageSize() / (double)this.getSlotsInRow());
    }

    public void sendDataToClients(String ... keys) {
        if (this.getScreenID() == 3) {
            return;
        }
        if (this.getScreenID() == 1 && !this.getPlayersUsing().stream().filter(p -> !p.method_37908().field_9236).toList().isEmpty()) {
            class_2487 builder = new class_2487();
            class_1799 serverDataHolder = this.getBackpackStack().method_7972();
            class_1799 serverDataHolderCopy = ItemStackUtils.reduceSize(serverDataHolder);
            for (String key : keys) {
                if (!serverDataHolderCopy.method_7969().method_10545(key)) continue;
                builder.method_10566(key, serverDataHolderCopy.method_7969().method_10580(key));
            }
            int slotIndex = this.index == -1 ? this.getPlayersUsing().get((int)0).method_31548().field_7545 : this.index;
            PacketDistributorHelper.sendToPlayer((class_3222)this.getPlayersUsing().get(0), new ClientboundSyncItemStackPacket(this.getPlayersUsing().get(0).method_5628(), slotIndex, this.getBackpackStack(), builder));
            return;
        }
        if (TravelersBackpack.enableIntegration()) {
            if (this.getScreenID() == 2 && !this.getPlayersUsing().stream().filter(p -> !p.method_37908().field_9236).toList().isEmpty()) {
                for (class_1657 player : this.getPlayersUsing()) {
                    class_2487 builder = new class_2487();
                    class_1799 serverDataHolder = this.getBackpackStack().method_7972();
                    class_1799 serverDataHolderCopy = ItemStackUtils.reduceSize(serverDataHolder);
                    for (String key : keys) {
                        if (!serverDataHolderCopy.method_7969().method_10545(key)) continue;
                        builder.method_10566(key, serverDataHolderCopy.method_7969().method_10580(key));
                    }
                    PacketDistributorHelper.sendToPlayer((class_3222)player, new ClientboundSyncItemStackPacket(player.method_5628(), -1, this.getBackpackStack(), builder));
                }
            }
            return;
        }
        if (this.getBackpackOwner() != null) {
            class_2487 builder = new class_2487();
            class_1799 serverDataHolder = ComponentUtils.getWearingBackpack(this.getBackpackOwner()).method_7972();
            class_1799 serverDataHolderCopy = ItemStackUtils.reduceSize(serverDataHolder);
            for (String key : keys) {
                if (!serverDataHolderCopy.method_7969().method_10545(key)) continue;
                builder.method_10566(key, serverDataHolderCopy.method_7969().method_10580(key));
            }
            ComponentUtils.getComponentOptional(this.getBackpackOwner()).ifPresent(data -> data.synchronise(builder));
        }
    }

    public Optional<Pair<Integer, Pair<class_1799, Boolean>>> getMemorizedSlot(int slot) {
        return this.getMemorySlots().stream().filter(pair -> (Integer)pair.getFirst() == slot).findFirst();
    }

    private ItemStackHandler createHandler(int size, final int dataId) {
        return new ItemStackHandler(size){

            @Override
            protected void onContentsChanged(int slot) {
                BackpackWrapper.this.setSlotChanged(slot, this.getStackInSlot(slot), dataId);
                if (dataId == 2) {
                    BackpackWrapper.this.sendDataToClients("ToolsInventory");
                }
                BackpackWrapper.this.saveHandler.run();
            }

            @Override
            public boolean isItemValid(int slot, class_1799 stack) {
                if (dataId == 2) {
                    return ToolSlotItemHandler.isValid(stack);
                }
                return BackpackSlotItemHandler.isItemValid(stack);
            }
        };
    }

    public void setSlotChanged(int index, class_1799 stack, int dataId) {
        switch (dataId) {
            case 0: {
                NbtHelper.update(this.stack, "Inventory", this.getStorage().getSlots(), index, stack);
                break;
            }
            case 1: {
                NbtHelper.update(this.stack, "Upgrades", this.getUpgrades().getSlots(), index, stack);
                break;
            }
            case 2: {
                NbtHelper.update(this.stack, "ToolsInventory", this.getTools().getSlots(), index, stack);
            }
        }
    }

    public void applyLowestTickInterval() {
        int minimalTickInterval = 100;
        for (int i = 0; i < this.upgrades.getSlots(); ++i) {
            class_1799 upgrade = this.upgrades.getStackInSlot(i);
            if (upgrade.method_7960() || !NbtHelper.getOrDefault(upgrade, "UpgradeEnabled", true).booleanValue() || !NbtHelper.has(upgrade, "Cooldown")) continue;
            minimalTickInterval = Math.min(minimalTickInterval, (Integer)NbtHelper.get(upgrade, "Cooldown"));
        }
        if (!this.canUpgradeTick() || minimalTickInterval != this.getUpgradeTickInterval()) {
            this.setUpgradeTickInterval(minimalTickInterval);
        }
    }

    public void updateMinimalTickInterval(class_1799 newStack) {
        if (this.level != null && this.level.field_9236) {
            return;
        }
        boolean applyLowestTickInterval = false;
        class_1792 class_17922 = newStack.method_7909();
        if (class_17922 instanceof UpgradeItem) {
            UpgradeItem upgradeItem = (UpgradeItem)class_17922;
            if (upgradeItem.isTickingUpgrade()) {
                if (NbtHelper.getOrDefault(newStack, "UpgradeEnabled", true).booleanValue()) {
                    int tickInterval = this.getUpgradeTickInterval();
                    if (NbtHelper.has(newStack, "Cooldown")) {
                        tickInterval = (Integer)NbtHelper.get(newStack, "Cooldown");
                    }
                    if (!this.canUpgradeTick() || tickInterval < this.getUpgradeTickInterval()) {
                        this.setUpgradeTickInterval(tickInterval);
                    } else if (tickInterval > this.getUpgradeTickInterval()) {
                        applyLowestTickInterval = true;
                    }
                } else {
                    applyLowestTickInterval = true;
                }
            }
        } else {
            applyLowestTickInterval = true;
        }
        if (this.canUpgradeTick()) {
            if (!this.hasTickingUpgrade()) {
                this.removeUpgradeTickInterval();
            } else if (applyLowestTickInterval) {
                this.applyLowestTickInterval();
            }
        }
    }

    private ItemStackHandler createUpgradeHandler(int size, final int dataId) {
        return new ItemStackHandler(size){

            @Override
            protected void onContentsChanged(int slot) {
                BackpackWrapper.this.setSlotChanged(slot, this.getStackInSlot(slot), dataId);
                if (!BackpackWrapper.this.getPlayersUsing().isEmpty()) {
                    BackpackWrapper.this.getUpgradeManager().detectedChange(BackpackWrapper.this.upgradesTracker, slot);
                }
                BackpackWrapper.this.updateMinimalTickInterval(this.getStackInSlot(slot));
                BackpackWrapper.this.saveHandler.run();
            }

            @Override
            public int getSlotLimit(int slot) {
                return 1;
            }

            @Override
            public boolean isItemValid(int slot, class_1799 stack) {
                boolean isValid = true;
                for (int i = 0; i < this.getSlots(); ++i) {
                    if (this.getStackInSlot(i).method_7909() != stack.method_7909()) continue;
                    isValid = false;
                    break;
                }
                if (!isValid) {
                    return false;
                }
                if (stack.method_7909() instanceof TanksUpgradeItem) {
                    isValid = TanksUpgradeItem.canBePutInBackpack(BackpackWrapper.this.getBackpackTankCapacity(), stack);
                }
                if (!this.checkIfUpgradeValid(stack)) {
                    isValid = false;
                }
                return isValid;
            }

            public boolean checkIfUpgradeValid(class_1799 upgradeStack) {
                class_1792 class_17922 = upgradeStack.method_7909();
                if (class_17922 instanceof UpgradeItem) {
                    class_1657 player;
                    UpgradeItem upgradeItem = (UpgradeItem)class_17922;
                    class_1657 class_16572 = player = BackpackWrapper.this.getPlayersUsing().isEmpty() ? null : BackpackWrapper.this.getPlayersUsing().get(0);
                    if (player == null) {
                        return false;
                    }
                    return upgradeItem.method_45382(player.method_37908().method_45162());
                }
                return false;
            }
        };
    }

    public static boolean isSizeInitialized(class_1799 stack) {
        return NbtHelper.has(stack, "StorageSlots") && NbtHelper.has(stack, "UpgradeSlots") && NbtHelper.has(stack, "ToolSlots");
    }

    public static void initializeSize(class_1799 stack) {
        Tiers.Tier tier = Tiers.LEATHER;
        if (NbtHelper.has(stack, "Tier")) {
            tier = Tiers.of((Integer)NbtHelper.get(stack, "Tier"));
        } else {
            NbtHelper.set(stack, "Tier", Tiers.LEATHER.getOrdinal());
        }
        if (!NbtHelper.has(stack, "StorageSlots")) {
            NbtHelper.set(stack, "StorageSlots", tier.getStorageSlots());
        }
        if (!NbtHelper.has(stack, "UpgradeSlots")) {
            NbtHelper.set(stack, "UpgradeSlots", tier.getUpgradeSlots());
        }
        if (!NbtHelper.has(stack, "ToolSlots")) {
            NbtHelper.set(stack, "ToolSlots", tier.getToolSlots());
        }
    }

    public void requestMenuAndScreenUpdate() {
        this.requestMenuUpdate();
        this.requestScreenUpdate();
    }

    public void requestMenuUpdate() {
        if (!this.getPlayersUsing().isEmpty()) {
            this.getPlayersUsing().stream().filter(player -> player.field_7512 instanceof BackpackBaseMenu).forEach(player -> ((BackpackBaseMenu)player.field_7512).updateModifiableSlots());
        }
    }

    public void requestScreenUpdate() {
        class_437 class_4372;
        if (!this.getPlayersUsing().isEmpty() && !this.getPlayersUsing().stream().filter(player -> player.method_37908().field_9236).toList().isEmpty() && (class_4372 = class_310.method_1551().field_1755) instanceof BackpackScreen) {
            BackpackScreen screen = (BackpackScreen)class_4372;
            screen.updateScreen(false);
        }
    }

    public static void tickForBlockEntity(BackpackBlockEntity backpackBlockEntity) {
        BackpackWrapper wrapper = backpackBlockEntity.getWrapper();
        if (wrapper != DUMMY && wrapper.isAbilityEnabled() && BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, wrapper.getBackpackStack())) {
            boolean decreaseCooldown = BackpackAbilities.ABILITIES.abilityTickBlock(backpackBlockEntity);
            if (wrapper.getCooldown() > 0 && decreaseCooldown) {
                wrapper.decreaseCooldown();
            }
        }
    }

    @Nullable
    public static BackpackWrapper getBackpackWrapper(class_1657 player, class_1799 backpack, int[] dataLoad) {
        if (ComponentUtils.isWearingBackpack(player)) {
            BackpackItemMenu menu;
            class_1703 class_17032 = player.field_7512;
            if (class_17032 instanceof BackpackItemMenu && (menu = (BackpackItemMenu)class_17032).getWrapper().getScreenID() == 2) {
                return menu.getWrapper();
            }
            for (class_1657 otherPlayer : player.method_37908().method_18456()) {
                BackpackItemMenu menu2;
                class_1703 class_17033 = otherPlayer.field_7512;
                if (!(class_17033 instanceof BackpackItemMenu) || !(menu2 = (BackpackItemMenu)class_17033).getWrapper().isOwner(player) || menu2.getWrapper().getScreenID() != 2) continue;
                return menu2.getWrapper();
            }
            return new BackpackWrapper(backpack, 2, player, player.method_37908(), dataLoad);
        }
        return null;
    }

    public static void tick(class_1799 stack, class_1657 player, boolean integration) {
        if (!integration && TravelersBackpack.enableIntegration()) {
            return;
        }
        if (player.method_5805() && ComponentUtils.isWearingBackpack(player)) {
            BackpackWrapper wrapper;
            int ticks = (int)player.method_37908().method_8510();
            if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, ComponentUtils.getWearingBackpack(player))) {
                if (BackpackAbilities.isAbilityEnabledInConfig(stack)) {
                    if (NbtHelper.getOrDefault(stack, "AbilityEnabled", TravelersBackpackConfig.getConfig().backpackAbilities.forceAbilityEnabled).booleanValue()) {
                        boolean decreaseCooldown = BackpackAbilities.ABILITIES.abilityTickEquipped(stack, player);
                        if (NbtHelper.getOrDefault(stack, "Cooldown", 0) > 0 && ticks % 100 == 0 && decreaseCooldown) {
                            wrapper = ComponentUtils.getBackpackWrapper(player, stack, ComponentUtils.NO_ITEMS);
                            int cooldown = wrapper.getCooldown();
                            if (player.method_37908().field_9236) {
                                return;
                            }
                            if (cooldown - 100 < 0) {
                                wrapper.setCooldown(0);
                            } else {
                                wrapper.setCooldown(cooldown - 100);
                            }
                        }
                    } else if (NbtHelper.getOrDefault(stack, "Cooldown", 0) > 0 && ticks % 100 == 0) {
                        BackpackWrapper wrapper2 = ComponentUtils.getBackpackWrapper(player, stack, ComponentUtils.NO_ITEMS);
                        int cooldown = wrapper2.getCooldown();
                        if (player.method_37908().field_9236) {
                            return;
                        }
                        if (cooldown - 100 < 0) {
                            wrapper2.setCooldown(0);
                        } else {
                            wrapper2.setCooldown(cooldown - 100);
                        }
                    }
                }
            } else if (NbtHelper.getOrDefault(stack, "AbilityEnabled", false).booleanValue()) {
                NbtHelper.set(stack, "AbilityEnabled", false);
            }
            if (NbtHelper.has(stack, "UpgradeTickInterval")) {
                int upgradeTicks = (Integer)NbtHelper.get(stack, "UpgradeTickInterval");
                if (upgradeTicks == 0) {
                    return;
                }
                if (ticks % upgradeTicks == 0) {
                    wrapper = ComponentUtils.getBackpackWrapper(player, stack, ComponentUtils.UPGRADES_ONLY);
                    wrapper.getUpgradeManager().upgrades.forEach(upgradeBase -> {
                        if (upgradeBase instanceof ITickableUpgrade) {
                            ITickableUpgrade tickable = (ITickableUpgrade)((Object)upgradeBase);
                            boolean tick = true;
                            if (upgradeBase instanceof IEnable) {
                                IEnable enable = (IEnable)((Object)upgradeBase);
                                tick = enable.isEnabled((UpgradeBase<?>)upgradeBase);
                            }
                            if (tick) {
                                tickable.tick(player, player.method_37908(), player.method_24515(), ticks);
                            }
                        }
                    });
                }
            }
        }
    }

    public void converter(class_1799 stack, int storageSlots, int toolSlots) {
        if (NbtHelper.has(stack, "Inventory") && storageSlots != ((class_2371)NbtHelper.get(stack, "Inventory")).size()) {
            stack.method_7969().method_10566("Inventory", (class_2520)NbtHelper.expandTag(stack, "Inventory", storageSlots));
        }
        if (NbtHelper.has(stack, "ToolsInventory") && toolSlots != ((class_2371)NbtHelper.get(stack, "ToolsInventory")).size()) {
            stack.method_7969().method_10566("ToolsInventory", (class_2520)NbtHelper.expandTag(stack, "ToolsInventory", toolSlots));
        }
        if (NbtHelper.has(stack, "LeftTank") || NbtHelper.has(stack, "RightTank")) {
            long amount;
            FluidVariant variant;
            FluidVariantWrapper fluidStack;
            class_2487 oldTank = NbtHelper.has(stack, "LeftTank") ? stack.method_7969().method_10562("LeftTank") : new class_2487();
            class_2487 oldTank2 = NbtHelper.has(stack, "RightTank") ? stack.method_7969().method_10562("RightTank") : new class_2487();
            FluidVariantWrapper leftFluidStack = FluidVariantWrapper.blank();
            FluidVariantWrapper rightFluidStack = FluidVariantWrapper.blank();
            if (!oldTank.method_33133() && !(fluidStack = new FluidVariantWrapper(variant = FluidVariant.fromNbt((class_2487)oldTank.method_10562("variant")), amount = oldTank.method_10537("amount"))).isEmpty()) {
                leftFluidStack = fluidStack;
            }
            if (!oldTank2.method_33133() && !(fluidStack = new FluidVariantWrapper(variant = FluidVariant.fromNbt((class_2487)oldTank2.method_10562("variant")), amount = oldTank2.method_10537("amount"))).isEmpty()) {
                rightFluidStack = fluidStack;
            }
            class_1799 oldTanks = ModItems.TANKS_UPGRADE.method_7854();
            NbtHelper.set(oldTanks, "Fluids", new Fluids(leftFluidStack, rightFluidStack));
            this.setStarterUpgrade(oldTanks);
            stack.method_7969().method_10551("LeftTank");
            stack.method_7969().method_10551("RightTank");
            if (stack.method_7985() && stack.method_7969().method_10545("CraftingInventory")) {
                class_1799 craftingUpgrade = ModItems.CRAFTING_UPGRADE.method_7854();
                ItemStackHandler craftingInventory = new ItemStackHandler(9);
                craftingInventory.deserializeNBT(stack.method_7969().method_10562("CraftingInventory"));
                NbtHelper.set(craftingUpgrade, "Inventory", craftingInventory);
                this.setStarterUpgrade(craftingUpgrade);
                stack.method_7969().method_10551("CraftingInventory");
            }
        }
    }
}

