/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealth.bars;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.torocraft.torohealth.bars.BarParticle;
import net.torocraft.torohealth.bars.BarState;

public class BarStates {
    private static final Map<Integer, BarState> STATES = new HashMap<Integer, BarState>();
    public static List<BarParticle> PARTICLES = new ArrayList<BarParticle>();
    private static int tickCount = 0;

    public static BarState getState(class_1309 entity) {
        int id = entity.method_5628();
        BarState state = STATES.get(id);
        if (state == null) {
            state = new BarState(entity);
            STATES.put(id, state);
        }
        return state;
    }

    public static void tick() {
        for (BarState state : STATES.values()) {
            state.tick();
        }
        if (tickCount % 200 == 0) {
            BarStates.cleanCache();
        }
        PARTICLES.forEach(p -> p.tick());
        PARTICLES.removeIf(p -> p.age > 50);
        ++tickCount;
    }

    private static void cleanCache() {
        STATES.entrySet().removeIf(BarStates::stateExpired);
    }

    private static boolean stateExpired(Map.Entry<Integer, BarState> entry) {
        if (entry.getValue() == null) {
            return true;
        }
        class_310 minecraft = class_310.method_1551();
        class_1297 entity = minecraft.field_1687.method_8469(entry.getKey().intValue());
        if (!(entity instanceof class_1309)) {
            return true;
        }
        if (!minecraft.field_1687.method_22340(entity.method_24515())) {
            return true;
        }
        return !entity.method_5805();
    }
}

