/*
 * Decompiled with CFR 0.152.
 */
package draylar.tiered.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import draylar.tiered.Tiered;
import draylar.tiered.api.AttributeTemplate;
import draylar.tiered.api.ModifierUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class CommandInit {
    private static final List<String> TIER_LIST = List.of("common", "uncommon", "rare", "epic", "legendary", "unique");

    public static void init() {
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tiered").requires(serverCommandSource -> serverCommandSource.method_9259(3))).then(class_2170.method_9247((String)"tier").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"common").executes(commandContext -> CommandInit.executeCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), 0)))).then(class_2170.method_9247((String)"uncommon").executes(commandContext -> CommandInit.executeCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), 1)))).then(class_2170.method_9247((String)"rare").executes(commandContext -> CommandInit.executeCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), 2)))).then(class_2170.method_9247((String)"epic").executes(commandContext -> CommandInit.executeCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), 3)))).then(class_2170.method_9247((String)"legendary").executes(commandContext -> CommandInit.executeCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), 4)))).then(class_2170.method_9247((String)"unique").executes(commandContext -> CommandInit.executeCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), 5)))))).then(class_2170.method_9247((String)"untier").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(commandContext -> CommandInit.executeCommand((class_2168)commandContext.getSource(), class_2186.method_9312((CommandContext)commandContext, (String)"targets"), -1))))));
    }

    private static int executeCommand(class_2168 source, Collection<class_3222> targets, int tier) {
        for (class_3222 serverPlayerEntity : targets) {
            class_1799 itemStack = serverPlayerEntity.method_6047();
            if (itemStack.method_7960()) {
                source.method_9226(() -> class_2561.method_43469((String)"commands.tiered.failed", (Object[])new Object[]{serverPlayerEntity.method_5476()}), true);
                continue;
            }
            if (tier == -1) {
                if (itemStack.method_7941("Tiered") != null) {
                    ModifierUtils.removeItemStackAttribute(itemStack);
                    source.method_9226(() -> class_2561.method_43469((String)"commands.tiered.untier", (Object[])new Object[]{itemStack.method_7909().method_7864(itemStack).getString(), serverPlayerEntity.method_5476()}), true);
                    continue;
                }
                source.method_9226(() -> class_2561.method_43469((String)"commands.tiered.untier_failed", (Object[])new Object[]{itemStack.method_7909().method_7864(itemStack).getString(), serverPlayerEntity.method_5476()}), true);
                continue;
            }
            ArrayList potentialAttributes = new ArrayList();
            Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes().forEach((id, attribute) -> {
                if (attribute.isValid(class_7923.field_41178.method_10221((Object)itemStack.method_7909()))) {
                    potentialAttributes.add(new class_2960(attribute.getID()));
                }
            });
            if (potentialAttributes.size() <= 0) {
                source.method_9226(() -> class_2561.method_43469((String)"commands.tiered.tiering_failed", (Object[])new Object[]{itemStack.method_7909().method_7864(itemStack).getString(), serverPlayerEntity.method_5476()}), true);
                continue;
            }
            ArrayList<class_2960> potentialTier = new ArrayList<class_2960>();
            for (int i = 0; i < potentialAttributes.size(); ++i) {
                if (!((class_2960)potentialAttributes.get(i)).method_12832().contains(TIER_LIST.get(tier)) || TIER_LIST.get(tier).equals("common") && ((class_2960)potentialAttributes.get(i)).method_12832().contains("uncommon")) continue;
                potentialTier.add((class_2960)potentialAttributes.get(i));
            }
            if (potentialTier.size() <= 0) {
                source.method_9226(() -> class_2561.method_43469((String)"commands.tiered.tiering_failed", (Object[])new Object[]{itemStack.method_7909().method_7864(itemStack).getString(), serverPlayerEntity.method_5476()}), true);
                continue;
            }
            ModifierUtils.removeItemStackAttribute(itemStack);
            class_2960 attribute2 = (class_2960)potentialTier.get(serverPlayerEntity.method_37908().method_8409().method_43048(potentialTier.size()));
            if (attribute2 == null) continue;
            itemStack.method_7911("Tiered").method_10582("Tier", attribute2.toString());
            HashMap<String, Object> nbtMap = Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes().get(new class_2960(attribute2.toString())).getNbtValues();
            List<AttributeTemplate> attributeList = Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes().get(new class_2960(attribute2.toString())).getAttributes();
            for (int i = 0; i < attributeList.size(); ++i) {
                if (!attributeList.get(i).getAttributeTypeID().equals("tiered:generic.durable")) continue;
                if (nbtMap == null) {
                    nbtMap = new HashMap();
                }
                nbtMap.put("durable", (double)Math.round(attributeList.get(i).getEntityAttributeModifier().method_6186() * 100.0) / 100.0);
                break;
            }
            if (nbtMap != null) {
                class_2487 nbtCompound = itemStack.method_7969();
                for (Map.Entry<String, Object> entry : nbtMap.entrySet()) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    if (value instanceof String) {
                        nbtCompound.method_10582(key, (String)value);
                        continue;
                    }
                    if (value instanceof Boolean) {
                        nbtCompound.method_10556(key, ((Boolean)value).booleanValue());
                        continue;
                    }
                    if (!(value instanceof Double)) continue;
                    if ((Double)value % 1.0 < 1.0E-4) {
                        nbtCompound.method_10569(key, (int)Math.round((Double)value));
                        continue;
                    }
                    nbtCompound.method_10549(key, (double)Math.round((Double)value * 100.0) / 100.0);
                }
                itemStack.method_7980(nbtCompound);
            }
            source.method_9226(() -> class_2561.method_43469((String)"commands.tiered.tier", (Object[])new Object[]{itemStack.method_7909().method_7864(itemStack).getString(), serverPlayerEntity.method_5476()}), true);
        }
        return 1;
    }
}

