/*
 * Decompiled with CFR 0.152.
 */
package draylar.tiered;

import draylar.tiered.Tiered;
import draylar.tiered.api.BorderTemplate;
import draylar.tiered.api.PotentialAttribute;
import draylar.tiered.data.AttributeDataLoader;
import draylar.tiered.data.TooltipBorderLoader;
import draylar.tiered.network.TieredClientPacket;
import draylar.tiered.reforge.ReforgeScreen;
import draylar.tiered.reforge.widget.AnvilTab;
import draylar.tiered.reforge.widget.ReforgeTab;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.libz.api.InventoryTab;
import net.libz.registry.TabRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3929;
import net.minecraft.class_471;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class TieredClient
implements ClientModInitializer {
    public static final Map<class_2960, PotentialAttribute> CACHED_ATTRIBUTES = new HashMap<class_2960, PotentialAttribute>();
    public static final List<BorderTemplate> BORDER_TEMPLATES = new ArrayList<BorderTemplate>();
    private static final class_2960 ANVIL_TAB_ICON = new class_2960("tiered:textures/gui/anvil_tab_icon.png");
    private static final class_2960 REFORGE_TAB_ICON = new class_2960("tiered:textures/gui/reforge_tab_icon.png");

    public void onInitializeClient() {
        TieredClient.registerAttributeSyncHandler();
        TieredClient.registerReforgeItemSyncHandler();
        class_3929.method_17542(Tiered.REFORGE_SCREEN_HANDLER_TYPE, ReforgeScreen::new);
        TieredClientPacket.init();
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new TooltipBorderLoader());
        TabRegistry.registerOtherTab((InventoryTab)new AnvilTab((class_2561)class_2561.method_43471((String)"container.repair"), ANVIL_TAB_ICON, 0, class_471.class), class_471.class);
        TabRegistry.registerOtherTab((InventoryTab)new ReforgeTab((class_2561)class_2561.method_43471((String)"screen.tiered.reforging_screen"), REFORGE_TAB_ICON, 1, ReforgeScreen.class), class_471.class);
    }

    public static void registerAttributeSyncHandler() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Tiered.ATTRIBUTE_SYNC_PACKET, (client, play, packet, packetSender) -> {
            CACHED_ATTRIBUTES.putAll(Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes());
            Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes().clear();
            int size = packet.readInt();
            for (int i = 0; i < size; ++i) {
                class_2960 id = new class_2960(packet.method_19772());
                PotentialAttribute pa = (PotentialAttribute)AttributeDataLoader.GSON.fromJson(packet.method_19772(), PotentialAttribute.class);
                Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes().put(id, pa);
            }
        });
    }

    public static void registerReforgeItemSyncHandler() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Tiered.REFORGE_ITEM_SYNC_PACKET, (client, play, packet, packetSender) -> {
            ArrayList<class_2960> identifiers = new ArrayList<class_2960>();
            ArrayList list = new ArrayList();
            while (packet.isReadable()) {
                int count = packet.readInt();
                identifiers.add(packet.method_10810());
                ArrayList<Integer> idList = new ArrayList<Integer>();
                for (int i = 0; i < count; ++i) {
                    idList.add(packet.readInt());
                }
                list.add(idList);
            }
            client.execute(() -> {
                Tiered.REFORGE_DATA_LOADER.clearReforgeBaseItems();
                for (int i = 0; i < identifiers.size(); ++i) {
                    ArrayList<class_1792> items = new ArrayList<class_1792>();
                    for (int u = 0; u < ((List)list.get(i)).size(); ++u) {
                        items.add((class_1792)class_7923.field_41178.method_10200(((Integer)((List)list.get(i)).get(u)).intValue()));
                    }
                    Tiered.REFORGE_DATA_LOADER.putReforgeBaseItems((class_2960)identifiers.get(i), items);
                }
            });
        });
    }
}

