/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.templates.model;

import io.github.cottonmc.templates.api.TemplatesClientApi;
import io.github.cottonmc.templates.model.RetexturingBakedModel;
import java.util.EnumMap;
import java.util.Map;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_2350;
import net.minecraft.class_3665;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class MeshTransformUtil {
    public static Mesh pretransformMesh(Mesh mesh, RenderContext.QuadTransform transform) {
        MeshBuilder builder = TemplatesClientApi.getInstance().getFabricRenderer().meshBuilder();
        QuadEmitter emitter = builder.getEmitter();
        mesh.forEach(quad -> {
            emitter.copyFrom(quad);
            if (transform.transform((MutableQuadView)emitter)) {
                emitter.emit();
            }
        });
        return builder.build();
    }

    public static Map<class_2350, class_2350> facePermutation(class_3665 aff) {
        return MeshTransformUtil.facePermutation(aff.method_3509().method_22936());
    }

    public static Map<class_2350, class_2350> facePermutation(Matrix4f mat) {
        EnumMap<class_2350, class_2350> facePermutation = new EnumMap<class_2350, class_2350>(class_2350.class);
        for (class_2350 input : class_2350.values()) {
            class_2350 output = class_2350.method_23225((Matrix4f)mat, (class_2350)input);
            facePermutation.put(input, output);
        }
        return facePermutation;
    }

    public static RenderContext.QuadTransform applyAffine(class_3665 settings) {
        return MeshTransformUtil.applyAffine(settings.method_3509().method_22936());
    }

    public static RenderContext.QuadTransform applyAffine(Matrix4f mat) {
        Map<class_2350, class_2350> facePermutation = MeshTransformUtil.facePermutation(mat);
        Vector3f pos3 = new Vector3f();
        Vector4f pos4 = new Vector4f();
        return quad -> {
            for (int i = 0; i < 4; ++i) {
                quad.copyPos(i, pos3);
                pos3.add(-0.5f, -0.5f, -0.5f);
                pos4.set((Vector3fc)pos3, 0.0f);
                mat.transformAffine(pos4);
                quad.pos(i, pos4.x + 0.5f, pos4.y + 0.5f, pos4.z + 0.5f);
            }
            int tag = quad.tag();
            if (tag != 0) {
                quad.tag(((class_2350)facePermutation.get(RetexturingBakedModel.DIRECTIONS[tag - 1])).ordinal() + 1);
            }
            quad.nominalFace((class_2350)facePermutation.get(quad.lightFace()));
            class_2350 cull = quad.cullFace();
            if (cull != null) {
                quad.cullFace((class_2350)facePermutation.get(cull));
            }
            return true;
        };
    }

    @Deprecated(forRemoval=true)
    public static RenderContext.QuadTransform applyMatrix(Matrix4f mat) {
        return MeshTransformUtil.applyAffine(mat);
    }
}

