/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.templates.gensupport;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.github.cottonmc.templates.gensupport.Ser;
import java.util.Comparator;
import java.util.Locale;
import java.util.function.UnaryOperator;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class Id
implements Ser<JsonPrimitive>,
Comparable<Id> {
    @NotNull
    public String ns;
    @NotNull
    public String path;
    public static final Comparator<Id> COMPARATOR = Comparator.comparing(id -> id.ns).thenComparing(id -> id.path);

    public Id(@NotNull String str) {
        String[] split = str.split(":");
        if (split.length == 1) {
            throw new IllegalArgumentException("not clear what namespace you mean: " + str);
        }
        if (split.length != 2) {
            throw new IllegalArgumentException("weird id: " + str);
        }
        this.ns = split[0];
        this.path = split[1];
    }

    public Id(@NotNull String ns, @NotNull String path) {
        this.ns = ns.toLowerCase(Locale.ROOT);
        this.path = path.toLowerCase(Locale.ROOT);
    }

    public static Id mc(String str) {
        return Id.fromStrFallback(str, "minecraft");
    }

    public static Id t(String str) {
        return Id.fromStrFallback(str, "templates");
    }

    public static Id fromStrFallback(String str, String fallbackNs) {
        String[] split = str.split(":");
        if (split.length == 1) {
            return new Id(fallbackNs, split[0]);
        }
        if (split.length == 2) {
            return new Id(split[0], split[1]);
        }
        throw new IllegalArgumentException("weird id " + str);
    }

    public Id mapPath(UnaryOperator<String> op) {
        return new Id(this.ns, (String)op.apply(this.path));
    }

    public Id prefixPath(String prefix) {
        if (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        return new Id(this.ns, prefix + "/" + this.path);
    }

    public String toString() {
        return this.ns + ":" + this.path;
    }

    public String toTranslationKey(String domain) {
        return domain + "." + this.ns + "." + this.path.replace('/', '.');
    }

    public class_2960 toMinecraft() {
        return new class_2960(this.ns, this.path);
    }

    @Override
    public JsonPrimitive ser() {
        return new JsonPrimitive(this.toString());
    }

    public static Id de(JsonElement elem) {
        if (elem instanceof JsonPrimitive) {
            JsonPrimitive prim = (JsonPrimitive)elem;
            return new Id(prim.getAsString());
        }
        throw new IllegalArgumentException("expected a prim, got " + elem.getClass().getSimpleName());
    }

    @Override
    public int compareTo(@NotNull Id o) {
        return COMPARATOR.compare(this, o);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Id id = (Id)o;
        return this.ns.equals(id.ns) && this.path.equals(id.path);
    }

    public int hashCode() {
        int result = this.ns.hashCode();
        result = 31 * result + this.path.hashCode();
        return result;
    }
}

