/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.reg;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.item.WoodBasedBlockItem;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacementsAPI;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CandleHolderBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CeilingBannerBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.DoubleCakeBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FlagBlock;
import net.mehvahdjukaar.supplementaries.common.items.FlagItem;
import net.mehvahdjukaar.supplementaries.common.items.PresentItem;
import net.mehvahdjukaar.supplementaries.common.items.SignPostItem;
import net.mehvahdjukaar.supplementaries.common.items.additional_placements.SuppAdditionalPlacement;
import net.mehvahdjukaar.supplementaries.common.misc.CakeRegistry;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.BuzzierBeesCompat;
import net.mehvahdjukaar.supplementaries.integration.CaveEnhancementsCompat;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_7923;

public class RegUtils {
    public static void initDynamicRegistry() {
        BlockSetAPI.registerBlockSetDefinition((BlockTypeRegistry)CakeRegistry.INSTANCE);
        BlockSetAPI.addDynamicBlockRegistration(RegUtils::registerDoubleCakes, CakeRegistry.CakeType.class);
        BlockSetAPI.addDynamicItemRegistration(RegUtils::registerSignPostItems, WoodType.class);
        BlockSetAPI.addDynamicBlockRegistration(RegUtils::dummy, WoodType.class);
    }

    private static void dummy(Registrator<class_2248> blockRegistrator, Collection<WoodType> ts) {
        boolean aa = true;
    }

    public static <T extends class_2248> RegSupplier<T> regPlaceableItem(String name, Supplier<T> sup, String itemLocation, Supplier<Boolean> config) {
        Supplier<class_1792> itemSupp = () -> (class_1792)class_7923.field_41178.method_10223(new class_2960(itemLocation));
        return RegUtils.regPlaceableItem(name, sup, itemSupp, config);
    }

    public static <T extends class_2248> RegSupplier<T> regPlaceableItem(String name, Supplier<T> blockFactory, Supplier<? extends class_1792> itemSupplier, Supplier<Boolean> config) {
        RegSupplier block = RegUtils.regBlock(name, blockFactory);
        if (config.get().booleanValue()) {
            AdditionalItemPlacementsAPI.register(() -> new SuppAdditionalPlacement((class_2248)block.get()), itemSupplier);
        }
        return block;
    }

    public static <T extends class_1792> Supplier<T> regItem(String name, Supplier<T> sup) {
        return RegHelper.registerItem((class_2960)Supplementaries.res(name), sup);
    }

    public static <T extends class_2591<E>, E extends class_2586> Supplier<T> regTile(String name, Supplier<T> sup) {
        return RegHelper.registerBlockEntityType((class_2960)Supplementaries.res(name), sup);
    }

    public static <T extends class_2248> RegSupplier<T> regBlock(String name, Supplier<T> sup) {
        return RegHelper.registerBlock((class_2960)Supplementaries.res(name), sup);
    }

    public static <T extends class_2248> RegSupplier<T> regWithItem(String name, Supplier<T> blockFactory) {
        return RegUtils.regWithItem(name, blockFactory, 0);
    }

    public static <T extends class_2248> RegSupplier<T> regWithItem(String name, Supplier<T> blockFactory, int burnTime) {
        return RegUtils.regWithItem(name, blockFactory, new class_1792.class_1793(), burnTime);
    }

    public static <T extends class_2248> RegSupplier<T> regWithItem(String name, Supplier<T> blockFactory, class_1792.class_1793 properties, int burnTime) {
        RegSupplier<T> block = RegUtils.regBlock(name, blockFactory);
        RegUtils.regBlockItem(name, block, properties, burnTime);
        return block;
    }

    public static RegSupplier<class_1747> regBlockItem(String name, Supplier<? extends class_2248> blockSup, class_1792.class_1793 properties, int burnTime) {
        return RegHelper.registerItem((class_2960)Supplementaries.res(name), () -> burnTime == 0 ? new class_1747((class_2248)blockSup.get(), properties) : new WoodBasedBlockItem((class_2248)blockSup.get(), properties, burnTime));
    }

    public static Map<class_1767, Supplier<class_2248>> registerCandleHolders(class_2960 baseName) {
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        class_4970.class_2251 prop = class_4970.class_2251.method_9637().method_9634().method_50012(class_3619.field_15971).method_22488().method_9618().method_9626(class_2498.field_17734);
        RegSupplier block = RegHelper.registerBlockWithItem((class_2960)baseName, () -> new CandleHolderBlock(null, prop));
        map.put(null, block);
        for (class_1767 color : BlocksColorAPI.SORTED_COLORS) {
            String name = baseName.method_12832() + "_" + color.method_7792();
            RegSupplier coloredBlock = RegHelper.registerBlockWithItem((class_2960)new class_2960(baseName.method_12836(), name), () -> new CandleHolderBlock(color, prop));
            map.put(color, coloredBlock);
        }
        if (CompatHandler.BUZZIER_BEES) {
            BuzzierBeesCompat.registerCandle(baseName);
        }
        if (CompatHandler.CAVE_ENHANCEMENTS) {
            CaveEnhancementsCompat.registerCandle(baseName);
        }
        return map;
    }

    public static Map<class_1767, Supplier<class_2248>> registerFlags(String baseName) {
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        for (class_1767 color : BlocksColorAPI.SORTED_COLORS) {
            String name = baseName + "_" + color.method_7792();
            RegSupplier<class_2248> block = RegUtils.regBlock(name, () -> new FlagBlock(color, class_4970.class_2251.method_9637().method_50013().method_31710(color.method_7794()).method_9632(1.0f).method_22488().method_9626(class_2498.field_11547)));
            map.put(color, block);
            RegUtils.regItem(name, () -> new FlagItem((class_2248)block.get(), new class_1792.class_1793().method_7889(16)));
        }
        return map;
    }

    public static Map<class_1767, Supplier<class_2248>> registerCeilingBanners(String baseName) {
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        for (class_1767 color : BlocksColorAPI.SORTED_COLORS) {
            String name = baseName + "_" + color.method_7792();
            map.put(color, RegUtils.regPlaceableItem(name, () -> new CeilingBannerBlock(color, class_4970.class_2251.method_9637().method_50013().method_51369().method_31710(color.method_7794()).method_9632(1.0f).method_9634().method_9626(class_2498.field_11547)), color.method_7792() + "_banner", CommonConfigs.Tweaks.CEILING_BANNERS));
        }
        return map;
    }

    public static Map<class_1767, Supplier<class_2248>> registerPresents(String baseName, BiFunction<class_1767, class_4970.class_2251, class_2248> presentFactory) {
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        RegSupplier<class_2248> block = RegUtils.regBlock(baseName, () -> (class_2248)presentFactory.apply(null, class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_50012(class_3619.field_15971).method_9632(1.0f).method_9626((class_2498)ModSounds.PRESENT)));
        map.put(null, block);
        RegUtils.regItem(baseName, () -> new PresentItem((class_2248)block.get(), new class_1792.class_1793()));
        for (class_1767 color : BlocksColorAPI.SORTED_COLORS) {
            String name = baseName + "_" + color.method_7792();
            RegSupplier<class_2248> bb = RegUtils.regBlock(name, () -> (class_2248)presentFactory.apply(color, class_4970.class_2251.method_9637().method_31710(color.method_7794()).method_9632(1.0f).method_9626((class_2498)ModSounds.PRESENT)));
            map.put(color, bb);
            RegUtils.regItem(name, () -> new PresentItem((class_2248)bb.get(), new class_1792.class_1793()));
        }
        return map;
    }

    private static void registerSignPostItems(Registrator<class_1792> event, Collection<WoodType> woodTypes) {
        for (WoodType wood : woodTypes) {
            String name = wood.getVariantId("sign_post");
            SignPostItem item = new SignPostItem(new class_1792.class_1793().method_7889(16), wood);
            wood.addChild("supplementaries:sign_post", (Object)item);
            event.register(Supplementaries.res(name), (Object)item);
            ModRegistry.SIGN_POST_ITEMS.put(wood, item);
        }
    }

    private static void registerDoubleCakes(Registrator<class_2248> event, Collection<CakeRegistry.CakeType> cakeTypes) {
        for (CakeRegistry.CakeType type : cakeTypes) {
            class_2960 id = Supplementaries.res(type.getVariantId("double"));
            DoubleCakeBlock block = new DoubleCakeBlock(type);
            type.addChild("double_cake", (Object)block);
            event.register(id, (Object)block);
            ModRegistry.DOUBLE_CAKES.put(type, block);
        }
    }
}

