/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.reg;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.util.AnimalFoodHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FrameBlock;
import net.mehvahdjukaar.supplementaries.common.block.cauldron.CauldronBehaviorsManager;
import net.mehvahdjukaar.supplementaries.common.block.dispenser.DispenserBehaviorsManager;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetBehaviorsManager;
import net.mehvahdjukaar.supplementaries.common.block.present.PresentBehaviorsManager;
import net.mehvahdjukaar.supplementaries.common.events.overrides.InteractEventOverrideHandler;
import net.mehvahdjukaar.supplementaries.common.items.loot.CurseLootFunction;
import net.mehvahdjukaar.supplementaries.common.items.loot.RandomArrowFunction;
import net.mehvahdjukaar.supplementaries.common.utils.FlowerPotHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.LootTablesInjects;
import net.mehvahdjukaar.supplementaries.reg.ModCreativeTabs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1781;
import net.minecraft.class_1853;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_3962;
import net.minecraft.class_5455;

public class ModSetup {
    private static boolean hasFinishedSetup = false;
    private static int setupStage = 0;
    private static boolean firstTagLoad = false;
    private static final List<Runnable> MOD_SETUP_WORK = List.of(CompatHandler::setup, FlowerPotHandler::setup, ModSetup::registerCompostables, ModSetup::registerMobFoods, ModSetup::registerFabricFlammable, CauldronBehaviorsManager::registerBehaviors, ModCreativeTabs::setup, () -> class_1853.field_9013.put(ModRegistry.ENDERMAN_SKULL_ITEM.get(), class_1781.class_1782.field_7974));

    public static void asyncSetup() {
        PresentBehaviorsManager.registerBehaviors();
        FaucetBehaviorsManager.registerBehaviors();
        RandomArrowFunction.setup();
        LootTablesInjects.setup();
        ModSetup.registerFrameBlocks();
        CurseLootFunction.setup();
    }

    public static void setup() {
        ArrayList<Long> list = new ArrayList<Long>();
        try {
            Stopwatch watch = Stopwatch.createStarted();
            for (int i = 0; i < MOD_SETUP_WORK.size(); ++i) {
                setupStage = i;
                MOD_SETUP_WORK.get(i).run();
                list.add(watch.elapsed().toMillis());
                watch.reset();
                watch.start();
            }
            hasFinishedSetup = true;
            Supplementaries.LOGGER.info("Finished mod setup in: {} ms", list);
        }
        catch (Exception e) {
            Supplementaries.LOGGER.error((Object)e);
            ModSetup.terminateWhenSetupFails();
        }
    }

    private static void terminateWhenSetupFails() {
        throw new IllegalStateException("Mod setup has failed to complete (" + setupStage + ").\n This might be due to some mod incompatibility or outdated dependencies (check if everything is up to date).\n Refusing to continue loading with a broken modstate. Next step: crashing this game, no survivors");
    }

    private static void registerFabricFlammable() {
        RegHelper.registerBlockFlammability((class_2248)ModRegistry.ROPE.get(), (int)60, (int)100);
    }

    private static void registerMobFoods() {
        AnimalFoodHelper.addChickenFood((class_1935[])new class_1935[]{(class_1935)ModRegistry.FLAX_SEEDS_ITEM.get()});
        AnimalFoodHelper.addHorseFood((class_1935[])new class_1935[]{(class_1935)ModRegistry.FLAX_BLOCK.get(), (class_1935)ModRegistry.SUGAR_CUBE.get(), (class_1935)ModRegistry.FLAX_ITEM.get()});
        AnimalFoodHelper.addParrotFood((class_1935[])new class_1935[]{(class_1935)ModRegistry.FLAX_SEEDS_ITEM.get()});
    }

    private static void registerFrameBlocks() {
        ((FrameBlock)ModRegistry.TIMBER_FRAME.get()).registerFilledBlock((class_2248)ModRegistry.DAUB.get(), (class_2248)ModRegistry.DAUB_FRAME.get());
        ModRegistry.TIMBER_BRACE.get().registerFilledBlock((class_2248)ModRegistry.DAUB.get(), (class_2248)ModRegistry.DAUB_BRACE.get());
        ModRegistry.TIMBER_CROSS_BRACE.get().registerFilledBlock((class_2248)ModRegistry.DAUB.get(), (class_2248)ModRegistry.DAUB_CROSS_BRACE.get());
    }

    private static void registerCompostables() {
        class_3962.field_17566.put((Object)((class_1935)ModRegistry.FLAX_SEEDS_ITEM.get()), 0.3f);
        class_3962.field_17566.put((Object)((class_1935)ModRegistry.FLAX_ITEM.get()), 0.65f);
        class_3962.field_17566.put((Object)ModRegistry.FLAX_WILD.get().method_8389(), 0.65f);
        class_3962.field_17566.put((Object)ModRegistry.FLAX_BLOCK.get().method_8389(), 1.0f);
    }

    public static void tagDependantSetup(class_5455 registryAccess) {
        if (!firstTagLoad) {
            Stopwatch watch = Stopwatch.createStarted();
            firstTagLoad = true;
            if (!hasFinishedSetup) {
                try {
                    Supplementaries.LOGGER.error("Something went wrong during mod setup, exiting");
                    MOD_SETUP_WORK.get(setupStage).run();
                    Supplementaries.LOGGER.error("No error found. Weird");
                }
                catch (Exception e) {
                    Supplementaries.LOGGER.error((Object)e);
                }
                ModSetup.terminateWhenSetupFails();
            }
            DispenserBehaviorsManager.registerBehaviors(registryAccess);
            InteractEventOverrideHandler.registerOverrides();
            Supplementaries.LOGGER.info("Finished additional setup in {} ms", (Object)watch.elapsed().toMillis());
        }
    }
}

