/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils.fabric;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadBuilder;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.DummySprite;
import net.mehvahdjukaar.supplementaries.client.block_models.WallLanternBakedModel;
import net.mehvahdjukaar.supplementaries.common.utils.VibeChecker;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1093;
import net.minecraft.class_2350;
import net.minecraft.class_3665;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4590;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.joml.Vector3f;

public class VibeCheckerImpl {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void checkVibe() {
        VibeCheckerImpl.crashIfFabricRenderingAPIHasBeenNuked();
        VibeCheckerImpl.unfixSodiumDeps();
        if (PlatHelper.getPhysicalSide().isClient()) {
            VibeCheckerImpl.vibeCheckModels();
        }
        if (PlatHelper.isModLoaded((String)"immediatelyfast")) {
            Supplementaries.LOGGER.warn("Immediately fast was detected. Colored maps and map texture mipmap will not work unless you turn map changes off in IF configs");
        }
    }

    private static void unfixSodiumDeps() {
        JsonObject jo;
        JsonElement obj = null;
        File file = FabricLoader.getInstance().getConfigDir().resolve("fabric_loader_dependencies.json").toFile();
        if (file.exists() && file.isFile()) {
            try (FileInputStream fileInputStream2 = new FileInputStream(file);
                 InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream2, StandardCharsets.UTF_8);
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                obj = (JsonElement)GSON.fromJson((Reader)bufferedReader, JsonElement.class);
            }
            catch (IOException fileInputStream2) {
                // empty catch block
            }
        }
        if (obj instanceof JsonObject && (jo = (JsonObject)obj).has("overrides")) {
            JsonObject overrides = jo.getAsJsonObject("overrides");
            overrides.remove("sodium");
            jo.add("overrides", (JsonElement)overrides);
        }
        if (obj != null) {
            try (FileOutputStream stream = new FileOutputStream(file);
                 OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);){
                GSON.toJson(obj, (Appendable)writer);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void fixSodiumDeps() {
        JsonObject obj = new JsonObject();
        File file = FabricLoader.getInstance().getConfigDir().resolve("fabric_loader_dependencies.json").toFile();
        if (file.exists() && file.isFile()) {
            try (FileInputStream fileInputStream2 = new FileInputStream(file);
                 InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream2, StandardCharsets.UTF_8);
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                obj = (JsonElement)GSON.fromJson((Reader)bufferedReader, JsonElement.class);
            }
            catch (IOException fileInputStream2) {
                // empty catch block
            }
        }
        if (obj instanceof JsonObject) {
            JsonObject jo = obj;
            if (!jo.has("version")) {
                jo.addProperty("version", (Number)1);
            }
            JsonObject overrides = new JsonObject();
            if (jo.has("overrides")) {
                overrides = jo.getAsJsonObject("overrides");
            }
            JsonObject prop = new JsonObject();
            JsonObject dep = new JsonObject();
            dep.addProperty("indium", "*");
            prop.add("+depends", (JsonElement)dep);
            JsonObject dep2 = new JsonObject();
            dep2.addProperty("fabric-renderer-indigo", "*");
            overrides.add("sodium", (JsonElement)prop);
            jo.add("overrides", (JsonElement)overrides);
        }
        try (FileOutputStream stream = new FileOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);){
            GSON.toJson((JsonElement)obj, (Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void crashIfFabricRenderingAPIHasBeenNuked() {
        if (PlatHelper.isModLoaded((String)"sodium") && !PlatHelper.isModLoaded((String)"indium")) {
            throw new VibeChecker.BadModError("You seem to have installed Sodium which has been known to break fabric rendering API.Things might not work well");
        }
    }

    public static void vibeCheckModels() {
        try {
            DummySprite textureAtlasSprite = DummySprite.INSTANCE;
            BakedQuadBuilder b = BakedQuadBuilder.create((class_1058)textureAtlasSprite);
            b.setAutoDirection();
            VertexUtil.addQuad((class_4588)b, (class_4587)new class_4587(), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)0, (int)0);
            class_777 dummy = b.build();
            List<class_777> l = List.of(dummy);
            EnumMap map = Maps.newEnumMap(class_2350.class);
            map.putAll(Map.of(class_2350.field_11033, l, class_2350.field_11036, l, class_2350.field_11035, l, class_2350.field_11043, l, class_2350.field_11039, l, class_2350.field_11034, l));
            new WallLanternBakedModel((class_1087)new class_1093(l, (Map)map, false, false, false, (class_1058)textureAtlasSprite, class_809.field_4301, class_806.field_4292), new class_3665(){

                public class_4590 method_3509() {
                    return new class_4590(new Vector3f(1.0f, 1.0f, 1.0f), null, null, null);
                }
            });
        }
        catch (Exception e) {
            throw new VibeChecker.BadModError("Some OTHER mod failed to load baked models. Refusing to proceed further to prevent in game issues. See logs for details", e);
        }
    }
}

