/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.songs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_3532;

public class Song {
    public static final Song EMPTY = new Song("empty", 1, List.of(), "", 1);
    public static final Codec<Song> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(p -> p.name), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("tempo", (Object)1).forGetter(p -> p.tempo), (App)Codec.INT.listOf().fieldOf("notes").forGetter(p -> Arrays.stream(p.notes).boxed().toList()), (App)Codec.STRING.optionalFieldOf("credits", (Object)"").forGetter(p -> p.credits), (App)Codec.intRange((int)0, (int)10000).optionalFieldOf("weight", (Object)100).forGetter(p -> p.weight)).apply((Applicative)instance, Song::new)).comapFlatMap(s -> {
        if (s.notes.length == 0) {
            return DataResult.error(() -> "Song note list cant be empty");
        }
        return DataResult.success((Object)s);
    }, Function.identity());
    private final String name;
    private final int tempo;
    private int[] notes;
    private final String credits;
    private final int weight;
    private boolean processed = false;

    public Song(String name, int tempo, List<Integer> notes, String credits, int weight) {
        this.name = name;
        this.tempo = Math.max(1, tempo);
        this.notes = notes.stream().mapToInt(value -> value).toArray();
        this.credits = credits;
        this.weight = weight;
    }

    public boolean isValid() {
        return this.processed;
    }

    private void processForPlaying() {
        IntArrayList newNotes = new IntArrayList();
        for (int i : this.notes) {
            if (i <= 0) {
                int j = -Math.min(-1, i);
                int blanks = j - 1;
                for (int k = 0; k < blanks; ++k) {
                    newNotes.add(0);
                }
                continue;
            }
            newNotes.add(i);
        }
        this.notes = newNotes.elements();
    }

    public String getTranslationKey() {
        return this.name;
    }

    public int getTempo() {
        return Math.max(1, this.tempo);
    }

    public int[] getNotes() {
        return this.notes;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Song: " + this.name;
    }

    public int getWeight() {
        return this.weight;
    }

    public IntList getNoteToPlay(long timeSinceStarted) {
        IntArrayList toPlay = new IntArrayList();
        try {
            int currentIndex = (int)(timeSinceStarted / (long)this.getTempo()) % this.notes.length;
            for (int n = this.notes[currentIndex]; n > 1; n /= 100) {
                toPlay.add(class_3532.method_15340((int)(n % 100), (int)0, (int)25));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toPlay;
    }

    public void validatePlayReady() {
        if (!this.processed) {
            this.processForPlaying();
            this.processed = true;
        }
    }
}

