/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncAmbientLightPacket;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.minecraft.class_1011;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class MapLightHandler {
    private static boolean enabled = false;
    public static final CustomMapData.Type<LightData> LIGHT_DATA = MapDataRegistry.registerCustomMapSavedData((class_2960)Supplementaries.res("light_data"), LightData::new);
    private static final Object2IntMap<class_5321<class_1937>> LIGHT_PER_WORLD = new Object2IntArrayMap();
    @Nullable
    private static Object lightMap = null;

    public static void init() {
    }

    public static void setActive(boolean on) {
        enabled = on;
    }

    public static LightData getLightData(class_22 data) {
        return (LightData)LIGHT_DATA.get(data);
    }

    public static boolean isActive() {
        return enabled;
    }

    @Environment(value=EnvType.CLIENT)
    public static void setLightMap(@Nullable class_1011 map) {
        if (map != null) {
            Preconditions.checkArgument((map.method_4307() != 16 || map.method_4323() != 6 ? 1 : 0) != 0, (Object)"Lightmap must be 16x16");
        }
        lightMap = map;
    }

    @ApiStatus.Internal
    public static void setAmbientLight(Object2IntMap<class_5321<class_1937>> ambientLight) {
        LIGHT_PER_WORLD.clear();
        LIGHT_PER_WORLD.putAll(ambientLight);
    }

    @ApiStatus.Internal
    public static void sendDataToClient(class_3222 player) {
        if (enabled) {
            NetworkHandler.CHANNEL.sendToClientPlayer(player, (Message)new ClientBoundSyncAmbientLightPacket(player.method_37908().method_30349()));
        }
    }

    public static class LightData
    implements CustomMapData<Counter> {
        private static final String LIGHTMAP_TAG = "lightmap";
        public static final String MIN_X = "min_x";
        public static final String MAX_X = "max_x";
        public static final String MIN_Z = "min_z";
        private byte[][] data = null;

        private int getEntry(int x, int z) {
            if (this.data == null) {
                return 0;
            }
            if (x < 0 || x >= 128 || z < 0 || z >= 128) {
                return 0;
            }
            if (this.data[x] != null) {
                return Byte.toUnsignedInt(this.data[x][z]);
            }
            return 0;
        }

        private void addEntry(class_22 md, int x, int z, int packedLight) {
            if (this.data == null) {
                this.data = new byte[128][];
            }
            if (this.data[x] == null) {
                this.data[x] = new byte[128];
            }
            this.data[x][z] = (byte)packedLight;
            this.setDirty(md, counter -> counter.markDirty(x, z));
        }

        public void load(class_2487 tag) {
            if (tag.method_10545(LIGHTMAP_TAG)) {
                class_2487 t = tag.method_10562(LIGHTMAP_TAG);
                int minX = 0;
                if (t.method_10545(MIN_X)) {
                    minX = t.method_10550(MIN_X);
                }
                int maxX = 127;
                if (t.method_10545(MAX_X)) {
                    maxX = t.method_10550(MAX_X);
                }
                int minZ = 0;
                if (t.method_10545(MIN_Z)) {
                    minZ = t.method_10550(MIN_Z);
                }
                for (int x = minX; x <= maxX; ++x) {
                    byte[] rowData = t.method_10547("pos_" + x);
                    if (this.data == null) {
                        this.data = new byte[128][];
                    }
                    if (this.data[x] == null) {
                        this.data[x] = new byte[128];
                    }
                    System.arraycopy(rowData, 0, this.data[x], minZ, rowData.length);
                }
            }
        }

        private void savePatch(class_2487 tag, int minX, int maxX, int minZ, int maxZ, boolean pos) {
            if (pos && this.data != null) {
                class_2487 t = new class_2487();
                if (minX != 0) {
                    t.method_10569(MIN_X, minX);
                }
                if (maxX != 127) {
                    t.method_10569(MAX_X, maxX);
                }
                if (minZ != 0) {
                    t.method_10569(MIN_Z, minZ);
                }
                for (int x = minX; x <= maxX; ++x) {
                    if (this.data[x] == null) continue;
                    byte[] rowData = new byte[maxZ - minZ + 1];
                    System.arraycopy(this.data[x], minZ, rowData, 0, rowData.length);
                    t.method_10570("pos_" + x, rowData);
                }
                tag.method_10566(LIGHTMAP_TAG, (class_2520)t);
            }
        }

        public void save(class_2487 tag) {
            this.savePatch(tag, 0, 127, 0, 127, true);
        }

        public void saveToUpdateTag(class_2487 tag, Counter dc) {
            this.savePatch(tag, dc.minDirtyX, dc.maxDirtyX, dc.minDirtyZ, dc.maxDirtyZ, dc.posDirty);
        }

        public void loadUpdateTag(class_2487 tag) {
            this.load(tag);
        }

        public boolean persistOnCopyOrLock() {
            return false;
        }

        public CustomMapData.Type<?> getType() {
            return LIGHT_DATA;
        }

        public Counter createDirtyCounter() {
            return new Counter();
        }

        public void setLightLevel(int x, int z, int blockLight, int skyLight, class_22 data) {
            int packed = blockLight << 4 | 15 - skyLight;
            if (packed != 0) {
                if (!Objects.equals(this.getEntry(x, z), packed)) {
                    this.addEntry(data, x, z, packed);
                }
            } else if (this.data != null && this.data[x] != null && this.data[x][z] != 0) {
                this.data[x][z] = 0;
                this.setDirty(data, counter -> counter.markDirty(x, z));
                for (byte b : this.data[x]) {
                    if (b == 0) continue;
                    return;
                }
                this.data[x] = null;
            }
        }

        @Environment(value=EnvType.CLIENT)
        public void processTexture(class_1011 texture, int startX, int startY, class_5321<class_1937> levelKey) {
            if (lightMap == null) {
                return;
            }
            for (int x = 0; x < 128; ++x) {
                for (int z = 0; z < 128; ++z) {
                    int light = this.getEntry(x, z);
                    int minL = LIGHT_PER_WORLD.getOrDefault(levelKey, 0);
                    int skyDarkness = light & 0xF;
                    int blockLight = Math.max(minL, light >> 4 & 0xF);
                    int pX = startX + x;
                    int pY = startY + z;
                    int originalColor = texture.method_4315(pX, pY);
                    int skyLight = 15 - skyDarkness;
                    RGBColor lightColor = new RGBColor(((class_1011)lightMap).method_4315(blockLight, skyLight));
                    float intensity = 1.0f;
                    int newColor = new RGBColor(originalColor).multiply(lightColor.red() * intensity, lightColor.green() * intensity, lightColor.green() * intensity, 1.0f).toInt();
                    texture.method_4305(pX, pY, newColor);
                }
            }
        }

        public void clear() {
            this.data = null;
        }
    }

    private static class Counter
    implements CustomMapData.DirtyCounter {
        private int minDirtyX = 0;
        private int maxDirtyX = 127;
        private int minDirtyZ = 0;
        private int maxDirtyZ = 127;
        private boolean posDirty = true;

        private Counter() {
        }

        public void markDirty(int x, int z) {
            if (this.posDirty) {
                this.minDirtyX = Math.min(this.minDirtyX, x);
                this.minDirtyZ = Math.min(this.minDirtyZ, z);
                this.maxDirtyX = Math.max(this.maxDirtyX, x);
                this.maxDirtyZ = Math.max(this.maxDirtyZ, z);
            } else {
                this.posDirty = true;
                this.minDirtyX = x;
                this.minDirtyZ = z;
                this.maxDirtyX = x;
                this.maxDirtyZ = z;
            }
        }

        public boolean isDirty() {
            return this.posDirty;
        }

        public void clearDirty() {
            this.posDirty = false;
            this.minDirtyX = 0;
            this.minDirtyZ = 0;
            this.maxDirtyX = 0;
            this.maxDirtyZ = 0;
        }
    }
}

