/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.block.IOwnerProtected;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.common.block.IKeyLockable;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SafeBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.OpeneableContainerBlockEntity;
import net.mehvahdjukaar.supplementaries.common.inventories.SafeContainerMenu;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_4838;
import org.jetbrains.annotations.Nullable;

public class SafeBlockTile
extends OpeneableContainerBlockEntity
implements IOwnerProtected,
IKeyLockable {
    @Nullable
    private String password = null;
    private String ownerName = null;
    private UUID owner = null;

    public SafeBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.SAFE_TILE.get(), pos, state, 27);
    }

    public boolean handleAction(class_1657 player, class_1268 handIn) {
        class_1799 stack = player.method_5998(handIn);
        class_1792 item = stack.method_7909();
        boolean cleared = false;
        if (CommonConfigs.Functional.SAFE_SIMPLE.get().booleanValue()) {
            if ((item == class_1802.field_8366 || stack.method_31573(ModTags.KEYS)) && (this.isOwnedBy(player) || this.isNotOwnedBy(player) && player.method_7337())) {
                cleared = true;
            }
        } else if (player.method_5715() && (player.method_7337() || this.getKeyStatus(stack).isCorrect())) {
            cleared = true;
        }
        if (cleared) {
            this.clearPassword();
            this.onPasswordCleared(player, this.field_11867);
            return true;
        }
        class_2338 frontPos = this.field_11867.method_10093((class_2350)this.method_11010().method_11654((class_2769)SafeBlock.FACING));
        if (!this.field_11863.method_8320(frontPos).method_26212((class_1922)this.field_11863, frontPos)) {
            if (CommonConfigs.Functional.SAFE_SIMPLE.get().booleanValue()) {
                UUID owner = this.getOwner();
                if (owner == null) {
                    owner = player.method_5667();
                    this.setOwner(owner);
                }
                if (!owner.equals(player.method_5667())) {
                    player.method_7353((class_2561)class_2561.method_43469((String)"message.supplementaries.safe.owner", (Object[])new Object[]{this.ownerName}), true);
                    if (!player.method_7337()) {
                        return true;
                    }
                }
            } else {
                String key = this.getPassword();
                if (key == null) {
                    String newKey = IKeyLockable.getKeyPassword(stack);
                    if (newKey != null) {
                        this.setPassword(newKey);
                        this.onKeyAssigned(this.field_11863, this.field_11867, player, newKey);
                        return true;
                    }
                } else if (!this.canPlayerOpen(player, true) && !player.method_7337()) {
                    return true;
                }
            }
            PlatHelper.openCustomMenu((class_3222)((class_3222)player), (class_3908)this, (class_2338)this.field_11867);
            class_4838.method_24733((class_1657)player, (boolean)true);
        }
        return true;
    }

    public boolean canPlayerOpen(class_1657 player, boolean feedbackMessage) {
        if (player == null || player.method_7337()) {
            return true;
        }
        if (CommonConfigs.Functional.SAFE_SIMPLE.get().booleanValue()) {
            if (this.isNotOwnedBy(player)) {
                if (feedbackMessage) {
                    player.method_7353((class_2561)class_2561.method_43469((String)"message.supplementaries.safe.owner", (Object[])new Object[]{this.ownerName}), true);
                }
                return false;
            }
        } else {
            return this.testIfHasCorrectKey(player, this.password, feedbackMessage, "safe");
        }
        return true;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void clearPassword() {
        this.ownerName = null;
        this.owner = null;
        this.password = null;
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        if (this.field_11863 != null) {
            if (owner != null) {
                class_1657 p = this.field_11863.method_18470(owner);
                if (p != null) {
                    this.ownerName = p.method_5477().getString();
                }
                this.owner = owner;
            }
            this.method_5431();
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 2);
        }
    }

    public boolean method_17489(class_1657 player) {
        if (!super.method_17489(player)) {
            return false;
        }
        return this.canPlayerOpen(player, false);
    }

    public class_2561 method_5476() {
        if (CommonConfigs.Functional.SAFE_SIMPLE.get().booleanValue()) {
            if (this.ownerName != null && this.shouldShowPassword()) {
                return class_2561.method_43469((String)"gui.supplementaries.safe.name", (Object[])new Object[]{this.ownerName, super.method_5476()});
            }
        } else if (this.password != null && this.shouldShowPassword()) {
            return class_2561.method_43469((String)"gui.supplementaries.safe.password", (Object[])new Object[]{this.password, super.method_5476()});
        }
        return super.method_5476();
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"block.supplementaries.safe");
    }

    @Override
    protected void playOpenSound(class_2680 state) {
        class_2382 vec3i = ((class_2350)state.method_11654((class_2769)SafeBlock.FACING)).method_10163();
        double d0 = (double)this.field_11867.method_10263() + 0.5 + (double)vec3i.method_10263() / 2.0;
        double d1 = (double)this.field_11867.method_10264() + 0.5 + (double)vec3i.method_10264() / 2.0;
        double d2 = (double)this.field_11867.method_10260() + 0.5 + (double)vec3i.method_10260() / 2.0;
        this.field_11863.method_43128(null, d0, d1, d2, class_3417.field_15082, class_3419.field_15245, 0.5f, this.field_11863.field_9229.method_43057() * 0.1f + 0.65f);
    }

    @Override
    protected void playCloseSound(class_2680 state) {
        class_2382 vec3i = ((class_2350)state.method_11654((class_2769)SafeBlock.FACING)).method_10163();
        double d0 = (double)this.field_11867.method_10263() + 0.5 + (double)vec3i.method_10263() / 2.0;
        double d1 = (double)this.field_11867.method_10264() + 0.5 + (double)vec3i.method_10264() / 2.0;
        double d2 = (double)this.field_11867.method_10260() + 0.5 + (double)vec3i.method_10260() / 2.0;
        this.field_11863.method_43128(null, d0, d1, d2, class_3417.field_15131, class_3419.field_15245, 0.5f, this.field_11863.field_9229.method_43057() * 0.1f + 0.65f);
    }

    @Override
    protected void updateBlockState(class_2680 state, boolean open) {
        this.field_11863.method_8652(this.method_11016(), (class_2680)state.method_11657((class_2769)SafeBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.owner = tag.method_10545("Owner") ? tag.method_25926("Owner") : null;
        if (tag.method_10545("OwnerName")) {
            this.ownerName = tag.method_10558("OwnerName");
        } else {
            this.owner = null;
        }
        this.password = tag.method_10545("Password") ? tag.method_10558("Password") : null;
    }

    @Override
    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        this.saveOwner(compound);
        if (this.ownerName != null) {
            compound.method_10582("OwnerName", this.ownerName);
        }
        if (this.password != null) {
            compound.method_10582("Password", this.password);
        }
    }

    public boolean method_5437(int index, class_1799 stack) {
        return MiscUtils.isAllowedInShulker(stack, this.method_10997()) && !this.getKeyStatus(stack).isCorrect();
    }

    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 direction) {
        return false;
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return false;
    }

    public class_1703 method_5465(int id, class_1661 player) {
        return new SafeContainerMenu(id, player, this);
    }
}

