/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FaucetBlock;
import net.mehvahdjukaar.supplementaries.common.block.faucet.IFaucetBlockSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.IFaucetBlockTarget;
import net.mehvahdjukaar.supplementaries.common.block.faucet.IFaucetFluidSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.IFaucetItemSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.IFaucetTileSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.IFaucetTileTarget;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;

public class FaucetBlockTile
extends class_2586
implements IExtraModelDataProvider {
    private static final List<IFaucetBlockSource> BLOCK_INTERACTIONS = new ArrayList<IFaucetBlockSource>();
    private static final List<IFaucetTileSource> TILE_INTERACTIONS = new ArrayList<IFaucetTileSource>();
    private static final List<IFaucetFluidSource> FLUID_INTERACTIONS = new ArrayList<IFaucetFluidSource>();
    private static final List<IFaucetItemSource> ITEM_INTERACTIONS = new ArrayList<IFaucetItemSource>();
    private static final List<IFaucetBlockTarget> TARGET_BLOCK_INTERACTIONS = new ArrayList<IFaucetBlockTarget>();
    private static final List<IFaucetTileTarget> TARGET_TILE_INTERACTIONS = new ArrayList<IFaucetTileTarget>();
    public static final ModelDataKey<SoftFluid> FLUID = ModBlockProperties.FLUID;
    public static final ModelDataKey<Integer> FLUID_COLOR = ModBlockProperties.FLUID_COLOR;
    public static final int COOLDOWN = 20;
    private int transferCooldown = 0;
    public final SoftFluidTank tempFluidHolder = SoftFluidTank.create((int)5);
    public static final Predicate<class_1297> NON_PLAYER = e -> e.method_5805() && !(e instanceof class_1657);

    public FaucetBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.FAUCET_TILE.get(), pos, state);
    }

    public ExtraModelData getExtraModelData() {
        int color = -1;
        if (this.field_11863 != null) {
            color = this.tempFluidHolder.getFlowingTint((class_1920)this.field_11863, this.field_11867);
        }
        return ExtraModelData.builder().with(FLUID, (Object)this.tempFluidHolder.getFluid()).with(FLUID_COLOR, (Object)color).build();
    }

    public void updateLight() {
        if (this.field_11863 == null) {
            return;
        }
        int light = this.tempFluidHolder.getFluid().getLuminosity();
        if (light != 0) {
            light = (int)class_3532.method_15363((float)((float)light / 2.0f), (float)1.0f, (float)7.0f);
        }
        if (light != (Integer)this.method_11010().method_11654((class_2769)FaucetBlock.LIGHT_LEVEL)) {
            this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)FaucetBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(light)), 2);
        }
    }

    public static void tick(class_1937 pLevel, class_2338 pPos, class_2680 pState, FaucetBlockTile tile) {
        if (tile.transferCooldown > 0) {
            --tile.transferCooldown;
        } else if (tile.isOpen()) {
            int cooldown = tile.tryExtract(pLevel, pPos, pState, true);
            tile.transferCooldown += cooldown;
        }
    }

    public boolean updateContainedFluidVisuals(class_1937 level, class_2338 pos, class_2680 state) {
        class_3610 fluidState = level.method_8316(pos.method_10093(((class_2350)state.method_11654((class_2769)FaucetBlock.FACING)).method_10153()));
        if (!fluidState.method_15769() && fluidState.method_15771()) {
            SoftFluid f = SoftFluidRegistry.fromForgeFluid((class_3611)fluidState.method_15772());
            if (f != null) {
                this.tempFluidHolder.fill(f);
                this.updateLight();
                return true;
            }
            boolean bl = true;
        }
        boolean r = this.tryExtract(level, pos, state, false) != 0;
        this.updateLight();
        this.requestModelReload();
        return r;
    }

    private int tryExtract(class_1937 level, class_2338 pos, class_2680 state, boolean doTransfer) {
        class_2586 tileBack;
        class_2350 dir = (class_2350)state.method_11654((class_2769)FaucetBlock.FACING);
        class_2338 behind = pos.method_10093(dir.method_10153());
        class_2680 backState = level.method_8320(behind);
        this.tempFluidHolder.clear();
        if (backState.method_26215()) {
            return 0;
        }
        FillAction fillAction = doTransfer ? this::tryFillingBlockBelow : null;
        for (IFaucetBlockSource iFaucetBlockSource : BLOCK_INTERACTIONS) {
            class_1269 class_12692 = iFaucetBlockSource.tryDrain(level, this.tempFluidHolder, behind, backState, fillAction);
            if (class_12692 == class_1269.field_5811) continue;
            if (class_12692 == class_1269.field_5812) {
                return iFaucetBlockSource.getTransferCooldown();
            }
            if (class_12692 == class_1269.field_21466) break;
            if (class_12692 != class_1269.field_5814) continue;
            return 0;
        }
        if ((tileBack = level.method_8321(behind)) != null) {
            for (IFaucetTileSource iFaucetTileSource : TILE_INTERACTIONS) {
                class_1269 res = iFaucetTileSource.tryDrain(level, this.tempFluidHolder, behind, tileBack, dir, fillAction);
                if (res == class_1269.field_5811) continue;
                if (res == class_1269.field_5812) {
                    return iFaucetTileSource.getTransferCooldown();
                }
                if (res == class_1269.field_21466) break;
                if (res != class_1269.field_5814) continue;
                return 0;
            }
            if (!doTransfer) {
                return !this.tempFluidHolder.isEmpty() ? 20 : 0;
            }
        }
        if (!this.isConnectedBelow() && (CommonConfigs.Redstone.FAUCET_DROP_ITEMS.get().booleanValue() || CommonConfigs.Redstone.FAUCET_FILL_ENTITIES.get().booleanValue())) {
            for (IFaucetItemSource iFaucetItemSource : ITEM_INTERACTIONS) {
                class_1799 removed = iFaucetItemSource.tryExtractItem(level, behind, backState, dir, tileBack);
                if (removed.method_7960()) continue;
                if (!(CommonConfigs.Redstone.FAUCET_FILL_ENTITIES.get().booleanValue() && this.fillEntityBelow(removed, dir) || !CommonConfigs.Redstone.FAUCET_DROP_ITEMS.get().booleanValue())) {
                    this.drop(removed);
                }
                return 20;
            }
        }
        class_3610 class_36102 = level.method_8316(behind);
        for (IFaucetFluidSource bi : FLUID_INTERACTIONS) {
            class_1269 res = bi.tryDrain(level, this.tempFluidHolder, behind, class_36102, fillAction);
            if (res == class_1269.field_5811) continue;
            if (res == class_1269.field_5812) {
                return bi.getTransferCooldown();
            }
            if (res == class_1269.field_21466) break;
            if (res != class_1269.field_5814) continue;
            return 0;
        }
        if (!doTransfer) {
            return !this.tempFluidHolder.isEmpty() ? 20 : 0;
        }
        return 0;
    }

    private boolean tryFillingBlockBelow() {
        class_2586 tileBelow;
        SoftFluid softFluid = this.tempFluidHolder.getFluid();
        if (softFluid.isEmpty()) {
            return false;
        }
        class_2338 below = this.field_11867.method_10074();
        class_2680 belowState = this.field_11863.method_8320(below);
        for (IFaucetBlockTarget bi : TARGET_BLOCK_INTERACTIONS) {
            class_1269 res = bi.tryFill(this.field_11863, this.tempFluidHolder, below, belowState);
            if (res == class_1269.field_5811) continue;
            if (res == class_1269.field_5812) {
                return true;
            }
            if (res == class_1269.field_21466) break;
            if (res != class_1269.field_5814) continue;
            return false;
        }
        if ((tileBelow = this.field_11863.method_8321(below)) != null) {
            for (IFaucetTileTarget bi : TARGET_TILE_INTERACTIONS) {
                class_1269 res = bi.tryFill(this.field_11863, this.tempFluidHolder, below, tileBelow);
                if (res == class_1269.field_5811) continue;
                if (res == class_1269.field_5812) {
                    return true;
                }
                if (res == class_1269.field_21466) break;
                if (res != class_1269.field_5814) continue;
                return false;
            }
        }
        return false;
    }

    public boolean isOpen() {
        return (Boolean)this.method_11010().method_11654((class_2769)class_2741.field_12484) ^ (Boolean)this.method_11010().method_11654((class_2769)class_2741.field_12515);
    }

    public boolean hasWater() {
        return (Boolean)this.method_11010().method_11654((class_2769)FaucetBlock.HAS_WATER);
    }

    public boolean isConnectedBelow() {
        return (Boolean)this.method_11010().method_11654((class_2769)FaucetBlock.CONNECTED);
    }

    private void drop(class_1799 extracted) {
        class_2338 pos = this.field_11867;
        class_1542 drop = new class_1542(this.field_11863, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, extracted);
        drop.method_18799(new class_243(0.0, 0.0, 0.0));
        this.field_11863.method_8649((class_1297)drop);
        float f = (this.field_11863.field_9229.method_43057() - 0.5f) / 4.0f;
        this.field_11863.method_8396(null, pos, class_3417.field_15219, class_3419.field_15245, 0.3f, 0.5f + f);
    }

    private boolean fillEntityBelow(class_1799 stack, class_2350 direction) {
        List list = this.field_11863.method_8333((class_1297)null, new class_238(this.field_11867).method_989(0.0, -0.75, 0.0), NON_PLAYER);
        Collections.shuffle(list);
        for (class_1297 o : list) {
            if (!(stack = ItemsUtil.tryAddingItem(stack, this.field_11863, direction, o)).method_7960()) continue;
            return true;
        }
        return false;
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.transferCooldown = compound.method_10550("TransferCooldown");
        this.tempFluidHolder.load(compound);
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("TransferCooldown", this.transferCooldown);
        this.tempFluidHolder.save(tag);
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public static void registerInteraction(Object interaction) {
        Object bs;
        boolean success = false;
        if (interaction instanceof IFaucetBlockSource) {
            bs = (IFaucetBlockSource)interaction;
            BLOCK_INTERACTIONS.add((IFaucetBlockSource)bs);
            success = true;
        }
        if (interaction instanceof IFaucetTileSource) {
            IFaucetTileSource ts = (IFaucetTileSource)interaction;
            TILE_INTERACTIONS.add(ts);
            success = true;
        }
        if (interaction instanceof IFaucetFluidSource) {
            bs = (IFaucetFluidSource)interaction;
            FLUID_INTERACTIONS.add((IFaucetFluidSource)bs);
            success = true;
        }
        if (interaction instanceof IFaucetBlockTarget) {
            IFaucetBlockTarget tb = (IFaucetBlockTarget)interaction;
            TARGET_BLOCK_INTERACTIONS.add(tb);
            success = true;
        }
        if (interaction instanceof IFaucetTileTarget) {
            IFaucetTileTarget tt = (IFaucetTileTarget)interaction;
            TARGET_TILE_INTERACTIONS.add(tt);
            success = true;
        }
        if (interaction instanceof IFaucetItemSource) {
            IFaucetItemSource is = (IFaucetItemSource)interaction;
            ITEM_INTERACTIONS.add(is);
            success = true;
        }
        if (!success) {
            throw new UnsupportedOperationException("Unsupported faucet interaction class: " + interaction.getClass().getSimpleName());
        }
    }

    public static <T> void removeDataInteractions(Collection<T> interactions) {
        for (T v : interactions) {
            if (v instanceof IFaucetBlockSource) {
                IFaucetBlockSource fs = (IFaucetBlockSource)v;
                BLOCK_INTERACTIONS.remove(fs);
                continue;
            }
            if (!(v instanceof IFaucetItemSource)) continue;
            IFaucetItemSource fs = (IFaucetItemSource)v;
            ITEM_INTERACTIONS.remove(fs);
        }
    }

    @FunctionalInterface
    public static interface FillAction {
        public boolean tryExecute();
    }
}

