/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HSLColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.client.SpriteCoordinateUnExpander;
import net.mehvahdjukaar.supplementaries.client.renderers.color.ColorHelper;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BookPileBlock;
import net.mehvahdjukaar.supplementaries.common.misc.AntiqueInkHelper;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.EnchantRedesignCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1751;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1843;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class BookPileBlockTile
extends ItemDisplayTile
implements IExtraModelDataProvider {
    public final boolean horizontal;
    private float enchantPower = 0.0f;
    public final BooksList books = new BooksList();
    public static final ModelDataKey<BooksList> BOOKS_KEY = ModBlockProperties.BOOKS_KEY;
    private static final class_5819 rand = class_5819.method_43047();
    public static final List<BookColor> DEFAULT_COLORS = List.of(BookColor.BROWN, BookColor.ORANGE, BookColor.YELLOW, BookColor.RED, BookColor.DARK_GREEN, BookColor.LIME, BookColor.TEAL, BookColor.BLUE, BookColor.PURPLE);

    public BookPileBlockTile(class_2338 pos, class_2680 state) {
        this(pos, state, false);
    }

    public BookPileBlockTile(class_2338 pos, class_2680 state, boolean horizontal) {
        super(ModRegistry.BOOK_PILE_TILE.get(), pos, state, 4);
        this.horizontal = horizontal;
    }

    public ExtraModelData getExtraModelData() {
        return ExtraModelData.builder().with(BOOKS_KEY, (Object)this.books).build();
    }

    private void makeRandomBook(int i) {
        for (int j = 0; j < i; ++j) {
            int r = rand.method_43048(10);
            class_1792 it = r < 3 ? class_1802.field_8598 : (r < 4 ? class_1802.field_8674 : class_1802.field_8529);
            ArrayList<BookColor> col = new ArrayList<BookColor>(List.of(BookColor.values()));
            this.books.add(new VisualBook(it.method_7854(), this.field_11867, j, col, null));
        }
    }

    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        compound.method_10548("EnchantPower", this.enchantPower);
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.enchantPower = compound.method_10583("EnchantPower");
        if (this.field_11863 != null && this.field_11863.field_9236) {
            this.requestModelReload();
        }
    }

    public void updateTileOnInventoryChanged() {
        int b = (int)this.method_11282().stream().filter(i -> !i.method_7960()).count();
        if (b != (Integer)this.method_11010().method_11654((class_2769)BookPileBlock.BOOKS)) {
            if (b == 0) {
                this.field_11863.method_8650(this.field_11867, false);
            } else {
                this.consolidateBookPile();
                this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)BookPileBlock.BOOKS, (Comparable)Integer.valueOf(b)), 2);
            }
        }
        this.enchantPower = 0.0f;
        for (int i2 = 0; i2 < 4; ++i2) {
            class_1792 item = this.method_5438(i2).method_7909();
            if (BookPileBlock.isNormalBook(item)) {
                this.enchantPower = (float)((double)this.enchantPower + CommonConfigs.Tweaks.BOOK_POWER.get() / 4.0);
                continue;
            }
            if (BookPileBlock.isQuarkTome(item)) {
                this.enchantPower = (float)((double)this.enchantPower + CommonConfigs.Tweaks.BOOK_POWER.get() / 4.0 * 2.0);
                continue;
            }
            if (!BookPileBlock.isEnchantedBook(item)) continue;
            this.enchantPower = (float)((double)this.enchantPower + CommonConfigs.Tweaks.ENCHANTED_BOOK_POWER.get() / 4.0);
        }
    }

    private void consolidateBookPile() {
        boolean prevEmpty = false;
        for (int i = 0; i < 4; ++i) {
            class_1799 it = this.method_5438(i);
            if (it.method_7960()) {
                prevEmpty = true;
                continue;
            }
            if (!prevEmpty) continue;
            this.method_11282().set(i - 1, (Object)it);
            this.method_11282().set(i, (Object)class_1799.field_8037);
        }
    }

    public void updateClientVisualsOnLoad() {
        class_1799 stack;
        this.books.clear();
        ArrayList<BookColor> colors = new ArrayList<BookColor>((Collection)ClientConfigs.Tweaks.BOOK_COLORS.get());
        for (int i = 0; i < 4 && !(stack = this.method_5438(i)).method_7960(); ++i) {
            BookColor last = i == 0 ? null : this.books.get((int)(i - 1)).color;
            this.books.add(i, new VisualBook(stack, this.field_11867, i, colors, last));
        }
        if (this.books.isEmpty()) {
            this.makeRandomBook((Integer)this.method_11010().method_11654((class_2769)BookPileBlock.BOOKS));
        }
    }

    public float getEnchantPower() {
        return this.enchantPower;
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"block.supplementaries.book_pile");
    }

    public static class BooksList {
        private final List<VisualBook> list = new ArrayList<VisualBook>();

        public void add(VisualBook visualBook) {
            this.list.add(visualBook);
        }

        public void add(int i, VisualBook visualBook) {
            this.list.add(i, visualBook);
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public void clear() {
            this.list.clear();
        }

        public VisualBook get(int i) {
            return this.list.get(i);
        }

        public int size() {
            return this.list.size();
        }
    }

    public static enum BookColor implements class_3542
    {
        BROWN(class_1767.field_7957, 1.0f),
        WHITE(class_1767.field_7952, 1.0f),
        BLACK(class_1767.field_7963, 1.0f),
        LIGHT_GRAY(class_1767.field_7967),
        GRAY(class_1767.field_7944),
        ORANGE(class_1767.field_7946),
        YELLOW(class_1767.field_7947),
        LIME(class_1767.field_7961),
        DARK_GREEN("green", 3129655),
        TEAL("cyan", 1502399),
        LIGHT_BLUE(class_1767.field_7951),
        BLUE(class_1767.field_7966),
        PURPLE(class_1767.field_7945),
        MAGENTA(class_1767.field_7958),
        PINK(class_1767.field_7954),
        RED(class_1767.field_7964),
        ENCHANTED("enchanted", 0, 1.0f),
        AND_QUILL("and_quill", 0, 1.0f),
        WRITTEN("written", 0, 1.0f),
        TOME("tome", 0, 1.0f),
        TATTERED("tattered", 0, 1.0f);

        private final String name;
        private final float hue;
        private final float angle;
        public static final Codec<BookColor> CODEC;

        private BookColor(String s, int rgb, float angle) {
            this.name = s;
            HSLColor col = new RGBColor(rgb).asHSL();
            this.hue = col.hue();
            this.angle = angle < 0.0f ? this.getAllowedHueShift(col) : Math.max(1.0f, angle);
        }

        private BookColor(class_1767 color, float angle) {
            this(color.method_7792(), ColorHelper.pack(color.method_7787()), angle);
        }

        private BookColor(String name, int color) {
            this(name, color, -1.0f);
        }

        private BookColor(class_1767 color) {
            this(color.method_7792(), ColorHelper.pack(color.method_7787()), -1.0f);
        }

        public static BookColor byName(String name) {
            for (BookColor c : BookColor.values()) {
                if (!c.name.equals(name)) continue;
                return c;
            }
            return BROWN;
        }

        public boolean looksGoodNextTo(BookColor other) {
            float diff = Math.abs(class_3532.method_15381((float)(this.hue * 360.0f), (float)(other.hue * 360.0f)) / 360.0f);
            return diff < (other.angle + this.angle) / 2.0f;
        }

        private float getAllowedHueShift(HSLColor color) {
            float l = color.lightness();
            float s = ColorHelper.normalizeSaturation(color.saturation(), l);
            float minAngle = 0.25f;
            float addAngle = 0.18055555f;
            float distLightSq = 2.0f;
            float distDarkSq = s * s + l * l;
            float distSq = Math.min(1.0f, Math.min(distDarkSq, distLightSq));
            return minAngle + (1.0f - distSq) * addAngle;
        }

        public static BookColor rand(Random r) {
            return BookColor.values()[r.nextInt(BookColor.values().length)];
        }

        public String getName() {
            return this.name;
        }

        public String method_15434() {
            return this.getName();
        }

        static {
            CODEC = class_3542.method_28140(BookColor::values);
        }
    }

    public static class VisualBook {
        private final float angle;
        @Nullable
        private final BookColor color;
        private final class_1799 stack;
        private final boolean isEnchanted;

        public VisualBook(class_1799 stack, class_2338 pos, int index, List<BookColor> colors, @Nullable BookColor lastColor) {
            this.stack = stack;
            Random rand = new Random(pos.method_10063());
            for (int j = 0; j < index; ++j) {
                rand.nextInt();
            }
            class_1792 item = stack.method_7909();
            this.angle = (float)((double)rand.nextInt(32) * Math.PI / 16.0);
            if (item instanceof class_1751) {
                if (lastColor == null) {
                    this.color = colors.get(rand.nextInt(colors.size()));
                } else {
                    List<BookColor> c = colors.stream().filter(b -> b.looksGoodNextTo(lastColor)).toList();
                    this.color = c.get(rand.nextInt(c.size()));
                }
                colors.remove((Object)this.color);
                this.isEnchanted = false;
            } else if (Utils.getID((class_1792)item).method_12836().equals("inspirations")) {
                String colName = Utils.getID((class_1792)item).method_12832().replace("_book", "");
                this.color = BookColor.byName(colName);
                this.isEnchanted = false;
            } else if (BookPileBlock.isWrittenBook(item)) {
                this.color = item instanceof class_1843 ? (AntiqueInkHelper.hasAntiqueInk(stack) ? BookColor.TATTERED : BookColor.WRITTEN) : BookColor.AND_QUILL;
                this.isEnchanted = false;
            } else {
                this.color = BookPileBlock.isQuarkTome(item) ? BookColor.TOME : BookColor.ENCHANTED;
                this.isEnchanted = true;
            }
        }

        public class_4588 getBuilder(class_4597 buffer) {
            if (this.isEnchanted && ClientConfigs.Tweaks.BOOK_GLINT.get().booleanValue()) {
                class_4588 foilBuilder = null;
                if (CompatHandler.ENCHANTEDBOOKREDESIGN) {
                    foilBuilder = EnchantRedesignCompat.getBookColoredFoil(this.stack, buffer);
                }
                if (foilBuilder == null) {
                    foilBuilder = new SpriteCoordinateUnExpander(buffer.getBuffer(class_1921.method_23591()), ModMaterials.BOOK_GLINT_MATERIAL.method_24148());
                }
                return foilBuilder;
            }
            return null;
        }

        public float getAngle() {
            return this.angle;
        }

        public boolean isEnchanted() {
            return this.isEnchanted;
        }

        public BookColor getColor() {
            return this.color;
        }
    }
}

