/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.util.level;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2203;
import net.minecraft.class_2479;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityNbtUtils {
    @Nullable
    public static String getNbtString(@NotNull class_1297 entity, @NotNull String path) {
        try {
            class_2487 entityData = new class_2487();
            entity.method_5647(entityData);
            class_2203.class_2209 nbtPath = class_2203.method_9360().method_9362(new StringReader(path));
            List results = nbtPath.method_9366((class_2520)entityData);
            if (results.isEmpty()) {
                return null;
            }
            class_2520 tag = (class_2520)results.get(0);
            if (tag instanceof class_2514) {
                class_2514 numericTag = (class_2514)tag;
                if (tag.method_10714().endsWith("d") || tag.method_10714().endsWith("f") || tag.method_10714().endsWith("b") || tag.method_10714().endsWith("s") || tag.method_10714().endsWith("L")) {
                    if (tag.method_10714().contains(".")) {
                        return String.valueOf(numericTag.method_10697());
                    }
                    return String.valueOf(numericTag.method_10699());
                }
            }
            return tag.method_10714();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            return null;
        }
    }

    @NotNull
    public static List<String> getAllNbtPaths(@NotNull class_1297 entity) {
        class_2487 entityData = new class_2487();
        entity.method_5647(entityData);
        ArrayList<String> paths = new ArrayList<String>();
        EntityNbtUtils.collectPaths("", (class_2520)entityData, paths);
        Collections.sort(paths);
        return paths;
    }

    private static void collectPaths(String prefix, class_2520 tag, List<String> paths) {
        block10: {
            block11: {
                block9: {
                    if (prefix != null && !prefix.isEmpty()) {
                        paths.add(prefix);
                    }
                    if (!(tag instanceof class_2487)) break block9;
                    class_2487 compound = (class_2487)tag;
                    for (String key : compound.method_10541()) {
                        String newPrefix = prefix.isEmpty() ? key : prefix + "." + key;
                        EntityNbtUtils.collectPaths(newPrefix, compound.method_10580(key), paths);
                    }
                    break block10;
                }
                if (!(tag instanceof class_2499)) break block11;
                class_2499 list = (class_2499)tag;
                for (int i = 0; i < list.size(); ++i) {
                    String newPrefix = prefix + "[" + i + "]";
                    EntityNbtUtils.collectPaths(newPrefix, list.method_10534(i), paths);
                }
                break block10;
            }
            if (!(tag instanceof class_2479) && !(tag instanceof class_2495) && !(tag instanceof class_2501)) break block10;
            int size = 0;
            if (tag instanceof class_2479) {
                size = ((class_2479)tag).method_10521().length;
            } else if (tag instanceof class_2495) {
                size = ((class_2495)tag).method_10588().length;
            } else if (tag instanceof class_2501) {
                size = ((class_2501)tag).method_10615().length;
            }
            for (int i = 0; i < size; ++i) {
                paths.add(prefix + "[" + i + "]");
            }
        }
    }
}

