/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.mounthealth;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.spiffyhud.SpiffyUtils;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import de.keksuccino.spiffyhud.util.rendering.SpiffyRenderUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaLikeMountHealthElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final class_2960 GUI_ICONS_LOCATION = new class_2960("textures/gui/icons.png");
    private final class_310 minecraft = class_310.method_1551();
    protected int tickCount;
    private int barWidth = 100;
    private int barHeight = 100;
    private boolean shouldRenderBar = false;
    public boolean isUsedAsDummy = false;
    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;

    public VanillaLikeMountHealthElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        this.tickCount = SpiffyUtils.getGuiAccessor().getTickCount_Spiffy();
        if (this.minecraft.field_1724 == null || this.minecraft.field_1687 == null) {
            return;
        }
        this.shouldRenderBar = false;
        this.renderVehicleHealth(graphics, 0, 0);
        int elementX = this.getAbsoluteX();
        int elementY = this.getAbsoluteY();
        Integer[] alignedBody = SpiffyAlignment.calculateElementBodyPosition(this.spiffyAlignment, elementX, elementY, this.getAbsoluteWidth(), this.getAbsoluteHeight(), this.barWidth, this.barHeight);
        int barRenderX = alignedBody[0];
        int barRenderY = alignedBody[1];
        RenderSystem.enableBlend();
        this.shouldRenderBar = true;
        this.renderVehicleHealth(graphics, barRenderX, barRenderY);
        RenderingUtils.resetShaderColor((class_332)graphics);
    }

    private void renderVehicleHealth(class_332 graphics, int baseX, int baseY) {
        class_1309 mount = this.getPlayerVehicleWithHealth();
        int totalHearts = mount != null ? this.getVehicleMaxHearts(mount) : 10;
        int currentHealth = (int)Math.ceil(mount != null ? (double)mount.method_6032() : 0.0);
        if (VanillaLikeMountHealthElement.isEditor()) {
            totalHearts = 20;
            currentHealth = 9;
        }
        if (this.isUsedAsDummy) {
            totalHearts = 10;
            currentHealth = 9;
        }
        if (totalHearts == 0) {
            return;
        }
        RenderSystem.enableBlend();
        graphics.method_51422(1.0f, 1.0f, 1.0f, this.opacity);
        int heartsPerRow = 10;
        int fixedRowWidth = 80;
        int totalRows = (int)Math.ceil((double)totalHearts / 10.0);
        int computedBarWidth = 80;
        int computedBarHeight = totalRows * 10;
        this.barWidth = computedBarWidth;
        this.barHeight = computedBarHeight;
        boolean isTopAlignment = this.spiffyAlignment == SpiffyAlignment.TOP_LEFT || this.spiffyAlignment == SpiffyAlignment.TOP_CENTERED || this.spiffyAlignment == SpiffyAlignment.TOP_RIGHT;
        boolean isRightAlignment = this.spiffyAlignment == SpiffyAlignment.TOP_RIGHT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_RIGHT || this.spiffyAlignment == SpiffyAlignment.MID_RIGHT;
        boolean mirrorHearts = this.spiffyAlignment == SpiffyAlignment.TOP_LEFT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_LEFT || this.spiffyAlignment == SpiffyAlignment.MID_LEFT || this.spiffyAlignment == SpiffyAlignment.TOP_CENTERED || this.spiffyAlignment == SpiffyAlignment.BOTTOM_CENTERED || this.spiffyAlignment == SpiffyAlignment.MID_CENTERED;
        for (int row = 0; row < totalRows; ++row) {
            int naturalRow = row;
            int rowY = isTopAlignment ? naturalRow * 10 : (totalRows - 1 - naturalRow) * 10;
            int heartsThisRow = naturalRow == totalRows - 1 ? totalHearts - (totalRows - 1) * 10 : 10;
            int rowStartX = 0;
            if (!isRightAlignment) {
                rowStartX = this.spiffyAlignment == SpiffyAlignment.TOP_CENTERED || this.spiffyAlignment == SpiffyAlignment.BOTTOM_CENTERED || this.spiffyAlignment == SpiffyAlignment.MID_CENTERED ? (80 - heartsThisRow * 8) / 2 : 0;
            }
            for (int col = 0; col < heartsThisRow; ++col) {
                int heartX;
                int effectiveCol;
                if (isRightAlignment) {
                    effectiveCol = heartsThisRow - 1 - col;
                    heartX = baseX + 80 - (effectiveCol + 1) * 8;
                } else {
                    effectiveCol = col;
                    heartX = baseX + rowStartX + effectiveCol * 8;
                }
                int overallHeartIndex = naturalRow * 10 + effectiveCol;
                int heartY = baseY + rowY;
                if (!this.shouldRenderBar) continue;
                if (mirrorHearts) {
                    SpiffyRenderUtils.blitMirrored(graphics, GUI_ICONS_LOCATION, heartX, heartY, 0, 52, 9, 9, 9, 256, 256);
                } else {
                    graphics.method_25302(GUI_ICONS_LOCATION, heartX, heartY, 52, 9, 9, 9);
                }
                int heartThreshold = overallHeartIndex * 2 + 1;
                if (heartThreshold < currentHealth) {
                    if (mirrorHearts) {
                        SpiffyRenderUtils.blitMirrored(graphics, GUI_ICONS_LOCATION, heartX, heartY, 0, 88, 9, 9, 9, 256, 256);
                        continue;
                    }
                    graphics.method_25302(GUI_ICONS_LOCATION, heartX, heartY, 88, 9, 9, 9);
                    continue;
                }
                if (heartThreshold != currentHealth) continue;
                if (mirrorHearts) {
                    SpiffyRenderUtils.blitMirrored(graphics, GUI_ICONS_LOCATION, heartX, heartY, 0, 97, 9, 9, 9, 256, 256);
                    continue;
                }
                graphics.method_25302(GUI_ICONS_LOCATION, heartX, heartY, 97, 9, 9, 9);
            }
        }
        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private int getVehicleMaxHearts(@Nullable class_1309 vehicle) {
        if (vehicle == null || !vehicle.method_5709()) {
            return 0;
        }
        float maxHealth = vehicle.method_6063();
        int hearts = (int)(maxHealth + 0.5f) / 2;
        if (hearts > 30) {
            hearts = 30;
        }
        return hearts;
    }

    @Nullable
    private class_1309 getPlayerVehicleWithHealth() {
        class_1297 vehicle;
        class_1657 player = this.getCameraPlayer();
        if (player != null && (vehicle = player.method_5854()) instanceof class_1309) {
            return (class_1309)vehicle;
        }
        return null;
    }

    @Nullable
    private class_1657 getCameraPlayer() {
        class_1657 p;
        class_1297 class_12972 = class_310.method_1551().method_1560();
        return class_12972 instanceof class_1657 ? (p = (class_1657)class_12972) : null;
    }

    public int getAbsoluteWidth() {
        return this.barWidth;
    }

    public int getAbsoluteHeight() {
        return this.barHeight;
    }
}

