/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud;

import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.layout.LayoutHandler;
import de.keksuccino.fancymenu.customization.overlay.CustomizationOverlay;
import de.keksuccino.fancymenu.customization.screen.identifier.UniversalScreenIdentifierRegistry;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.file.FileUtils;
import de.keksuccino.fancymenu.util.file.GameDirectoryUtils;
import de.keksuccino.spiffyhud.Options;
import de.keksuccino.spiffyhud.SpiffyEvents;
import de.keksuccino.spiffyhud.SpiffyUtils;
import de.keksuccino.spiffyhud.Test;
import de.keksuccino.spiffyhud.customization.SpiffyOverlayScreen;
import de.keksuccino.spiffyhud.customization.actions.Actions;
import de.keksuccino.spiffyhud.customization.elements.Elements;
import de.keksuccino.spiffyhud.customization.elements.playernbthelper.PlayerNbtPathHelpScreen;
import de.keksuccino.spiffyhud.customization.elements.slot.SlotIdHelpScreen;
import de.keksuccino.spiffyhud.customization.placeholders.Placeholders;
import de.keksuccino.spiffyhud.customization.requirements.Requirements;
import de.keksuccino.spiffyhud.networking.packets.Packets;
import de.keksuccino.spiffyhud.platform.Services;
import java.io.File;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SpiffyHud {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String VERSION = "3.0.0";
    public static final String MOD_LOADER = Services.PLATFORM.getPlatformName();
    public static final String MOD_ID = "spiffyhud";
    public static final File MOD_DIR = SpiffyHud.createDirectory(new File(GameDirectoryUtils.getGameDirectory(), "/config/spiffyhud"));
    private static Options options;

    public static void init() {
        if (Services.PLATFORM.isOnClient()) {
            LOGGER.info("[SPIFFY HUD] Loading v3.0.0 in client-side mode on " + MOD_LOADER.toUpperCase() + "!");
        } else {
            LOGGER.info("[SPIFFY HUD] Loading v3.0.0 in server-side mode on " + MOD_LOADER.toUpperCase() + "!");
        }
        if (Services.PLATFORM.isOnClient()) {
            EventHandler.INSTANCE.registerListenersOf((Object)new SpiffyEvents());
            UniversalScreenIdentifierRegistry.register((String)"spiffy_overlay", (String)SpiffyOverlayScreen.class.getName());
            ScreenCustomization.addScreenBlacklistRule(s -> s.equals(SlotIdHelpScreen.class.getName()));
            ScreenCustomization.addScreenBlacklistRule(s -> s.equals(PlayerNbtPathHelpScreen.class.getName()));
            Placeholders.registerAll();
            Requirements.registerAll();
            Elements.registerAll();
            Actions.registerAll();
            LayoutHandler.registerUniversalLayoutInclusionRule(screenIdentifier -> !SpiffyUtils.isSpiffyIdentifier(screenIdentifier));
            CustomizationOverlay.registerOverlayVisibilityController(screen -> {
                class_437 patt3277$temp = class_310.method_1551().field_1755;
                if (patt3277$temp instanceof SpiffyOverlayScreen) {
                    SpiffyOverlayScreen s = (SpiffyOverlayScreen)patt3277$temp;
                    return s.showFancyMenuOverlay;
                }
                return true;
            });
            EventHandler.INSTANCE.registerListenersOf((Object)new Test());
        }
        Packets.registerAll();
    }

    public static Options getOptions() {
        if (options == null) {
            SpiffyHud.reloadOptions();
        }
        return options;
    }

    public static void reloadOptions() {
        options = new Options();
    }

    private static File createDirectory(@NotNull File directory) {
        return FileUtils.createDirectory((File)directory);
    }
}

