/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.mehvahdjukaar.sleep_tight.common.blocks.ISleepTightBed;
import net.mehvahdjukaar.sleep_tight.common.entities.BedEntity;
import net.mehvahdjukaar.sleep_tight.common.tiles.HammockTile;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.mehvahdjukaar.sleep_tight.configs.EffectData;
import net.mehvahdjukaar.sleep_tight.core.BedData;
import net.mehvahdjukaar.sleep_tight.core.PlayerSleepData;
import net.mehvahdjukaar.sleep_tight.integration.HeartstoneCompat;
import net.minecraft.class_1293;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4081;
import org.jetbrains.annotations.Nullable;

public class SleepEffectsHelper {
    public static void applyEffectsOnWakeUp(PlayerSleepData playerCap, class_3222 player, long dayTimeDelta, class_2338 pos, ISleepTightBed bed, class_2680 state, @javax.annotation.Nullable BedData data) {
        if (data != null) {
            SleepEffectsHelper.applyVanillaBedBonuses(player, dayTimeDelta, data, playerCap);
            SleepEffectsHelper.applyHeartstoneBonuses(player, pos, state, data, playerCap);
        }
        if (player.field_13974.method_14267()) {
            if (bed.st_hasPenalties()) {
                SleepEffectsHelper.applySleepPenalties(player, dayTimeDelta);
            }
            if (bed.st_hasRequirements()) {
                SleepEffectsHelper.paySleepRequirements(player);
            }
        }
    }

    private static void applySleepPenalties(class_3222 player, long dayTimeDelta) {
        double hunger = CommonConfigs.CONSUMED_HUNGER.get();
        if (hunger == 0.0) {
            return;
        }
        CommonConfigs.HungerMode mode = CommonConfigs.CONSUME_HUNGER_MODE.get();
        if (mode == CommonConfigs.HungerMode.DIFFICULTY_BASED || mode == CommonConfigs.HungerMode.TIME_DIFFICULTY_BASED) {
            int diff = player.method_37908().method_8407().method_5461();
            if (diff == 0) {
                return;
            }
            hunger *= 1.0 + (double)(diff - 1) * 0.25;
        }
        if (mode == CommonConfigs.HungerMode.TIME_BASED || mode == CommonConfigs.HungerMode.TIME_DIFFICULTY_BASED) {
            hunger = hunger / 11000.0 * (double)dayTimeDelta;
        }
        int level = player.method_7344().method_7586();
        level = (int)class_3532.method_15350((double)((double)level - hunger), (double)0.0, (double)20.0);
        player.method_7344().method_7580(level);
    }

    private static void applyVanillaBedBonuses(class_3222 player, long dayTimeDelta, BedData data, PlayerSleepData playerSleepData) {
        CommonConfigs.EffectIntensity potionClearing;
        CommonConfigs.BedStatus status = CommonConfigs.BED_BENEFITS.get();
        if (status == CommonConfigs.BedStatus.NONE) {
            return;
        }
        if (status == CommonConfigs.BedStatus.HOME_BED && !data.isHomeBedFor((class_1657)player)) {
            return;
        }
        CommonConfigs.EffectIntensity healing = CommonConfigs.HEALING.get();
        if (healing != CommonConfigs.EffectIntensity.NONE) {
            float maxHealth;
            float heal = maxHealth = player.method_6063();
            if (healing == CommonConfigs.EffectIntensity.TIME_BASED) {
                heal = maxHealth / 12000.0f * (float)dayTimeDelta;
            }
            player.method_6025(heal);
        }
        if ((potionClearing = CommonConfigs.EFFECT_CLEARING.get()) != CommonConfigs.EffectIntensity.NONE) {
            CommonConfigs.PotionClearing type = CommonConfigs.EFFECT_CLEARING_TYPE.get();
            boolean timeBased = potionClearing == CommonConfigs.EffectIntensity.TIME_BASED;
            ArrayList<class_1293> toEditOrRemove = new ArrayList<class_1293>();
            block5: for (class_1293 e : player.method_6026()) {
                switch (type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case ALL: {
                        break;
                    }
                    case HARMFUL: {
                        if (e.method_5579().method_18792() != class_4081.field_18272) continue block5;
                        break;
                    }
                    case BENEFICIAL: {
                        if (e.method_5579().method_18792() == class_4081.field_18272) continue block5;
                    }
                }
                toEditOrRemove.add(e);
            }
            for (class_1293 e : toEditOrRemove) {
                long remainingTime;
                player.method_6016(e.method_5579());
                if (!timeBased || (remainingTime = (long)e.method_5584() - dayTimeDelta) <= 0L) continue;
                class_2487 tag = new class_2487();
                e.method_5582(tag);
                tag.method_10569("Duration", (int)remainingTime);
                class_1293 load = class_1293.method_5583((class_2487)tag);
                if (load == null) continue;
                player.method_6092(load);
            }
        }
        for (EffectData e : CommonConfigs.WAKE_UP_EFFECTS.get()) {
            player.method_6092(e.createInstance(playerSleepData.getHomeBedLevel()));
        }
    }

    private static void applyHeartstoneBonuses(class_3222 player, class_2338 pos, class_2680 state, @javax.annotation.Nullable BedData data, PlayerSleepData playerSleepData) {
        class_2338 otherPos = SleepEffectsHelper.getPartnerPos((class_1657)player, state, pos);
        if (otherPos != null) {
            for (EffectData e : CommonConfigs.HEARTSTONE_EFFECT.get()) {
                player.method_6092(e.createInstance(playerSleepData.getHomeBedLevel()));
            }
        }
    }

    private static void paySleepRequirements(class_3222 serverPlayer) {
        serverPlayer.method_7255(-CommonConfigs.XP_COST.get().intValue());
    }

    public static boolean checkExtraRequirements(class_1657 player, @javax.annotation.Nullable class_2338 bedPos) {
        if (bedPos != null && !player.method_31549().field_7477) {
            class_1937 level = player.method_37908();
            class_2586 tile = level.method_8321(bedPos);
            if (tile == null && !CommonConfigs.REQUIREMENT_NIGHT_BAG.get().booleanValue()) {
                return true;
            }
            if (tile instanceof HammockTile && !CommonConfigs.REQUIREMENT_HAMMOCK.get().booleanValue()) {
                return true;
            }
            if (!CommonConfigs.REQUIREMENT_BED.get().booleanValue()) {
                return true;
            }
            int xp = CommonConfigs.XP_COST.get();
            if (xp != 0 && player.field_7495 < xp) {
                if (level.field_9236) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.sleep_tight.xp"), true);
                }
                return false;
            }
            if (CommonConfigs.NEED_FULL_HUNGER.get().booleanValue() && player.method_7344().method_7587()) {
                if (level.field_9236) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.sleep_tight.hunger"), true);
                }
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static class_2338 getPartnerPos(class_1657 player, class_2680 state, class_2338 pos) {
        CommonConfigs.HeartstoneMode mode = CommonConfigs.HEARTSTONE_MODE.get();
        class_1937 level = player.method_37908();
        if (mode.isOn() && state.method_26204() instanceof class_2244) {
            class_2338 otherPos = BedEntity.getDoubleBedPos(pos, state);
            boolean x = SleepEffectsHelper.hasPartnerAt(player, mode, level, otherPos);
            if (!x) {
                otherPos = BedEntity.getInverseDoubleBedPos(pos, state);
                x = SleepEffectsHelper.hasPartnerAt(player, mode, level, otherPos);
            }
            if (x) {
                return otherPos;
            }
        }
        return null;
    }

    private static boolean hasPartnerAt(class_1657 player, CommonConfigs.HeartstoneMode mode, class_1937 level, class_2338 otherPos) {
        class_2680 leftState = level.method_8320(otherPos);
        if (leftState.method_26204() instanceof class_2244 && ((Boolean)leftState.method_11654((class_2769)class_2244.field_9968)).booleanValue()) {
            class_238 bb = new class_238(otherPos);
            Iterator iterator = level.method_8390(class_1657.class, bb, v -> v.method_18398().map(p -> p.equals((Object)otherPos)).orElse(false)).iterator();
            if (iterator.hasNext()) {
                class_1657 p = (class_1657)iterator.next();
                if (mode == CommonConfigs.HeartstoneMode.WITH_MOD) {
                    return HeartstoneCompat.isFren(player, p);
                }
                return true;
            }
            List vl = level.method_8390(class_1646.class, bb, v -> v.method_18398().map(p -> p.equals((Object)otherPos)).orElse(false));
            return !vl.isEmpty();
        }
        return false;
    }
}

