/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.core;

import java.util.UUID;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.sleep_tight.SleepTightPlatformStuff;
import net.mehvahdjukaar.sleep_tight.common.blocks.DreamEssenceBlock;
import net.mehvahdjukaar.sleep_tight.common.blocks.ISleepTightBed;
import net.mehvahdjukaar.sleep_tight.common.network.ClientBoundSyncPlayerSleepCapMessage;
import net.mehvahdjukaar.sleep_tight.common.network.NetworkHandler;
import net.mehvahdjukaar.sleep_tight.common.tiles.IExtraBedDataProvider;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.mehvahdjukaar.sleep_tight.core.BedData;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;

public abstract class PlayerSleepData {
    protected static final String HOME_BED_NBT = "home_bed_id";
    protected static final String INSOMNIA_ELAPSE_NBT = "insomnia_elapses_at";
    protected static final String LAST_TIME_SLEPT_NBT = "last_time_slept";
    protected static final String CONSECUTIVE_NIGHTS_NBT = "consecutive_nights";
    protected static final String HOME_BED_LEVEL_NBT = "home_bed_nights";
    protected static final String USING_DOUBLE_BED_NBT = "using_double_bed";
    @Nullable
    private UUID homeBed = null;
    private long insomniaWillElapseTimeStamp = 0L;
    private long lastWokenUpTimeStamp = -1L;
    private int consecutiveNightsSlept = 0;
    private int nightsSleptInHomeBed = 0;
    private boolean usingDoubleBed = false;

    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        if (this.homeBed != null) {
            tag.method_25927(HOME_BED_NBT, this.homeBed);
        }
        tag.method_10544(INSOMNIA_ELAPSE_NBT, this.insomniaWillElapseTimeStamp);
        tag.method_10544(LAST_TIME_SLEPT_NBT, this.lastWokenUpTimeStamp);
        tag.method_10569(CONSECUTIVE_NIGHTS_NBT, this.consecutiveNightsSlept);
        tag.method_10569(HOME_BED_LEVEL_NBT, this.nightsSleptInHomeBed);
        tag.method_10556(USING_DOUBLE_BED_NBT, this.usingDoubleBed);
        return tag;
    }

    public void deserializeNBT(class_2487 tag) {
        if (tag.method_10545(HOME_BED_NBT)) {
            this.homeBed = tag.method_25926(HOME_BED_NBT);
        }
        this.insomniaWillElapseTimeStamp = tag.method_10537(INSOMNIA_ELAPSE_NBT);
        this.lastWokenUpTimeStamp = tag.method_10537(LAST_TIME_SLEPT_NBT);
        this.consecutiveNightsSlept = tag.method_10550(CONSECUTIVE_NIGHTS_NBT);
        this.nightsSleptInHomeBed = tag.method_10550(HOME_BED_LEVEL_NBT);
        this.usingDoubleBed = tag.method_10577(USING_DOUBLE_BED_NBT);
    }

    public void addInsomnia(class_1657 player, long duration) {
        long gameTime = player.method_37908().method_8510();
        this.insomniaWillElapseTimeStamp = gameTime + duration;
        this.consecutiveNightsSlept = 0;
        this.lastWokenUpTimeStamp = gameTime;
    }

    public void onNightSleptIntoBed(BedData bed, class_1657 player) {
        long gameTime = player.method_37908().method_8510();
        long awakeTime = gameTime - this.lastWokenUpTimeStamp;
        this.consecutiveNightsSlept = awakeTime > (long)CommonConfigs.SLEEP_INTERVAL.get().intValue() ? 0 : ++this.consecutiveNightsSlept;
        this.lastWokenUpTimeStamp = gameTime;
        UUID bedId = bed.getId();
        if (bedId.equals(this.homeBed)) {
            int required = CommonConfigs.HOME_BED_REQUIRED_NIGHTS.get();
            this.nightsSleptInHomeBed = Math.min(required + CommonConfigs.HOME_BED_MAX_LEVEL.get(), this.nightsSleptInHomeBed + 1);
            if (this.nightsSleptInHomeBed >= required) {
                bed.setHomeBedFor(player);
            }
        } else {
            this.homeBed = bedId;
            this.nightsSleptInHomeBed = 0;
        }
    }

    public float getInsomniaCooldown(class_1657 player) {
        if (player.method_31549().field_7477) {
            return 0.0f;
        }
        long currentTime = player.method_37908().method_8510();
        long timeLeft = this.insomniaWillElapseTimeStamp - currentTime;
        if (timeLeft < 0L) {
            return 0.0f;
        }
        long amountAwake = currentTime - this.lastWokenUpTimeStamp;
        return 1.0f - (float)amountAwake / (float)timeLeft;
    }

    public boolean isOnSleepCooldown(class_1657 player) {
        return this.getInsomniaCooldown(player) > 0.0f;
    }

    public long getInsomniaTimeLeft(class_1657 player) {
        return this.insomniaWillElapseTimeStamp - player.method_37908().method_8510();
    }

    public double getNightmareChance(class_1657 player, class_2338 pos) {
        ISleepTightBed bed;
        int minNights = CommonConfigs.NIGHTMARES_CONSECUTIVE_NIGHTS.get();
        if (this.consecutiveNightsSlept < minNights) {
            return 0.0;
        }
        if (DreamEssenceBlock.isInRange(player.method_24515(), player.method_37908())) {
            return 0.0;
        }
        class_2680 state = player.method_37908().method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof ISleepTightBed && !(bed = (ISleepTightBed)class_22482).st_canCauseNightmares()) {
            return 0.0;
        }
        return CommonConfigs.NIGHTMARE_CHANCE_INCREMENT_PER_NIGHT.get() * (double)(this.consecutiveNightsSlept - minNights - 1);
    }

    @Nullable
    public UUID getHomeBed() {
        return this.homeBed;
    }

    public long getInsomniaWillElapseTimeStamp() {
        return this.insomniaWillElapseTimeStamp;
    }

    public int getConsecutiveNightsSlept() {
        return this.consecutiveNightsSlept;
    }

    public int getNightsSleptInHomeBed() {
        return this.nightsSleptInHomeBed;
    }

    public long getLastWokenUpTimeStamp() {
        return this.lastWokenUpTimeStamp;
    }

    public void acceptFromServer(UUID id, long insominaElapse, long sleepTimestamp, int nightSlept, int homeBedNights, boolean doubleBed) {
        this.homeBed = id;
        this.insomniaWillElapseTimeStamp = insominaElapse;
        this.consecutiveNightsSlept = nightSlept;
        this.lastWokenUpTimeStamp = sleepTimestamp;
        this.nightsSleptInHomeBed = homeBedNights;
        this.usingDoubleBed = doubleBed;
    }

    public void syncToClient(class_3222 player) {
        NetworkHandler.CHANNEL.sendToClientPlayer(player, (Message)new ClientBoundSyncPlayerSleepCapMessage(this));
    }

    public void setConsecutiveNightsSlept(int consecutiveNightsSlept) {
        this.consecutiveNightsSlept = consecutiveNightsSlept;
    }

    public void setNightsSleptInHomeBed(int nightsSleptInHomeBed) {
        this.nightsSleptInHomeBed = nightsSleptInHomeBed;
    }

    public void copyFrom(PlayerSleepData oldData) {
        this.consecutiveNightsSlept = oldData.consecutiveNightsSlept;
        this.homeBed = oldData.homeBed;
        this.nightsSleptInHomeBed = oldData.nightsSleptInHomeBed;
        this.insomniaWillElapseTimeStamp = oldData.insomniaWillElapseTimeStamp;
        this.lastWokenUpTimeStamp = oldData.lastWokenUpTimeStamp;
        this.usingDoubleBed = oldData.usingDoubleBed;
    }

    public int getHomeBedLevel() {
        return Math.max(0, this.nightsSleptInHomeBed - CommonConfigs.HOME_BED_REQUIRED_NIGHTS.get());
    }

    public boolean usingDoubleBed() {
        return this.usingDoubleBed;
    }

    public void setDoubleBed(boolean doubleBed) {
        this.usingDoubleBed = doubleBed;
    }

    @Nullable
    public static BedData getHomeBedIfHere(class_1657 player, class_2338 pos) {
        IExtraBedDataProvider bed;
        BedData bedCap;
        class_2586 class_25862;
        PlayerSleepData c = SleepTightPlatformStuff.getPlayerSleepData(player);
        if (c != null && (class_25862 = player.method_37908().method_8321(pos)) instanceof IExtraBedDataProvider && (bedCap = (bed = (IExtraBedDataProvider)class_25862).st_getBedData()).getId().equals(c.getHomeBed()) && bedCap.isHomeBedFor(player)) {
            return bedCap;
        }
        return null;
    }
}

