/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.core;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.SleepTightPlatformStuff;
import net.mehvahdjukaar.sleep_tight.client.ClientEvents;
import net.mehvahdjukaar.sleep_tight.common.InvigoratedEffect;
import net.mehvahdjukaar.sleep_tight.common.blocks.IModBed;
import net.mehvahdjukaar.sleep_tight.common.blocks.ISleepTightBed;
import net.mehvahdjukaar.sleep_tight.common.blocks.InfestedBedBlock;
import net.mehvahdjukaar.sleep_tight.common.blocks.NightBagBlock;
import net.mehvahdjukaar.sleep_tight.common.entities.BedEntity;
import net.mehvahdjukaar.sleep_tight.common.items.BedbugEggsItem;
import net.mehvahdjukaar.sleep_tight.common.network.ClientBoundNightmarePacket;
import net.mehvahdjukaar.sleep_tight.common.network.ClientBoundSyncPlayerSleepCapMessage;
import net.mehvahdjukaar.sleep_tight.common.network.NetworkHandler;
import net.mehvahdjukaar.sleep_tight.common.tiles.IExtraBedDataProvider;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.mehvahdjukaar.sleep_tight.core.BedData;
import net.mehvahdjukaar.sleep_tight.core.PlayerSleepData;
import net.mehvahdjukaar.sleep_tight.core.SleepEffectsHelper;
import net.mehvahdjukaar.sleep_tight.core.WakeReason;
import net.mehvahdjukaar.sleep_tight.core.WakeUpEncounterHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2742;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class ModEvents {
    public static long getWakeUpTimeWhenSlept(class_3218 level, long newTimeDayTime) {
        WakeReason wakeReason = WakeReason.SLEPT_SUCCESSFULLY;
        List<class_3222> sleepingPlayers = level.method_18456().stream().filter(class_1657::method_7276).toList();
        ISleepTightBed firstValid = (ISleepTightBed)class_2246.field_10069;
        for (class_1657 class_16572 : sleepingPlayers) {
            ISleepTightBed st;
            class_2248 class_22482 = level.method_8320((class_2338)class_16572.method_18398().get()).method_26204();
            if (!(class_22482 instanceof ISleepTightBed)) continue;
            firstValid = st = (ISleepTightBed)class_22482;
            break;
        }
        HashSet<class_3222> encounterSpawnedFor = new HashSet<class_3222>();
        for (class_3222 player : sleepingPlayers) {
            if (!player.field_13974.method_14267() || !WakeUpEncounterHelper.tryPerformEncounter(player, level, (class_2338)player.method_18398().get())) continue;
            wakeReason = WakeReason.ENCOUNTER;
            encounterSpawnedFor.add(player);
        }
        if (wakeReason == WakeReason.SLEPT_SUCCESSFULLY) {
            double nightmareChance;
            double d = 0.0;
            int players = 0;
            for (class_3222 player : sleepingPlayers) {
                ++players;
                PlayerSleepData c = SleepTightPlatformStuff.getPlayerSleepData((class_1657)player);
                d += c.getNightmareChance((class_1657)player, (class_2338)player.method_18398().get());
            }
            double d2 = nightmareChance = players == 0 ? 0.0 : d / (double)players;
            if ((double)level.field_9229.method_43057() < nightmareChance) {
                wakeReason = WakeReason.NIGHTMARE;
            }
        }
        long l = level.method_8532();
        long newWakeTime = firstValid.st_modifyWakeUpTime(wakeReason, newTimeDayTime, l);
        long dayTimeDelta = (newWakeTime + 24000L - l) % 24000L;
        for (class_3222 player : sleepingPlayers) {
            switch (wakeReason) {
                case SLEPT_SUCCESSFULLY: {
                    ModEvents.onPlayerSleepFinished(player, dayTimeDelta);
                    break;
                }
                case ENCOUNTER: {
                    ModEvents.onEncounter(player, encounterSpawnedFor.contains(player));
                    break;
                }
                case NIGHTMARE: {
                    ModEvents.onNightmare(player);
                }
            }
        }
        return newWakeTime;
    }

    public static boolean canSetSpawn(class_1657 player, @Nullable class_2338 pos) {
        if (pos != null) {
            class_1937 level = player.method_37908();
            class_2248 block = level.method_8320(pos).method_26204();
            if (block instanceof class_2244 && !class_2244.method_27352((class_1937)level) && !CommonConfigs.EXPLOSION_BEHAVIOR.get().canRespawn()) {
                return false;
            }
            if (block instanceof NightBagBlock) {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidBed(class_2680 state) {
        class_2248 block = state.method_26204();
        return block instanceof class_2244 && block != SleepTight.INFESTED_BED;
    }

    public static class_1269 onRightClickBlock(class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        if (!player.method_7325()) {
            class_2338 pos = hitResult.method_17777();
            class_2680 state = level.method_8320(pos);
            class_2248 b = state.method_26204();
            if (b instanceof InfestedBedBlock) {
                return state.method_26174(level, player, hand, hitResult);
            }
            if (ModEvents.isValidBed(state)) {
                class_2350 dir = (class_2350)state.method_11654((class_2769)class_2244.field_11177);
                if (state.method_11654((class_2769)class_2244.field_9967) != class_2742.field_12560 && !(state = level.method_8320(pos = pos.method_10093(dir))).method_27852(b)) {
                    return class_1269.field_5811;
                }
                class_1799 itemInHand = player.method_5998(hand);
                class_1792 class_17922 = itemInHand.method_7909();
                if (class_17922 instanceof BedbugEggsItem) {
                    BedbugEggsItem bb = (BedbugEggsItem)class_17922;
                    return bb.useOnBed(player, hand, itemInHand, state, pos, hitResult);
                }
                if (class_2244.method_27352((class_1937)level) && !player.method_21823() && !ModEvents.bedBlocked(level, pos, dir) && !player.method_18276()) {
                    boolean occupied = (Boolean)state.method_11654((class_2769)class_2244.field_9968);
                    if (occupied) {
                        List list = level.method_18467(BedEntity.class, new class_238(pos));
                        if (list.size() > 0) {
                            BedEntity bedEntity = (BedEntity)((Object)list.get(0));
                            if (!bedEntity.isDoubleBed()) {
                                return class_1269.field_5811;
                            }
                            bedEntity.clearDoubleBed();
                            pos = bedEntity.getDoubleBedPos();
                            state = (class_2680)state.method_11657((class_2769)class_2244.field_9968, (Comparable)Boolean.valueOf(false));
                            level.method_8501(pos, state);
                            occupied = false;
                        } else {
                            class_2338 doublePos = BedEntity.getInverseDoubleBedPos(pos, state);
                            list = level.method_18467(BedEntity.class, new class_238(doublePos));
                            if (list.size() > 0) {
                                BedEntity bedEntity = (BedEntity)((Object)list.get(0));
                                if (!bedEntity.isDoubleBed()) {
                                    return class_1269.field_5811;
                                }
                                bedEntity.clearDoubleBed();
                                state = (class_2680)state.method_11657((class_2769)class_2244.field_9968, (Comparable)Boolean.valueOf(false));
                                level.method_8501(pos, state);
                                occupied = false;
                            }
                        }
                    }
                    if (!occupied) {
                        boolean extraConditions;
                        boolean bl = extraConditions = CommonConfigs.LAY_WHEN_ON_COOLDOWN.get() != false || ModEvents.checkExtraSleepConditions(player, pos);
                        if (!extraConditions) {
                            return class_1269.method_29236((boolean)level.field_9236);
                        }
                        BedEntity.layDown(state, level, pos, player);
                        return class_1269.field_5812;
                    }
                }
            }
        }
        return class_1269.field_5811;
    }

    private static boolean bedBlocked(class_1937 level, class_2338 pos, class_2350 direction) {
        class_2338 blockPos = pos.method_10084();
        return !ModEvents.freeAt(level, blockPos) || !ModEvents.freeAt(level, blockPos.method_10093(direction.method_10153()));
    }

    protected static boolean freeAt(class_1937 level, class_2338 pos) {
        return !level.method_8320(pos).method_26228((class_1922)level, pos);
    }

    public static class_243 getSleepingPosition(class_1297 entity, class_2680 state, class_2338 pos) {
        class_2248 class_22482;
        if (entity.method_37908().field_9236) {
            ClientEvents.onSleepStarted(entity, state, pos);
        }
        if ((class_22482 = state.method_26204()) instanceof IModBed) {
            IModBed iModBed = (IModBed)class_22482;
            return iModBed.getSleepingPosition(state, pos);
        }
        if (state.method_26164(class_3481.field_16443)) {
            class_1657 player;
            PlayerSleepData data;
            class_243 c = class_243.field_1353;
            if (CommonConfigs.FIX_BED_POSITION.get().booleanValue()) {
                c = c.method_1031((double)pos.method_10263() + 0.5, (double)((float)pos.method_10264() + 0.5625f), (double)pos.method_10260() + 0.5);
            }
            if (entity instanceof class_1657 && (data = SleepTightPlatformStuff.getPlayerSleepData(player = (class_1657)entity)).usingDoubleBed()) {
                c = BedEntity.getDoubleBedOffset((class_2350)state.method_11654((class_2769)class_2244.field_11177), c);
            }
            if (c != class_243.field_1353) {
                return c;
            }
        }
        return null;
    }

    private static void onEncounter(class_3222 player, boolean mobSpawned) {
        if (mobSpawned) {
            PlayerSleepData c = SleepTightPlatformStuff.getPlayerSleepData((class_1657)player);
            c.addInsomnia((class_1657)player, CommonConfigs.ENCOUNTER_INSOMNIA_DURATION.get().intValue());
            c.syncToClient(player);
        } else {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.sleep_tight.encounter"), true);
        }
    }

    private static void onNightmare(class_3222 player) {
        PlayerSleepData c = SleepTightPlatformStuff.getPlayerSleepData((class_1657)player);
        c.addInsomnia((class_1657)player, CommonConfigs.NIGHTMARE_INSOMNIA_DURATION.get().intValue());
        c.syncToClient(player);
        player.method_7353((class_2561)class_2561.method_43471((String)"message.sleep_tight.nightmare"), true);
        player.method_6092(new class_1293(class_1294.field_38092, 60, 0, false, false, false, null, Optional.of(new class_1293.class_7247(20, 10.0f, 1.0f, 1.0f, 60, 1.0f, true))));
        NetworkHandler.CHANNEL.sendToClientPlayer(player, (Message)new ClientBoundNightmarePacket());
    }

    public static void onPlayerSleepFinished(class_3222 player, long dayTimeDelta) {
        Optional p = player.method_18398();
        if (p.isPresent()) {
            class_2338 pos = (class_2338)p.get();
            PlayerSleepData playerCap = SleepTightPlatformStuff.getPlayerSleepData((class_1657)player);
            class_1937 level = player.method_37908();
            class_2680 state = level.method_8320(pos);
            ISleepTightBed bed = (ISleepTightBed)class_2246.field_10069;
            class_2248 class_22482 = state.method_26204();
            if (class_22482 instanceof ISleepTightBed) {
                ISleepTightBed b;
                bed = b = (ISleepTightBed)class_22482;
            }
            BedData data = null;
            class_2586 class_25862 = level.method_8321(pos);
            if (class_25862 instanceof IExtraBedDataProvider) {
                IExtraBedDataProvider tile = (IExtraBedDataProvider)class_25862;
                data = tile.st_getBedData();
                playerCap.onNightSleptIntoBed(data, (class_1657)player);
            }
            if (bed.st_canSpawnBedbugs()) {
                WakeUpEncounterHelper.trySpawningBedbug(pos, player, data);
            }
            SleepEffectsHelper.applyEffectsOnWakeUp(playerCap, player, dayTimeDelta, pos, bed, state, data);
            playerCap.addInsomnia((class_1657)player, bed.st_getCooldown());
            playerCap.syncToClient(player);
        }
    }

    public static void onWokenUp(class_1657 player, boolean hasWokenUpImmediately) {
        Optional p = player.method_18398();
        if (p.isPresent()) {
            class_2338 pos = (class_2338)p.get();
            class_1937 level = player.method_37908();
            class_2680 state = level.method_8320(pos);
            class_2248 class_22482 = state.method_26204();
            if (class_22482 instanceof IModBed) {
                IModBed bed = (IModBed)class_22482;
                bed.onLeftBed(state, pos, player);
            } else if (state.method_26164(class_3481.field_16443) && player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                PlayerSleepData data = SleepTightPlatformStuff.getPlayerSleepData(player);
                if (data.usingDoubleBed()) {
                    class_2338 doublePos = BedEntity.getDoubleBedPos(pos, state);
                    class_2680 doubleState = level.method_8320(doublePos);
                    if (doubleState.method_26164(class_3481.field_16443) && (doubleState = (class_2680)doubleState.method_11657((class_2769)class_2244.field_9968, (Comparable)Boolean.valueOf(false))) == state) {
                        level.method_8501(doublePos, doubleState);
                    }
                    data.setDoubleBed(false);
                    data.syncToClient(serverPlayer);
                }
            }
        }
    }

    public static boolean shouldCancelSetSpawn(class_1657 entity, class_2338 newSpawn) {
        class_2248 class_22482 = entity.method_37908().method_8320(newSpawn).method_26204();
        if (class_22482 instanceof IModBed) {
            IModBed bed = (IModBed)class_22482;
            return !bed.canSetSpawn();
        }
        return false;
    }

    public static void onPlayerLoggedIn(class_3222 player) {
        NetworkHandler.CHANNEL.sendToClientPlayer(player, (Message)new ClientBoundSyncPlayerSleepCapMessage((class_1657)player));
    }

    public static boolean checkExtraSleepConditions(class_1657 player, @Nullable class_2338 bedPos) {
        if (SleepTightPlatformStuff.getPlayerSleepData(player).isOnSleepCooldown(player)) {
            if (!player.method_37908().field_9236) {
                String s = ModEvents.isDayTime(player.method_37908()) ? "message.sleep_tight.insomnia.day" : "message.sleep_tight.insomnia.night";
                player.method_7353((class_2561)class_2561.method_43471((String)s), true);
            }
            return false;
        }
        return SleepEffectsHelper.checkExtraRequirements(player, bedPos);
    }

    public static class_1269 onCheckSleepTime(class_1937 level, class_2338 pos) {
        class_2248 class_22482 = level.method_8320(pos).method_26204();
        if (class_22482 instanceof IModBed) {
            IModBed bed = (IModBed)class_22482;
            return bed.canSleepAtTime(level);
        }
        return class_1269.field_5811;
    }

    public static void onEntityKilled(class_1309 entity, class_1297 killer) {
        class_1937 class_19372;
        if (!entity.method_31481() && (class_19372 = entity.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (killer instanceof class_1309) {
                class_1309 le = (class_1309)killer;
                if (killer.method_5874(serverLevel, entity)) {
                    InvigoratedEffect.onLivingDeath(serverLevel, entity, le);
                }
            }
        }
    }

    public static boolean isDayTime(class_1937 level) {
        long dayTime = level.method_8532() % 24000L;
        return dayTime > 500L && dayTime < 11500L;
    }
}

