/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.blocks;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.block.IRotatable;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.common.HammockPart;
import net.mehvahdjukaar.sleep_tight.common.blocks.IModBed;
import net.mehvahdjukaar.sleep_tight.common.entities.BedEntity;
import net.mehvahdjukaar.sleep_tight.common.tiles.HammockTile;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.mehvahdjukaar.sleep_tight.core.ModEvents;
import net.mehvahdjukaar.sleep_tight.core.WakeReason;
import net.mehvahdjukaar.sleep_tight.integration.QuarkCompat;
import net.mehvahdjukaar.sleep_tight.integration.SupplementariesCompat;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5431;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class HammockBlock
extends class_2383
implements class_2343,
IRotatable,
IModBed {
    public static final class_2754<HammockPart> PART = class_2754.method_11850((String)"part", HammockPart.class);
    public static final class_2746 OCCUPIED = class_2741.field_12528;
    public static final class_265 SHAPE_FULL = class_2248.method_9541((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    public static final class_265 SHAPE_NORTH = class_2248.method_9541((double)0.0, (double)3.0, (double)8.0, (double)16.0, (double)6.0, (double)16.0);
    public static final class_265 SHAPE_SOUTH = class_2248.method_9541((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)6.0, (double)8.0);
    public static final class_265 SHAPE_WEST = class_2248.method_9541((double)8.0, (double)3.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    public static final class_265 SHAPE_EAST = class_2248.method_9541((double)0.0, (double)3.0, (double)0.0, (double)8.0, (double)6.0, (double)16.0);
    private final class_1767 color;

    public HammockBlock(class_1767 color) {
        super(class_4970.class_2251.method_9637().method_31710(color.method_7794()).method_50012(class_3619.field_15971).method_9626(class_2498.field_11543).method_9632(0.2f).method_22488());
        this.color = color;
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(PART, (Comparable)((Object)HammockPart.MIDDLE))).method_11657((class_2769)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    public class_1767 getColor() {
        return this.color;
    }

    public void method_9554(class_1937 level, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        super.method_9554(level, state, pos, entity, fallDistance * 0.8f);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 currentPos, class_2338 neighborPos) {
        HammockPart part = (HammockPart)((Object)state.method_11654(PART));
        class_2350 myDir = (class_2350)state.method_11654((class_2769)field_11177);
        if (direction.method_10166() == myDir.method_10166()) {
            Connection c;
            class_2350 attDir;
            for (Pair<class_2350, HammockPart> v : part.getPiecesDirections(myDir)) {
                if (v.getFirst() != direction) continue;
                class_2248 class_22482 = neighborState.method_26204();
                if (class_22482 instanceof HammockBlock) {
                    HammockBlock nh = (HammockBlock)class_22482;
                    if (neighborState.method_11654(PART) != v.getSecond() || neighborState.method_11654((class_2769)field_11177) != myDir) break;
                    class_2680 newState = neighborState.method_27852((class_2248)this) ? state : BlocksColorAPI.changeColor((class_2248)state.method_26204(), (class_1767)nh.color).method_34725(state);
                    return (class_2680)newState.method_11657((class_2769)OCCUPIED, (Comparable)((Boolean)neighborState.method_11654((class_2769)OCCUPIED)));
                }
                return class_2246.field_10124.method_9564();
            }
            if ((attDir = part.getConnectionDirection(myDir)) == direction && ((c = HammockBlock.getConnectionType(attDir, currentPos, level)) == Connection.NONE || c == Connection.FENCE != part.isOnFence())) {
                return class_2246.field_10124.method_9564();
            }
        }
        return super.method_9559(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public void method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        class_2338 blockPos;
        class_2680 blockState;
        int i;
        HammockPart part;
        if (!level.field_9236 && player.method_7337() && !(part = (HammockPart)((Object)state.method_11654(PART))).isMaster() && (i = part.getMasterOffset()) != 0 && (blockState = level.method_8320(blockPos = pos.method_10079((class_2350)state.method_11654((class_2769)field_11177), i))).method_27852((class_2248)this) && ((HammockPart)((Object)blockState.method_11654(PART))).isMaster()) {
            level.method_8652(blockPos, class_2246.field_10124.method_9564(), 35);
            level.method_8444(player, 2001, blockPos, class_2248.method_9507((class_2680)blockState));
        }
        super.method_9576(level, pos, state, player);
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2338 pos = context.method_8037();
        class_1937 level = context.method_8045();
        for (class_2350 dir : context.method_7718()) {
            if (!dir.method_10166().method_10179()) continue;
            for (int i = 0; i < 2; ++i) {
                class_2350 opposite;
                class_2338 nextPos;
                Connection type;
                class_2338 p = pos.method_10079(dir, i);
                if (!level.method_8320(p).method_26166(context) || !level.method_8621().method_11952(p) || ((type = HammockBlock.getConnectionType(dir, p, (class_1936)level)) != Connection.FENCE || i == 1) && type != Connection.BLOCK || !level.method_8320(nextPos = p.method_10093(opposite = dir.method_10153())).method_26166(context) || !level.method_8621().method_11952(nextPos) || type == Connection.BLOCK && (!level.method_8320(nextPos = nextPos.method_10093(opposite)).method_26166(context) || !level.method_8621().method_11952(nextPos)) || HammockBlock.getConnectionType(opposite, nextPos, (class_1936)level) != type) continue;
                HammockPart t = i == 1 ? HammockPart.MIDDLE : type.getHead();
                return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)dir)).method_11657(PART, (Comparable)((Object)t));
            }
        }
        return null;
    }

    private static Connection getConnectionType(class_2350 dir, class_2338 pos, class_1936 level) {
        class_2350 opposite;
        class_2338 relative = pos.method_10093(dir);
        class_2680 facingState = level.method_8320(relative);
        if (facingState.method_30368((class_1922)level, relative, opposite = dir.method_10153(), class_5431.field_25823)) {
            return Connection.BLOCK;
        }
        if (facingState.method_26204() instanceof class_2354 || SleepTight.QUARK && QuarkCompat.isVerticalPost(facingState) || SleepTight.SUPP && SupplementariesCompat.isRopeKnot(facingState)) {
            return Connection.FENCE;
        }
        return Connection.NONE;
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        super.method_9567(level, pos, state, placer, stack);
        if (!level.field_9236) {
            HammockPart part = (HammockPart)((Object)state.method_11654(PART));
            for (Pair<class_2350, HammockPart> v : part.getPiecesDirections((class_2350)state.method_11654((class_2769)field_11177))) {
                class_2338 blockPos = pos.method_10093((class_2350)v.getFirst());
                level.method_8652(blockPos, (class_2680)state.method_11657(PART, (Comparable)((Object)((HammockPart)((Object)v.getSecond())))), 3);
                if (part != HammockPart.HALF_HEAD) continue;
                blockPos = blockPos.method_10093((class_2350)v.getFirst());
                level.method_8652(blockPos, (class_2680)state.method_11657(PART, (Comparable)((Object)HammockPart.HALF_FOOT)), 3);
            }
        }
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        HammockPart part = (HammockPart)((Object)state.method_11654(PART));
        if (part.isOnFence() || part == HammockPart.MIDDLE) {
            return SHAPE_FULL;
        }
        return switch (part.getConnectionDirection((class_2350)state.method_11654((class_2769)field_11177))) {
            case class_2350.field_11039 -> SHAPE_WEST;
            case class_2350.field_11034 -> SHAPE_EAST;
            case class_2350.field_11035 -> SHAPE_SOUTH;
            default -> SHAPE_NORTH;
        };
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{field_11177, PART, OCCUPIED});
    }

    public long method_9535(class_2680 state, class_2338 pos) {
        class_2338 blockPos = HammockBlock.getMasterPos(state, pos);
        return class_3532.method_15371((int)blockPos.method_10263(), (int)pos.method_10264(), (int)blockPos.method_10260());
    }

    private static class_2338 getMasterPos(class_2680 state, class_2338 pos) {
        return pos.method_10079((class_2350)state.method_11654((class_2769)field_11177), ((HammockPart)((Object)state.method_11654(PART))).getMasterOffset());
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return ((HammockPart)((Object)state.method_11654(PART))).isMaster() ? new HammockTile(pos, state) : null;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return level.field_9236 ? Utils.getTicker(type, SleepTight.HAMMOCK_TILE.get(), HammockTile::tick) : null;
    }

    public boolean method_9592(class_2680 state, class_1937 level, class_2338 pos, int id, int param) {
        return super.method_9592(state, level, pos, id, param);
    }

    public boolean method_9516(class_2680 state, class_1922 level, class_2338 pos, class_10 type) {
        return false;
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!(state = level.method_8320(pos = HammockBlock.getMasterPos(state, pos))).method_27852((class_2248)this) || player.method_5854() != null) {
            return class_1269.field_5814;
        }
        if (IModBed.tryExploding(level, pos)) {
            return class_1269.method_29236((boolean)level.field_9236);
        }
        if (((Boolean)state.method_11654((class_2769)OCCUPIED)).booleanValue()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"block.minecraft.bed.occupied"), true);
            return class_1269.field_5812;
        }
        if (!player.method_21823()) {
            BedEntity.layDown(state, level, pos, player);
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    @Override
    public class_243 getSleepingPosition(class_2680 state, class_2338 pos) {
        class_243 v = class_243.method_24953((class_2382)pos).method_1023(0.0, 0.125, 0.0);
        float off = 0.09375f;
        if (!((HammockPart)((Object)state.method_11654(PART))).isOnFence()) {
            off = (float)((double)off + 0.5);
        }
        v = v.method_43206((class_2350)state.method_11654((class_2769)field_11177), (double)off);
        return v;
    }

    @Override
    public boolean canSetSpawn() {
        return false;
    }

    @Override
    public class_1269 canSleepAtTime(class_1937 level) {
        return ModEvents.isDayTime(level) ? class_1269.field_5812 : class_1269.field_5814;
    }

    @Override
    public class_2561 getSleepingProblemMessage() {
        return class_2561.method_43471((String)"message.sleep_tight.cant_rest");
    }

    @Override
    public boolean st_canCauseNightmares() {
        return CommonConfigs.NIGHTMARES_HAMMOCK.get();
    }

    @Override
    public long st_getCooldown() {
        return CommonConfigs.HAMMOCK_COOLDOWN.get().intValue();
    }

    @Override
    public boolean st_hasPenalties() {
        return CommonConfigs.PENALTIES_HAMMOCK.get();
    }

    @Override
    public boolean st_hasRequirements() {
        return CommonConfigs.REQUIREMENT_HAMMOCK.get();
    }

    @Override
    public boolean st_canSpawnBedbugs() {
        return false;
    }

    @Override
    public long st_modifyWakeUpTime(WakeReason reason, long newTime, long dayTime) {
        if (reason == WakeReason.SLEPT_SUCCESSFULLY) {
            long i = dayTime + 24000L;
            return i - i % 24000L - 11001L;
        }
        return IModBed.super.st_modifyWakeUpTime(reason, newTime, dayTime);
    }

    public Optional<class_2680> getRotatedState(class_2680 state, class_1936 world, class_2338 pos, class_2470 rotation, class_2350 axis, @Nullable class_243 hit) {
        return Optional.empty();
    }

    public Optional<class_2350> rotateOverAxis(class_2680 state, class_1936 world, class_2338 pos, class_2470 rotation, class_2350 axis, @Nullable class_243 hit) {
        return super.rotateOverAxis(state, world, pos, rotation, axis, hit);
    }

    public class_2350 getBedDirection(class_2680 state, class_4538 level, class_2338 pos) {
        return (class_2350)state.method_11654((class_2769)class_2383.field_11177);
    }

    private static enum Connection {
        BLOCK,
        FENCE,
        NONE;


        public HammockPart getHead() {
            return this == BLOCK ? HammockPart.HALF_HEAD : HammockPart.HEAD;
        }
    }
}

