/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.sleep_tight.SleepTightClient;
import net.mehvahdjukaar.sleep_tight.SleepTightPlatformStuff;
import net.mehvahdjukaar.sleep_tight.common.blocks.DreamEssenceBlock;
import net.mehvahdjukaar.sleep_tight.common.blocks.ISleepTightBed;
import net.mehvahdjukaar.sleep_tight.common.blocks.NightBagBlock;
import net.mehvahdjukaar.sleep_tight.common.entities.BedEntity;
import net.mehvahdjukaar.sleep_tight.common.items.NightBagItem;
import net.mehvahdjukaar.sleep_tight.configs.ClientConfigs;
import net.mehvahdjukaar.sleep_tight.core.BedData;
import net.mehvahdjukaar.sleep_tight.core.PlayerSleepData;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_4061;
import net.minecraft.class_423;
import net.minecraft.class_5348;
import net.minecraft.class_746;

public abstract class SleepGuiOverlay<T extends class_329> {
    private static boolean isHomeBed = false;
    private static boolean hasDreamerEssence = false;

    public void render(T gui, class_332 graphics, float partialTicks, int width, int height) {
        PlayerSleepData c;
        float f;
        class_3965 bh;
        class_746 player;
        boolean laying;
        class_310 mc = class_310.method_1551();
        class_315 options = mc.field_1690;
        if (options.field_1842) {
            return;
        }
        class_239 hit = mc.field_1765;
        boolean cooldown = ClientConfigs.INSOMNIA_COOLDOWN.get();
        boolean timer = ClientConfigs.INSOMNIA_TIMER.get();
        if (!timer && !cooldown) {
            return;
        }
        if (options.method_31044().method_31034() && (mc.field_1761.method_2920() != class_1934.field_9219 || gui.method_17534(hit)) && ((laying = (player = mc.field_1724).method_5854() instanceof BedEntity) || cooldown && (hit instanceof class_3965 && mc.field_1687.method_8320((bh = (class_3965)hit).method_17777()).method_26204() instanceof ISleepTightBed || player.method_6047().method_7909() instanceof NightBagItem)) && (f = 1.0f - (c = SleepTightPlatformStuff.getPlayerSleepData((class_1657)player)).getInsomniaCooldown((class_1657)player)) < 1.0f) {
            if (laying && timer) {
                graphics.method_25303(mc.field_1772, "" + c.getInsomniaTimeLeft((class_1657)player) / 20L, 2, 2, 0xE0E0E0);
            }
            if (cooldown) {
                this.setupOverlayRenderState(gui, true, false, SleepTightClient.ICONS);
                graphics.method_51448().method_22903();
                RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
                int j = height / 2 - 7 + 16;
                int k = width / 2 - 6;
                if (mc.field_1690.method_42565().method_41753() == class_4061.field_18152 && player.method_7261(0.0f) != 1.0f) {
                    j += 8;
                }
                int l = (int)(f * 11.0f);
                graphics.method_25290(SleepTightClient.ICONS, k, j, 3.0f, 18.0f, 11, 5, 48, 48);
                graphics.method_25290(SleepTightClient.ICONS, k, j, 19.0f, 18.0f, l, 5, 48, 48);
                graphics.method_51448().method_22909();
            }
        }
    }

    protected abstract void setupOverlayRenderState(T var1, boolean var2, boolean var3, class_2960 var4);

    public static void renderBedScreenOverlay(class_423 s, class_332 graphics, int mouseX, int mouseY) {
        int x;
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (ClientConfigs.SHOW_TIME.get().booleanValue()) {
            graphics.method_27535(mc.field_1772, SleepGuiOverlay.getCurrentTime(player.method_37908()), 2, 2, 0xE0E0E0);
        }
        int y = s.field_22790 - 39;
        int iconSize = 18;
        if (isHomeBed) {
            x = s.field_22789 / 2 - 120;
            graphics.method_25290(SleepTightClient.ICONS, x, y, 0.0f, 0.0f, iconSize, iconSize, 48, 48);
        }
        if (hasDreamerEssence) {
            x = s.field_22789 / 2 + 120 - iconSize;
            graphics.method_25290(SleepTightClient.ICONS, x, y, (float)iconSize, 0.0f, iconSize, iconSize, 48, 48);
        }
        if (isHomeBed && MthUtils.isWithinRectangle((int)(x = s.field_22789 / 2 - 120), (int)y, (int)iconSize, (int)iconSize, (int)mouseX, (int)mouseY)) {
            PlayerSleepData data = SleepTightPlatformStuff.getPlayerSleepData((class_1657)player);
            double nightmare = data.getNightmareChance((class_1657)player, player.method_18398().orElse(class_2338.field_10980));
            int bedLevel = data.getHomeBedLevel();
            ArrayList lines = new ArrayList(mc.field_1772.method_1728((class_5348)class_2561.method_43471((String)"gui.sleep_tight.home_bed"), 200));
            lines.addAll(mc.field_1772.method_1728((class_5348)class_2561.method_43469((String)"gui.sleep_tight.bed_level", (Object[])new Object[]{bedLevel}), 200));
            lines.addAll(mc.field_1772.method_1728((class_5348)class_2561.method_43469((String)"gui.sleep_tight.nightmare", (Object[])new Object[]{nightmare}), 200));
            graphics.method_51447(mc.field_1772, lines, mouseX, mouseY);
        }
        if (hasDreamerEssence && MthUtils.isWithinRectangle((int)(x = s.field_22789 / 2 + 120 - iconSize), (int)y, (int)iconSize, (int)iconSize, (int)mouseX, (int)mouseY)) {
            graphics.method_51447(mc.field_1772, mc.field_1772.method_1728((class_5348)class_2561.method_43471((String)"gui.sleep_tight.dreamer_essence"), 200), mouseX, mouseY);
        }
    }

    private static class_2561 getCurrentTime(class_1937 level) {
        int time = (int)(level.method_8532() + 6000L) % 24000;
        int m = (int)((float)time % 1000.0f / 1000.0f * 60.0f);
        int h = time / 1000;
        String a = "";
        if (!ClientConfigs.TIME_FORMAT_24H.get().booleanValue()) {
            String string = a = time < 12000 ? " AM" : " PM";
            if ((h %= 12) == 0) {
                h = 12;
            }
        }
        return class_2561.method_43470((String)(h + ":" + (m < 10 ? "0" : "") + m + a));
    }

    public static void setupOverlay(class_423 screen) {
        isHomeBed = false;
        hasDreamerEssence = false;
        class_746 player = class_310.method_1551().field_1724;
        Optional p = player.method_18398();
        if (p.isPresent()) {
            class_2338 pos = (class_2338)p.get();
            BedData cap = PlayerSleepData.getHomeBedIfHere((class_1657)player, pos);
            isHomeBed = cap != null;
            hasDreamerEssence = !(player.method_37908().method_8320(pos).method_26204() instanceof NightBagBlock) && DreamEssenceBlock.isInRange(pos, player.method_37908());
        }
    }
}

