/*
 * Decompiled with CFR 0.152.
 */
package com.saltywater.sittingplus;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public class SittingPlusConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("SittingPlusConfig.json");
    public boolean enableClickToSit = true;
    public boolean enableThirdPersonOnSit = true;
    public boolean onlyLowerCameraInFirstPerson = false;
    public boolean enableAfkSit = true;
    public int afkSitDelaySeconds = 60;
    private static SittingPlusConfig instance;

    public static SittingPlusConfig getConfig() {
        if (instance == null) {
            instance = new SittingPlusConfig();
            instance.loadConfig();
        }
        return instance;
    }

    private void loadConfig() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                SittingPlusConfig loaded = (SittingPlusConfig)GSON.fromJson((Reader)reader, SittingPlusConfig.class);
                if (loaded != null) {
                    this.enableClickToSit = loaded.enableClickToSit;
                    this.enableThirdPersonOnSit = loaded.enableThirdPersonOnSit;
                    this.onlyLowerCameraInFirstPerson = loaded.onlyLowerCameraInFirstPerson;
                    this.enableAfkSit = loaded.enableAfkSit;
                    this.afkSitDelaySeconds = loaded.afkSitDelaySeconds;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.saveConfig();
        }
    }

    public void saveConfig() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson((Object)this, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

