/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_4081;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class FatalFlickerEffect
extends class_1291 {
    public FatalFlickerEffect(class_4081 statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public static void performDash(class_1309 user, class_1937 world, int radius) {
        class_1309 le;
        int dashDistance = (int)Config.getFloat("fatalFlickerDashVelocity", "UniqueEffects", ConfigDefaultValues.fatalFlickerDashVelocity);
        int maxAmplifier = (int)Config.getFloat("fatalFlickerMaxStacks", "UniqueEffects", ConfigDefaultValues.fatalFlickerMaxStacks);
        int amplifier = 1;
        user.method_18799(user.method_5720().method_1021((double)dashDistance));
        user.method_18800(user.method_18798().field_1352, 0.0, user.method_18798().field_1350);
        user.field_6037 = true;
        user.method_37222(new class_1293(class_1294.field_5907, 10, 3), (class_1297)user);
        user.field_6008 = 25;
        class_238 box = HelperMethods.createBox((class_1297)user, radius);
        List entities = world.method_8333((class_1297)user, box, class_1301.field_6157);
        for (class_1297 entity : entities) {
            if (!(entity instanceof class_1309) || !HelperMethods.checkFriendlyFire(le = (class_1309)entity, user)) continue;
            ++amplifier;
        }
        for (class_1297 entity : entities) {
            if (!(entity instanceof class_1309) || !HelperMethods.checkFriendlyFire(le = (class_1309)entity, user)) continue;
            HelperMethods.incrementStatusEffect(le, (class_1291)EffectRegistry.ECHO.get(), 20, amplifier, maxAmplifier);
        }
        class_238 boxPull = HelperMethods.createBox((class_1297)user, radius * 2);
        for (class_1297 entity : world.method_8333((class_1297)user, boxPull, class_1301.field_6157)) {
            class_1309 le2;
            if (!(entity instanceof class_1309) || !HelperMethods.checkFriendlyFire(le2 = (class_1309)entity, user)) continue;
            le2.method_18800((user.method_23317() - le2.method_23317()) / 4.0, (user.method_23318() - le2.method_23318()) / 4.0, (user.method_23321() - le2.method_23321()) / 4.0);
        }
    }

    public void method_5572(class_1309 user, int amplifier) {
        super.method_5572(user, amplifier);
        if (!user.method_37908().method_8608()) {
            int ability_timer = Objects.requireNonNull(user.method_6112((class_1291)EffectRegistry.FATAL_FLICKER.get())).method_5584();
            class_1937 world = user.method_37908();
            int radius = (int)Config.getFloat("fatalFlickerRadius", "UniqueEffects", ConfigDefaultValues.fatalFlickerRadius);
            if (ability_timer >= 5) {
                FatalFlickerEffect.performDash(user, world, radius);
            } else {
                user.method_18800(0.0, 0.0, 0.0);
                user.field_6037 = true;
            }
            if (user.field_6012 % 2 == 0) {
                int particleRadius = (int)((double)radius * 0.5);
                double xpos = user.method_23317() - (double)(particleRadius + 1);
                double ypos = user.method_23318();
                double zpos = user.method_23321() - (double)(particleRadius + 1);
                for (int i = particleRadius * 2; i > 0; --i) {
                    for (int j = particleRadius * 2; j > 0; --j) {
                        float choose = (float)(Math.random() * 1.0);
                        HelperMethods.spawnParticle(world, (class_2394)class_2398.field_29644, xpos + (double)i + (double)choose, ypos + 0.4, zpos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                        HelperMethods.spawnParticle(world, (class_2394)class_2398.field_11204, xpos + (double)i + (double)choose, ypos + 0.1, zpos + (double)j + (double)choose, 0.0, 0.0, 0.0);
                        HelperMethods.spawnParticle(world, (class_2394)class_2398.field_22249, xpos + (double)i + (double)choose, ypos, zpos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                    }
                }
            }
        }
    }

    public boolean method_5552(int pDuration, int pAmplifier) {
        return true;
    }
}

