/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.util;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_1296;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1425;
import net.minecraft.class_1531;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.puffish.skillsmod.api.SkillsAPI;
import net.sweenus.simplyskills.SimplySkills;

public class DynamicDamage {
    public static float dynamicDamageReduction(class_1309 attacker, class_1309 target, float amount, float lastDamageTaken, float damage, float lastDamageTime) {
        if (attacker != null && lastDamageTaken > 0.0f && SimplySkills.generalConfig.enableDDR && (!(target instanceof class_1657) || SimplySkills.generalConfig.DDRAffectsPlayers)) {
            class_1937 world = attacker.method_37908();
            float maxHp = target.method_6063();
            float thresholdCheck = amount / maxHp;
            float ddrAttackSpeedWeight = (float)SimplySkills.generalConfig.DDRAttackSpeedWeight / 100.0f;
            float ddrAmount = (float)SimplySkills.generalConfig.DDRAmount / 100.0f;
            float ddrHealthThreshold = (float)SimplySkills.generalConfig.DDRHealthThreshold / 100.0f;
            float damageFrequency = 0.01f + ((float)world.method_8510() - lastDamageTime) / (damage * ddrAttackSpeedWeight);
            float healthPercent = Math.min(damage / maxHp * damage, 0.9f * damage);
            float minimumHp = SimplySkills.generalConfig.DDRHealthRequirement;
            if (thresholdCheck > ddrHealthThreshold && maxHp >= minimumHp) {
                float damageReduction = Math.min(healthPercent * ddrAmount, damage / 2.0f);
                float newAmount = Math.max(damage - damageReduction, 1.0f) * Math.max(Math.min(damageFrequency, 1.0f), 0.3f);
                if (SimplySkills.generalConfig.enableDDRDebugLog && attacker instanceof class_1657) {
                    attacker.method_43496((class_2561)class_2561.method_43470((String)("\u00a7fDamage reduced from \u00a76" + damage + " \u00a7fto\u00a7a " + newAmount + " \u00a7fusing DR: \u00a76" + damageReduction + "\u00a7f & SDR: \u00a7b" + damageFrequency)));
                }
                return newAmount;
            }
        }
        return amount;
    }

    public static void dynamicAttributeScaling(class_1309 entity, class_1320 attribute, String name, double amount, UUID uuid) {
        class_1309 class_13092;
        if (entity.method_6065() != null && (class_13092 = entity.method_6065()) instanceof class_3222) {
            class_3222 player = (class_3222)class_13092;
            class_1324 attributeInstance = entity.method_5996(attribute);
            int pointsSpent = DynamicDamage.getSpentPoints(player);
            double totalAmount = amount * (double)pointsSpent;
            if (attributeInstance != null && attributeInstance.method_6199(uuid) == null) {
                class_1322 modifier = new class_1322(uuid, name, totalAmount, class_1322.class_1323.field_6328);
                attributeInstance.method_26835(modifier);
                if (attribute.equals(class_5134.field_23716)) {
                    entity.method_6025((float)totalAmount);
                }
            }
        }
    }

    public static void dynamicPlayerCountScaling(class_1309 livingEntity) {
        double checkDistance = SimplySkills.generalConfig.DASRadius;
        List nearbyPlayers = livingEntity.method_37908().method_8390(class_3222.class, livingEntity.method_5829().method_1014(checkDistance), playerEntity -> true);
        int totalPointsSpent = 0;
        int totalPlayerCount = 0;
        float entityTypeModifier = 1.0f;
        if (livingEntity instanceof class_1296 || livingEntity instanceof class_1425 || livingEntity instanceof class_1646 || livingEntity instanceof class_1531) {
            entityTypeModifier = SimplySkills.generalConfig.DASPassiveEntityModifier;
        }
        for (class_3222 player : nearbyPlayers) {
            int pointsSpent = DynamicDamage.getSpentPoints(player);
            if (!SimplySkills.generalConfig.DASScaleWithPointsSpent) {
                pointsSpent = DynamicDamage.getUnspentPoints(player) + DynamicDamage.getSpentPoints(player);
            }
            double playerCountDampener = (double)totalPointsSpent * ((double)(++totalPlayerCount) / (double)SimplySkills.generalConfig.DASPlayerScalingWeight);
            totalPointsSpent += (int)Math.max(((double)pointsSpent - playerCountDampener) * (double)entityTypeModifier, 0.0);
            if (!SimplySkills.generalConfig.enableDASDebugLog) continue;
            String message = "\u00a7fScaling \u00a76" + livingEntity.method_5477().getString() + " \u00a7fusing\u00a7a " + player.method_5477().getString() + " \u00a7fspent skill points of\u00a76 " + DynamicDamage.getSpentPoints(player) + "\u00a7f. Total scale factor: \u00a7b" + totalPointsSpent;
            if (!SimplySkills.generalConfig.DASScaleWithPointsSpent) {
                message = "\u00a7fScaling \u00a76" + livingEntity.method_5477().getString() + " \u00a7fusing\u00a7a " + player.method_5477().getString() + " \u00a7ftotal skill points of\u00a76 " + (DynamicDamage.getSpentPoints(player) + DynamicDamage.getUnspentPoints(player)) + "\u00a7f. Total scale factor: \u00a7b" + totalPointsSpent;
            }
            player.method_43496((class_2561)class_2561.method_43470((String)message));
        }
        if (SimplySkills.generalConfig.enableDAS && !(livingEntity instanceof class_1657)) {
            double maxHealth;
            if (SimplySkills.generalConfig.enableDASDebugLog) {
                String message = "Attempting to apply DAS attributes to " + livingEntity.method_5477().getString() + ". Player Count: " + totalPlayerCount + ". total points spent: " + totalPointsSpent;
                System.out.println(message);
            }
            float addRequirement = SimplySkills.generalConfig.addMultiHealthRequirement;
            double addHealth = 1.0;
            double addAttack = 1.0;
            double addArmor = 1.0;
            double addToughness = 1.0;
            double addSpeed = 1.0;
            double addResistance = 1.0;
            class_1324 attributeInstance = livingEntity.method_5996(class_5134.field_23716);
            if (attributeInstance != null && (maxHealth = attributeInstance.method_6201()) >= (double)addRequirement) {
                addHealth = SimplySkills.generalConfig.DASHealthAddMulti;
                addAttack = SimplySkills.generalConfig.DASAttackAddMulti;
                addArmor = SimplySkills.generalConfig.DASArmorAddMulti;
                addToughness = SimplySkills.generalConfig.DASToughnessAddMulti;
                addSpeed = SimplySkills.generalConfig.DASSpeedAddMulti;
                addResistance = SimplySkills.generalConfig.DASResistAddMulti;
            }
            if (SimplySkills.generalConfig.DASHealth > 0.0) {
                DynamicDamage.dynamicTotalAttributeScaling(livingEntity, class_5134.field_23716, "SimplySkills health DAS", SimplySkills.generalConfig.DASHealth, UUID.fromString("631937f6-bc47-486b-b07a-542823d668a6"), (double)totalPointsSpent * addHealth);
            }
            if (SimplySkills.generalConfig.DASAttack > 0.0) {
                DynamicDamage.dynamicTotalAttributeScaling(livingEntity, class_5134.field_23721, "SimplySkills attack damage DAS", SimplySkills.generalConfig.DASAttack, UUID.fromString("8097403f-ed25-4534-b7f9-854e16ef2fbb"), (double)totalPointsSpent * addAttack);
            }
            if (SimplySkills.generalConfig.DASArmor > 0.0) {
                DynamicDamage.dynamicTotalAttributeScaling(livingEntity, class_5134.field_23724, "SimplySkills armor DAS", SimplySkills.generalConfig.DASArmor, UUID.fromString("eae99963-45c4-4651-b501-4b2e16879705"), (double)totalPointsSpent * addArmor);
            }
            if (SimplySkills.generalConfig.DASArmorToughness > 0.0) {
                DynamicDamage.dynamicTotalAttributeScaling(livingEntity, class_5134.field_23725, "SimplySkills armor toughness DAS", SimplySkills.generalConfig.DASArmorToughness, UUID.fromString("0794ab19-7dbd-421f-90c7-6b65e3aee495"), (double)totalPointsSpent * addToughness);
            }
            if (SimplySkills.generalConfig.DASSpeed / 100.0 > 0.0) {
                DynamicDamage.dynamicTotalAttributeScaling(livingEntity, class_5134.field_23719, "SimplySkills movement speed DAS", SimplySkills.generalConfig.DASSpeed / 100.0, UUID.fromString("426d5ed8-020b-484f-93d9-4327a3c05c97"), (double)totalPointsSpent * addSpeed);
            }
            if (SimplySkills.generalConfig.DASKnockbackResist / 100.0 > 0.0) {
                DynamicDamage.dynamicTotalAttributeScaling(livingEntity, class_5134.field_23718, "SimplySkills knockback resistance DAS", SimplySkills.generalConfig.DASKnockbackResist / 100.0, UUID.fromString("9ffef649-025d-4c30-98ed-d4378cd07d36"), (double)totalPointsSpent * addResistance);
            }
        }
    }

    public static void dynamicTotalAttributeScaling(class_1309 entity, class_1320 attribute, String name, double amount, UUID uuid, double pointsSpent) {
        class_1324 attributeInstance = entity.method_5996(attribute);
        if (pointsSpent == 0.0) {
            if (attributeInstance != null && attributeInstance.method_6199(uuid) != null) {
                if (attribute.equals(class_5134.field_23716)) {
                    float healthRatio = entity.method_6032() / entity.method_6063();
                    attributeInstance.method_6200(uuid);
                    entity.method_6033(entity.method_6063() * healthRatio);
                } else {
                    attributeInstance.method_6200(uuid);
                }
            }
            return;
        }
        double totalAmount = amount * pointsSpent;
        if (attributeInstance != null) {
            class_1322 existingModifier = attributeInstance.method_6199(uuid);
            if (existingModifier == null) {
                class_1322 newModifier = new class_1322(uuid, name, totalAmount, class_1322.class_1323.field_6328);
                attributeInstance.method_26835(newModifier);
                if (attribute.equals(class_5134.field_23716)) {
                    entity.method_6025((float)totalAmount);
                }
            } else if (existingModifier.method_6186() != totalAmount) {
                attributeInstance.method_6202(existingModifier);
                class_1322 updatedModifier = new class_1322(uuid, name, totalAmount, class_1322.class_1323.field_6328);
                attributeInstance.method_26835(updatedModifier);
                if (attribute.equals(class_5134.field_23716)) {
                    double difference = totalAmount - existingModifier.method_6186();
                    entity.method_6025((float)difference);
                }
            }
        }
    }

    public static int getSpentPoints(class_3222 player) {
        return SkillsAPI.streamUnlockedCategories((class_3222)player).mapToInt(category -> (int)category.streamUnlockedSkills(player).count()).sum();
    }

    public static int getUnspentPoints(class_3222 player) {
        return SkillsAPI.streamUnlockedCategories((class_3222)player).mapToInt(category -> category.getPointsLeft(player)).sum();
    }
}

