/*
 * Decompiled with CFR 0.152.
 */
package survivalblock.shield_surf.common.util;

import net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3468;
import survivalblock.shield_surf.access.ExpulsionDamageAccess;
import survivalblock.shield_surf.common.ShieldSurf;
import survivalblock.shield_surf.common.compat.SurfingFabricShieldLib;
import survivalblock.shield_surf.common.component.ShieldSatellitesComponent;
import survivalblock.shield_surf.common.enchantment.ShieldSurfingEnchantment;
import survivalblock.shield_surf.common.entity.ProjectedShieldEntity;
import survivalblock.shield_surf.common.entity.ShieldboardEntity;
import survivalblock.shield_surf.common.init.ShieldSurfEnchantments;
import survivalblock.shield_surf.common.init.ShieldSurfEntityComponents;
import survivalblock.shield_surf.common.init.ShieldSurfGameRules;

public class ShieldSurfUtil {
    public static class_1799 getFirstAegisStack(class_1309 living, boolean shouldCooldown) {
        for (class_1799 handStack : living.method_5877()) {
            class_1657 player;
            if (!ShieldSurfUtil.isAShield(handStack) || class_1890.method_8225((class_1887)ShieldSurfEnchantments.AEGIS, (class_1799)handStack) <= 0 || living instanceof class_1657 && (player = (class_1657)living).method_7357().method_7904(handStack.method_7909())) continue;
            return handStack;
        }
        if (living instanceof class_1657) {
            class_1657 player = (class_1657)living;
            int size = player.method_31548().method_5439();
            for (int slot = 0; slot < size; slot = (int)((short)(slot + 1))) {
                class_1799 stackInSlot = player.method_31548().method_5438(slot);
                if (!ShieldSurfUtil.isAShield(stackInSlot) || class_1890.method_8225((class_1887)ShieldSurfEnchantments.AEGIS, (class_1799)stackInSlot) <= 0) continue;
                class_1792 item = stackInSlot.method_7909();
                if (player.method_7357().method_7904(item)) continue;
                if (shouldCooldown) {
                    player.method_7357().method_7906(item, 100);
                }
                return stackInSlot;
            }
        }
        return class_1799.field_8037;
    }

    public static boolean hasAegis(class_1309 living) {
        return ShieldSurfUtil.getFirstAegisStack(living, false) != class_1799.field_8037;
    }

    public static boolean isAShield(class_1799 stack) {
        return stack.method_31573(ConventionalItemTags.SHIELDS) || stack.method_31574(class_1802.field_8255) || ShieldSurf.hasFabricShieldLib && SurfingFabricShieldLib.isAFabricShield(stack);
    }

    public static boolean cancelShieldEnchantments(class_1887 original, class_1887 other) {
        return !(other instanceof ShieldSurfingEnchantment) || other == original;
    }

    public static void rideTheLightning(class_1937 world, class_1657 user, class_1792 item, class_1799 stack) {
        if (!world.method_8608() && class_1890.method_8225((class_1887)ShieldSurfEnchantments.SHIELD_SURF, (class_1799)stack) > 0 && !user.method_5715()) {
            user.method_7259(class_3468.field_15372.method_14956((Object)item));
            ShieldboardEntity shieldboard = new ShieldboardEntity(world, (class_1309)user, stack);
            world.method_8649((class_1297)shieldboard);
            user.method_31548().method_7378(stack);
            user.method_5873((class_1297)shieldboard, true);
        }
    }

    public static void shieldcast(class_1937 world, class_1657 user, class_1268 hand, class_1792 item, class_1799 stack) {
        int expulsionLevel = class_1890.method_8225((class_1887)ShieldSurfEnchantments.EXPULSION, (class_1799)stack);
        if (world.method_8608() || expulsionLevel <= 0 || !user.method_5715()) {
            return;
        }
        float damage = ((ExpulsionDamageAccess)user).shield_surf$getExpulsionAttackDamage();
        if (damage * 2.0f <= 100.0f) {
            damage *= 2.0f;
        } else if (damage < 100.0f) {
            damage = 100.0f;
        }
        try {
            int multiplier = world.method_8450().method_8356(ShieldSurfGameRules.EXPULSION_MULTIPLIER);
            for (float i = 0.0f; i < 360.0f; i += 360.0f / (float)(expulsionLevel * multiplier)) {
                ProjectedShieldEntity projectedShield = new ProjectedShieldEntity(world, (class_1309)user, stack);
                projectedShield.method_36456(i + user.method_36454());
                world.method_8649((class_1297)projectedShield);
                projectedShield.method_24919((class_1297)user, projectedShield.method_36455(), projectedShield.method_36454(), 0.0f, 0.3f, 0.0f);
                class_243 velocity = projectedShield.method_18798();
                projectedShield.method_18800(velocity.field_1352, Math.max(-0.1, velocity.field_1351), velocity.field_1350);
                projectedShield.method_7438(Math.max(damage, 4.0f));
            }
            ShieldSurfUtil.damageAndIncrementStat(user, hand, item, stack, 2, 200);
        }
        catch (Exception e) {
            ShieldSurf.LOGGER.error("An exception occurred while trying to summon a Projected Shield", (Throwable)e);
        }
    }

    public static void solarSystem(class_1937 world, class_1657 user, class_1268 hand, class_1792 item, class_1799 stack) {
        if (world.method_8608() || class_1890.method_8225((class_1887)ShieldSurfEnchantments.ORBIT, (class_1799)stack) <= 0) {
            return;
        }
        ShieldSatellitesComponent satellitesComponent = (ShieldSatellitesComponent)ShieldSurfEntityComponents.SHIELD_SATELLITES.get((Object)user);
        if (satellitesComponent.getSatellites() + 1 > 16) {
            return;
        }
        satellitesComponent.addSatellite(stack);
        ShieldSurfUtil.damageAndIncrementStat(user, hand, item, stack, 3, 80);
    }

    private static void damageAndIncrementStat(class_1657 user, class_1268 hand, class_1792 item, class_1799 stack, int damage, int cooldown) {
        if (!user.method_7337()) {
            stack.method_7956(damage, (class_1309)user, p -> p.method_20236(hand));
            user.method_7357().method_7906(item, cooldown);
            user.method_6075();
        }
        user.method_7259(class_3468.field_15372.method_14956((Object)item));
    }
}

