/*
 * Decompiled with CFR 0.152.
 */
package survivalblock.shield_surf.common.entity;

import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1316;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2553;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_5712;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;
import survivalblock.shield_surf.common.component.ShieldStackComponent;
import survivalblock.shield_surf.common.component.ShieldboardSpeedComponent;
import survivalblock.shield_surf.common.init.ShieldSurfDamageTypes;
import survivalblock.shield_surf.common.init.ShieldSurfEnchantments;
import survivalblock.shield_surf.common.init.ShieldSurfEntityComponents;
import survivalblock.shield_surf.common.init.ShieldSurfEntityTypes;

public class ShieldboardEntity
extends class_1297
implements class_1316 {
    protected float ticksUnderwater;
    protected double waterLevel;
    protected class_1690.class_1691 location;
    protected class_1690.class_1691 lastLocation;
    protected double fallVelocity;
    private boolean shouldAccelerateForward;
    private boolean shouldGoBackward;
    private boolean shouldTurnLeft;
    private boolean shouldTurnRight;
    protected boolean jumping;
    protected float jumpingPower;
    public static final double DEFAULT_JUMP_STRENGTH = 0.4;
    protected boolean inAirForJump;
    public static final double MAX_SPEED = 0.36921875;

    public ShieldboardEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
        this.getShieldStackComponent().setShieldStack(class_1802.field_8255.method_7854());
        this.getShieldboardSpeedComponent().setCurrentBaseSpeed(0.0);
        this.method_49477(0.6f);
    }

    protected void method_5693() {
    }

    public ShieldboardEntity(class_1937 world, class_1309 rider, class_1799 stack) {
        this(ShieldSurfEntityTypes.SHIELDBOARD, world);
        this.setInputs();
        if (rider.method_5624()) {
            rider.method_5728(false);
        }
        this.getShieldStackComponent().setShieldStack(stack.method_46651(stack.method_7947()));
        this.method_23327(rider.method_23317(), rider.method_23318(), rider.method_23321());
        this.lastLocation = class_1690.class_1691.field_7720;
        this.location = class_1690.class_1691.field_7718;
        this.method_36456(rider.method_36454());
    }

    public void setInputs() {
        this.setInputs(false, false, false, false);
    }

    public void setInputs(boolean pressingLeft, boolean pressingRight, boolean pressingForward, boolean pressingBack) {
        this.shouldAccelerateForward = pressingForward;
        this.shouldGoBackward = pressingForward ? false : pressingBack;
        if (pressingLeft && pressingRight) {
            this.shouldTurnLeft = false;
            this.shouldTurnRight = false;
        } else {
            this.shouldTurnLeft = pressingLeft;
            this.shouldTurnRight = pressingRight;
        }
    }

    private ShieldStackComponent getShieldStackComponent() {
        return (ShieldStackComponent)ShieldSurfEntityComponents.SHIELD_STACK.get((Object)this);
    }

    private ShieldboardSpeedComponent getShieldboardSpeedComponent() {
        return (ShieldboardSpeedComponent)ShieldSurfEntityComponents.SHIELDBOARD_SPEED.get((Object)this);
    }

    public boolean method_30949(class_1297 other) {
        return false;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        class_1309 rider = this.method_5642();
        if (rider != null && rider.method_5655() && rider.method_5679(source)) {
            return false;
        }
        if (rider instanceof class_1657) {
            class_1657 player = (class_1657)rider;
            if (player.method_31549().field_7480) {
                return false;
            }
        }
        this.method_5785();
        if (!this.method_37908().method_8608()) {
            this.method_5768();
        }
        return true;
    }

    public boolean method_5679(class_1282 damageSource) {
        return this.method_31481() || this.method_5655() && !damageSource.method_48789(class_8103.field_42242) && !damageSource.method_5530() || damageSource.method_48789(class_8103.field_42246) || damageSource.method_48789(class_8103.field_42250);
    }

    public boolean method_5753() {
        if (super.method_5753()) {
            return true;
        }
        class_1799 stack = this.getItemStack();
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return stack.method_7909().method_24358();
    }

    public void method_5650(class_1297.class_5529 reason) {
        class_1309 controllingPassenger = this.method_5642();
        ShieldStackComponent shieldStackComponent = this.getShieldStackComponent();
        if (controllingPassenger instanceof class_1657) {
            class_1657 player = (class_1657)controllingPassenger;
            player.method_31548().method_7398(shieldStackComponent.getShieldStack());
        } else if (this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
            this.method_5775(shieldStackComponent.getShieldStack());
        }
        shieldStackComponent.setShieldStack(class_1799.field_8037);
        if (this.method_5782()) {
            this.method_5772();
        }
        super.method_5650(reason);
    }

    protected void method_5793(class_1297 passenger) {
        if (!this.method_37908().method_8608()) {
            this.method_31472();
        }
        super.method_5793(passenger);
    }

    public void method_5773() {
        Object object;
        List list;
        if (!this.method_37908().method_8608() && this.getShieldStackComponent().getShieldStack().method_7919() == this.getShieldStackComponent().getShieldStack().method_7936()) {
            this.method_31472();
        }
        this.lastLocation = this.location;
        this.location = this.checkLocation();
        this.ticksUnderwater = this.location == class_1690.class_1691.field_7717 || this.location == class_1690.class_1691.field_7716 ? this.ticksUnderwater + 1.0f : 0.0f;
        super.method_5773();
        class_1309 living = this.method_5642();
        if (living == null) {
            return;
        }
        this.tickRotation(this.getControlledRotation(living));
        this.tickMovement();
        this.method_5852();
        if (!this.method_37908().method_8608() && !(list = this.method_37908().method_8333((class_1297)this, this.method_5829().method_1009((double)0.15f, (double)0.1f, (double)0.15f), class_1301.field_6155)).isEmpty()) {
            object = list.iterator();
            while (object.hasNext()) {
                class_1297 entity = (class_1297)object.next();
                if (this.method_5626(entity) || entity.method_5626((class_1297)this)) continue;
                entity.method_5697((class_1297)this);
                entity.method_5643(new class_1282(ShieldSurfDamageTypes.get(ShieldSurfDamageTypes.SHIELDBOARD_COLLISION, this.method_37908()), (class_1297)this, (class_1297)living), 4.0f);
            }
        }
        if (!this.method_37908().method_8608() && (object = this.method_5642()) instanceof class_1657) {
            class_1657 player = (class_1657)object;
            if (this.field_6012 % 20 == 0) {
                this.getShieldStackComponent().getShieldStack().method_7956(1, (class_1309)player, p -> p.method_20236(player.method_6058()));
            }
        }
    }

    private void addRotation(float yaw, float pitch) {
        this.method_5710(this.method_36454() + yaw, this.method_36455() + pitch);
    }

    private void tickRotation(class_241 rotation) {
        this.method_5710(rotation.field_1342, rotation.field_1343);
        if (this.shouldTurnRight) {
            this.addRotation(90.0f, 0.0f);
            if (this.shouldAccelerateForward) {
                this.addRotation(-45.0f, 0.0f);
            }
            if (this.shouldGoBackward) {
                this.addRotation(45.0f, 0.0f);
            }
        } else if (this.shouldTurnLeft) {
            this.addRotation(-90.0f, 0.0f);
            if (this.shouldAccelerateForward) {
                this.addRotation(45.0f, 0.0f);
            }
            if (this.shouldGoBackward) {
                this.addRotation(-45.0f, 0.0f);
            }
        } else if (this.shouldGoBackward) {
            this.addRotation(180.0f, 0.0f);
        } else if (!this.shouldAccelerateForward) {
            this.method_5710(this.field_5982, this.method_36455());
        }
        this.method_36456(this.method_36454());
        this.field_5982 = this.method_36454();
    }

    private void tickMovement() {
        if (this.method_5787()) {
            this.updateVelocity();
            if (this.method_37908().field_9236) {
                this.board();
            }
            this.method_5784(class_1313.field_6308, this.method_18798());
        } else {
            this.method_18799(class_243.field_1353);
        }
    }

    protected class_241 getControlledRotation(class_1309 controllingPassenger) {
        return new class_241(controllingPassenger.method_36455() * 0.5f, controllingPassenger.method_36454());
    }

    @Nullable
    public class_1309 method_5642() {
        class_1309 living;
        class_1297 entity = this.method_31483();
        return entity instanceof class_1309 ? (living = (class_1309)entity) : null;
    }

    public class_1799 asItemStack() {
        return this.getShieldStackComponent().getShieldStack().method_7972();
    }

    public class_1799 getItemStack() {
        return this.getShieldStackComponent().getShieldStack();
    }

    public boolean method_5810() {
        return super.method_5810();
    }

    protected void method_5749(class_2487 nbt) {
    }

    protected void method_5652(class_2487 nbt) {
    }

    public boolean method_30948() {
        return super.method_30948();
    }

    public double method_5621() {
        return super.method_5621() + 0.259;
    }

    protected boolean method_5818(class_1297 passenger) {
        return this.method_5685().size() < this.getMaxPassengers();
    }

    protected int getMaxPassengers() {
        return 1;
    }

    private void board() {
        if (!this.method_5782()) {
            return;
        }
        class_1309 controller = this.method_5642();
        ShieldboardSpeedComponent shieldboardSpeedComponent = this.getShieldboardSpeedComponent();
        double currentBaseSpeed = shieldboardSpeedComponent.getCurrentBaseSpeed();
        if (controller != null && Math.abs(currentBaseSpeed) < shieldboardSpeedComponent.getMaxBaseSpeed() / 2.0 && !(controller instanceof class_1657)) {
            this.setInputs(false, false, true, false);
        }
        this.field_6007 = true;
        double maxSpeed = shieldboardSpeedComponent.getMaxBaseSpeed();
        double celeration = 0.004;
        double speed = this.shouldAccelerateForward || this.shouldGoBackward || this.shouldTurnRight || this.shouldTurnLeft ? class_3532.method_15350((double)(currentBaseSpeed + 0.004 * (this.location == class_1690.class_1691.field_7720 && this.lastLocation == class_1690.class_1691.field_7720 ? 1.5 : 1.0)), (double)(-maxSpeed), (double)maxSpeed) : (Math.abs(currentBaseSpeed) <= 0.04 ? 0.0 : class_3532.method_15350((double)(currentBaseSpeed + 0.004 * (double)(currentBaseSpeed >= 0.0 ? -1 : 1) * (double)(this.field_5976 ? ((double)this.getNearbySlipperiness() > 0.6 ? 2 : 8) : 1)), (double)(-maxSpeed), (double)maxSpeed));
        shieldboardSpeedComponent.setCurrentBaseSpeed(speed);
        if (this.getNearbySlipperiness() > 0.0f) {
            speed *= (double)(1.0f + this.getNearbySlipperiness());
        }
        double yVelocity = this.method_18798().field_1351;
        if (this.location != null && this.location.compareTo((Enum)class_1690.class_1691.field_7718) == 0) {
            speed *= 2.75;
        }
        this.method_18800((double)class_3532.method_15374((float)(-this.method_36454() * ((float)Math.PI / 180))) * speed, yVelocity += this.shouldGetOutOfBlock() ? (this.location == class_1690.class_1691.field_7719 && this.lastLocation == class_1690.class_1691.field_7719 ? this.soulSandStuck() : 0.095) : 0.0, (double)class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180))) * speed);
        if (this.method_24828() || this.location == class_1690.class_1691.field_7718) {
            this.setInAirForJump(false);
            if (this.jumpingPower > 0.0f && !this.isInAirForJump()) {
                this.jump(this.jumpingPower);
            }
            this.jumpingPower = 0.0f;
        }
        if (this.isInAirForJump()) {
            class_243 current = this.method_18798();
            double airMultiplier = 2.6;
            this.method_18800(current.field_1352 * 2.6, current.field_1351, current.field_1350 * 2.6);
        }
        this.field_6037 = true;
    }

    private double soulSandStuck() {
        if (Math.abs(this.method_23318() - (double)Math.round(this.method_23318())) <= 0.05 || Math.abs(this.method_23318() - (double)Math.round(this.method_23318()) + 0.5) <= 0.05) {
            return 0.0;
        }
        double blockHeightAtPos = this.method_36601().method_26220((class_1922)this.method_37908(), this.method_24515()).method_1105(class_2350.class_2351.field_11052);
        return ShieldboardEntity.valueMap(blockHeightAtPos, 0.0, 1.6, 0.0, 0.255);
    }

    private static double valueMap(double value, double in_min, double in_max, double out_min, double out_max) {
        return (value - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
    }

    private boolean shouldGetOutOfBlock() {
        if (!this.field_5976) {
            return false;
        }
        class_1690.class_1691 currentLocation = this.checkLocation();
        if (currentLocation == null || this.lastLocation == null || this.location == class_1690.class_1691.field_7720) {
            return false;
        }
        if (this.location == class_1690.class_1691.field_7716) {
            return this.lastLocation == class_1690.class_1691.field_7719 || this.lastLocation == class_1690.class_1691.field_7720;
        }
        return true;
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.method_5814(x, y, z);
        this.method_36456(yaw);
        this.method_36457(pitch);
    }

    private class_1690.class_1691 checkLocation() {
        class_1690.class_1691 location = this.getUnderWaterLocation();
        if (location != null) {
            this.waterLevel = this.method_5829().field_1325;
            return location;
        }
        if (this.checkBoatInWater()) {
            return class_1690.class_1691.field_7718;
        }
        float f = this.getNearbySlipperiness();
        if (f > 0.0f) {
            return class_1690.class_1691.field_7719;
        }
        return class_1690.class_1691.field_7720;
    }

    public float getWaterHeightBelow() {
        class_238 box = this.method_5829();
        int i = class_3532.method_15357((double)box.field_1323);
        int j = class_3532.method_15384((double)box.field_1320);
        int k = class_3532.method_15357((double)box.field_1325);
        int l = class_3532.method_15384((double)(box.field_1325 - this.fallVelocity));
        int m = class_3532.method_15357((double)box.field_1321);
        int n = class_3532.method_15384((double)box.field_1324);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        block0: for (int o = k; o < l; ++o) {
            float f = 0.0f;
            for (int p = i; p < j; ++p) {
                for (int q = m; q < n; ++q) {
                    mutable.method_10103(p, o, q);
                    class_3610 fluidState = this.method_37908().method_8316((class_2338)mutable);
                    if (this.shouldFloatIn(fluidState)) {
                        f = Math.max(f, fluidState.method_15763((class_1922)this.method_37908(), (class_2338)mutable));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)mutable.method_10264() + f;
        }
        return l + 1;
    }

    protected boolean shouldFloatIn(class_3610 fluidState) {
        return true;
    }

    public float getNearbySlipperiness() {
        class_238 box = this.method_5829();
        class_238 box2 = new class_238(box.field_1323, box.field_1322 - 0.001, box.field_1321, box.field_1320, box.field_1322, box.field_1324);
        int i = class_3532.method_15357((double)box2.field_1323) - 1;
        int j = class_3532.method_15384((double)box2.field_1320) + 1;
        int k = class_3532.method_15357((double)box2.field_1322) - 1;
        int l = class_3532.method_15384((double)box2.field_1325) + 1;
        int m = class_3532.method_15357((double)box2.field_1321) - 1;
        int n = class_3532.method_15384((double)box2.field_1324) + 1;
        class_265 voxelShape = class_259.method_1078((class_238)box2);
        float f = 0.0f;
        int o = 0;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int p = i; p < j; ++p) {
            for (int q = m; q < n; ++q) {
                int r = (p == i || p == j - 1 ? 1 : 0) + (q == m || q == n - 1 ? 1 : 0);
                if (r == 2) continue;
                for (int s = k; s < l; ++s) {
                    if (r > 0 && (s == k || s == l - 1)) continue;
                    mutable.method_10103(p, s, q);
                    class_2680 blockState = this.method_37908().method_8320((class_2338)mutable);
                    if (blockState.method_26204() instanceof class_2553 || !class_259.method_1074((class_265)blockState.method_26220((class_1922)this.method_37908(), (class_2338)mutable).method_1096((double)p, (double)s, (double)q), (class_265)voxelShape, (class_247)class_247.field_16896)) continue;
                    if (this.shouldFloatIn(blockState.method_26227())) {
                        f += 1.0f;
                    }
                    f += blockState.method_26204().method_9499();
                    ++o;
                }
            }
        }
        return f / (float)o;
    }

    private boolean checkBoatInWater() {
        class_238 box = this.method_5829();
        int i = class_3532.method_15357((double)box.field_1323);
        int j = class_3532.method_15384((double)box.field_1320);
        int k = class_3532.method_15357((double)box.field_1322);
        int l = class_3532.method_15384((double)(box.field_1322 + 0.001));
        int m = class_3532.method_15357((double)box.field_1321);
        int n = class_3532.method_15384((double)box.field_1324);
        boolean bl = false;
        this.waterLevel = -1.7976931348623157E308;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int o = i; o < j; ++o) {
            for (int p = k; p < l; ++p) {
                for (int q = m; q < n; ++q) {
                    mutable.method_10103(o, p, q);
                    class_3610 fluidState = this.method_37908().method_8316((class_2338)mutable);
                    if (!this.shouldFloatIn(fluidState)) continue;
                    float f = (float)p + fluidState.method_15763((class_1922)this.method_37908(), (class_2338)mutable);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    bl |= box.field_1322 < (double)f;
                }
            }
        }
        return bl;
    }

    @Nullable
    private class_1690.class_1691 getUnderWaterLocation() {
        class_238 box = this.method_5829();
        double d = box.field_1325 + 0.001;
        int i = class_3532.method_15357((double)box.field_1323);
        int j = class_3532.method_15384((double)box.field_1320);
        int k = class_3532.method_15357((double)box.field_1325);
        int l = class_3532.method_15384((double)d);
        int m = class_3532.method_15357((double)box.field_1321);
        int n = class_3532.method_15384((double)box.field_1324);
        boolean bl = false;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int o = i; o < j; ++o) {
            for (int p = k; p < l; ++p) {
                for (int q = m; q < n; ++q) {
                    mutable.method_10103(o, p, q);
                    class_3610 fluidState = this.method_37908().method_8316((class_2338)mutable);
                    if (!this.shouldFloatIn(fluidState) || !(d < (double)((float)mutable.method_10264() + fluidState.method_15763((class_1922)this.method_37908(), (class_2338)mutable)))) continue;
                    if (fluidState.method_15771()) {
                        bl = true;
                        continue;
                    }
                    return class_1690.class_1691.field_7716;
                }
            }
        }
        return bl ? class_1690.class_1691.field_7717 : null;
    }

    private void updateVelocity() {
        double downward = this.method_5740() ? 0.0 : (double)-0.04f;
        double upwardIThink = 0.0;
        if (this.lastLocation == class_1690.class_1691.field_7720 && this.location != class_1690.class_1691.field_7720 && this.location != class_1690.class_1691.field_7719) {
            this.waterLevel = this.method_23323(1.0);
            this.method_5814(this.method_23317(), (double)(this.getWaterHeightBelow() - this.method_17682()) + 0.101, this.method_23321());
            this.method_18799(this.method_18798().method_18805(1.0, 0.0, 1.0));
            this.fallVelocity = 0.0;
            this.location = class_1690.class_1691.field_7718;
        } else {
            if (this.location == class_1690.class_1691.field_7718) {
                upwardIThink = (this.waterLevel - this.method_23318()) / (double)this.method_17682();
            } else if (this.location == class_1690.class_1691.field_7716) {
                downward = -7.0E-4;
            } else if (this.location == class_1690.class_1691.field_7717) {
                upwardIThink = 0.01f;
            }
            class_243 vec3d = this.method_18798();
            this.method_18800(vec3d.field_1352, vec3d.field_1351 + downward, vec3d.field_1350);
            if (upwardIThink > 0.0) {
                class_243 vec3d2 = this.method_18798();
                this.method_18800(vec3d2.field_1352, (vec3d2.field_1351 + upwardIThink * 0.06153846016296973) * 0.75, vec3d2.field_1350);
            }
        }
    }

    public void method_5700(boolean drag) {
        super.method_5700(drag);
        this.method_37908().method_8406((class_2394)class_2398.field_11202, this.method_23317() + (double)this.field_5974.method_43057(), this.method_23318() + 0.7, this.method_23321() + (double)this.field_5974.method_43057(), 0.0, 0.0, 0.0);
        if (this.field_5974.method_43048(20) == 0) {
            this.method_37908().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), this.method_5625(), this.method_5634(), 1.0f, 0.8f + 0.4f * this.field_5974.method_43057(), false);
            this.method_32875(class_5712.field_28160, (class_1297)this.method_5642());
        }
    }

    public class_2350 method_5755() {
        return super.method_5755().method_10170();
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28632;
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
        this.fallVelocity = this.method_18798().field_1351;
        if (this.method_5765()) {
            return;
        }
        if (onGround) {
            if (this.field_6017 > 3.0f && this.location != class_1690.class_1691.field_7719) {
                this.method_38785();
                return;
            }
            this.method_38785();
            this.field_6017 -= (float)heightDifference;
        }
    }

    public boolean method_24828() {
        return super.method_24828();
    }

    @Nullable
    public class_1799 method_31480() {
        return this.asItemStack();
    }

    public boolean method_5863() {
        return this.method_5642() == null;
    }

    public boolean method_27298() {
        boolean hasEnoughSpeed;
        if (!this.method_5805()) {
            return false;
        }
        if (this.method_5771() || this.method_5799() || this.field_5976) {
            return false;
        }
        ShieldboardSpeedComponent shieldboardSpeedComponent = this.getShieldboardSpeedComponent();
        boolean bl = hasEnoughSpeed = Math.abs(shieldboardSpeedComponent.getCurrentBaseSpeed()) > shieldboardSpeedComponent.getMaxBaseSpeed() / 2.0;
        if (!hasEnoughSpeed) {
            return false;
        }
        class_1309 controller = this.method_5642();
        return controller != null && !controller.method_27298();
    }

    public int getEnchantmentLevel(int max) {
        int level = class_1890.method_8225((class_1887)ShieldSurfEnchantments.SHIELD_SURF, (class_1799)this.asItemStack());
        if (level < 0) {
            return 0;
        }
        if (level > max) {
            return max;
        }
        return level;
    }

    public void method_6154(int strength) {
        if (strength < 0) {
            strength = 0;
        } else {
            this.jumping = true;
        }
        this.jumpingPower = strength >= 90 ? 1.0f : 0.4f + 0.4f * (float)strength / 90.0f;
    }

    public boolean method_6153() {
        return true;
    }

    public void method_6155(int height) {
        this.jumping = true;
    }

    public void method_6156() {
    }

    protected void jump(float strength) {
        double d = this.getJumpStrength() * (double)strength * (double)this.method_23313();
        class_243 vec3d = this.method_18798();
        this.method_18800(vec3d.field_1352, d, vec3d.field_1350);
        this.setInAirForJump(true);
        this.field_6007 = true;
    }

    public double getJumpStrength() {
        return 0.4;
    }

    public boolean isInAirForJump() {
        return this.inAirForJump;
    }

    public void setInAirForJump(boolean value) {
        this.inAirForJump = value;
    }
}

