/*
 * Decompiled with CFR 0.152.
 */
package survivalblock.shield_surf.common.datagen;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.class_8110;

public class FabricDamageTypesContainer {
    private final List<Pair<String, class_8110>> backing;

    public FabricDamageTypesContainer() {
        this(new ArrayList<Pair<String, class_8110>>());
    }

    public FabricDamageTypesContainer(List<Pair<String, class_8110>> list) {
        ArrayList<Pair<String, class_8110>> temporaryList;
        if (list instanceof ImmutableCollection) {
            throw new IllegalStateException("The backing of FabricDamageTypesContainer cannot be immutable!");
        }
        try {
            temporaryList = (ArrayList<Pair<String, class_8110>>)list.getClass().newInstance();
        }
        catch (Throwable t) {
            LogUtils.getLogger().error("Error when attempting to make a new instance of a list in the constructor of FabricDamageTypesContainer", t);
            temporaryList = new ArrayList<Pair<String, class_8110>>();
        }
        if (!temporaryList.isEmpty()) {
            temporaryList.clear();
        }
        this.backing = temporaryList;
    }

    public void forEach(Consumer<Pair<String, class_8110>> action) {
        this.backing.forEach(action);
    }

    public boolean add(class_8110 damageType) {
        return this.add(damageType.comp_1242(), damageType);
    }

    public boolean add(String filename, class_8110 damageType) {
        Pair pair = new Pair((Object)filename, (Object)damageType);
        return this.backing.add((Pair<String, class_8110>)pair);
    }

    public boolean addDamageTypes(Collection<class_8110> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        AtomicBoolean changed = new AtomicBoolean(false);
        collection.forEach((? super T damageType) -> changed.set(changed.get() || this.add((class_8110)damageType)));
        return changed.get();
    }

    public boolean addFilenamesAndDamageTypes(Collection<Pair<String, class_8110>> collectionPair) {
        if (collectionPair.isEmpty()) {
            return false;
        }
        AtomicBoolean changed = new AtomicBoolean(false);
        collectionPair.forEach((? super T pair) -> changed.set(changed.get() || this.add((String)pair.getFirst(), (class_8110)pair.getSecond())));
        return changed.get();
    }

    public ImmutableList<Pair<String, class_8110>> asImmutableCopy() {
        return ImmutableList.copyOf(this.backing);
    }
}

