/*
 * Decompiled with CFR 0.152.
 */
package survivalblock.shield_surf.common.component;

import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.CommonTickingComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import survivalblock.shield_surf.common.init.ShieldSurfEntityComponents;

public class ShieldSatellitesComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    private final class_1657 obj;
    private int satellites = 0;
    private int rotation = 0;
    private final List<class_1799> itemStacks = new ArrayList<class_1799>();
    public static final int maxSatellites = 16;

    public ShieldSatellitesComponent(class_1657 obj) {
        this.obj = obj;
    }

    public void readFromNbt(class_2487 tag) {
        this.satellites = tag.method_10550("Satellites");
        this.rotation = tag.method_10550("OrbitRotation");
        this.itemStacks.clear();
        class_2499 nbtList = tag.method_10554("Items", 10);
        for (int i = 0; i < nbtList.size(); ++i) {
            class_2487 nbtCompound = nbtList.method_10602(i);
            this.itemStacks.add(class_1799.method_7915((class_2487)nbtCompound));
        }
    }

    public void writeToNbt(class_2487 tag) {
        tag.method_10569("Satellites", this.satellites);
        tag.method_10569("OrbitRotation", this.rotation);
        class_2499 nbtList = new class_2499();
        for (class_1799 itemStack : this.itemStacks) {
            if (itemStack.method_7960()) continue;
            class_2487 nbtCompound = new class_2487();
            itemStack.method_7953(nbtCompound);
            nbtList.add((Object)nbtCompound);
        }
        tag.method_10566("Items", (class_2520)nbtList);
    }

    public int getRotation() {
        return this.rotation;
    }

    public int getSatellites() {
        return this.satellites;
    }

    public void addSatellite(class_1799 stack) {
        ++this.satellites;
        this.itemStacks.add(stack);
        this.sync();
    }

    public void removeSatellite() {
        --this.satellites;
        this.itemStacks.remove(0);
        this.obj.method_37908().method_8421((class_1297)this.obj, (byte)29);
        this.obj.method_37908().method_8421((class_1297)this.obj, (byte)30);
        this.sync();
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
        this.sync();
    }

    public void tick() {
        if (this.satellites > 16 || this.getItemStacksSize() != this.satellites) {
            this.satellites = 0;
            this.itemStacks.clear();
            this.sync();
            return;
        }
        this.setRotation((this.getRotation() + 2) % 360);
    }

    private void sync() {
        ShieldSurfEntityComponents.SHIELD_SATELLITES.sync((Object)this.obj);
    }

    public int getItemStacksSize() {
        return this.itemStacks.size();
    }

    public class_1799 getStack(int i) {
        return this.itemStacks.get(i);
    }
}

