/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal.teams;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2178;
import net.minecraft.class_2186;
import net.minecraft.class_2196;
import net.minecraft.class_2232;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;
import shetiphian.core.common.NameHelper;
import shetiphian.core.internal.network.NetworkHandler;
import shetiphian.core.internal.network.PacketTeamIdSync;
import shetiphian.core.internal.teams.PlayerTeam;
import shetiphian.core.internal.teams.TeamHelper;

public class TeamCommand {
    private static final class_2561 CREATE_TEAM_SUCCESS = class_2561.method_43471((String)"shetiphiancore.team.create.success");
    private static final class_2561 CREATE_TEAM_FAIL_IN_TEAM = class_2561.method_43471((String)"shetiphiancore.team.create.fail.inteam");
    private static final class_2561 CREATE_TEAM_FAIL_EXISTS = class_2561.method_43471((String)"shetiphiancore.team.create.fail.exists");
    private static final String RENAME_SUCCESS = "shetiphiancore.team.rename.success";
    private static final class_2561 RENAME_FAIL = class_2561.method_43471((String)"shetiphiancore.team.rename.fail.same");
    private static final class_2561 SEND_INVITE_SUCCESS = class_2561.method_43471((String)"shetiphiancore.team.invite.send.success");
    private static final class_2561 SEND_INVITE_FAIL_ALREADY_MEMBER = class_2561.method_43471((String)"shetiphiancore.team.invite.send.fail.member");
    private static final String SEND_INVITE_FAIL_PENDING = "shetiphiancore.team.invite.send.fail.pending";
    private static final String INVITE_NOTICE = "shetiphiancore.team.invite.receive.notice";
    private static final String ACCEPT_INVITE_SUCCESS = "shetiphiancore.team.invite.accept.success";
    private static final String ACCEPT_INVITE_SUCCESS_NOTICE = "shetiphiancore.team.invite.accept.success.notice";
    private static final class_2561 ACCEPT_INVITE_FAIL_PERMISSIONS = class_2561.method_43471((String)"shetiphiancore.team.invite.accept.fail.permissions");
    private static final class_2561 ACCEPT_INVITE_FAIL_MEMBER = class_2561.method_43471((String)"shetiphiancore.team.invite.accept.fail.member");
    private static final class_2561 ACCEPT_INVITE_FAIL_IN_TEAM = class_2561.method_43471((String)"shetiphiancore.team.invite.accept.fail.inteam");
    private static final class_2561 ACCEPT_INVITE_FAIL_NO_INVITE = class_2561.method_43471((String)"shetiphiancore.team.invite.accept.fail.noinvite");
    private static final class_2561 LEAVE_SUCCESS = class_2561.method_43471((String)"shetiphiancore.team.leave.success");
    private static final String LEAVE_SUCCESS_NOTICE = "shetiphiancore.team.leave.success.notice";
    private static final class_2561 LEAVE_FAILED_LEADER = class_2561.method_43471((String)"shetiphiancore.team.leave.fail.leader");
    private static final class_2561 KICK_SUCCESS = class_2561.method_43471((String)"shetiphiancore.team.kick.success");
    private static final class_2561 KICK_SUCCESS_NOTICE = class_2561.method_43471((String)"shetiphiancore.team.kick.success.notice");
    private static final class_2561 KICK_FAIL_RANK = class_2561.method_43471((String)"shetiphiancore.team.kick.fail.rank");
    private static final class_2561 KICK_FAIL_WRONG_TEAM = class_2561.method_43471((String)"shetiphiancore.team.kick.fail.team");
    private static final class_2561 PROMOTE_SUCCESS = class_2561.method_43471((String)"shetiphiancore.team.rank.promote.success");
    private static final class_2561 PROMOTED = class_2561.method_43471((String)"shetiphiancore.team.rank.promote.success.notice");
    private static final class_2561 PROMOTE_FAIL_ALREADY_MANAGER = class_2561.method_43471((String)"shetiphiancore.team.rank.promote.fail.manager");
    private static final class_2561 PROMOTE_FAIL_USER_NOT_IN_TEAM = class_2561.method_43471((String)"shetiphiancore.team.rank.promote.fail.not_member");
    private static final class_2561 DEMOTE_SUCCESS = class_2561.method_43471((String)"shetiphiancore.team.rank.demote.success");
    private static final class_2561 DEMOTED = class_2561.method_43471((String)"shetiphiancore.team.rank.demote.success.notice");
    private static final class_2561 DEMOTE_SELF_SUCCESS = class_2561.method_43471((String)"shetiphiancore.team.rank.demote.success.self");
    private static final class_2561 TRANSFER_SUCCESS = class_2561.method_43471((String)"shetiphiancore.team.transfer.success");
    private static final String TRANSFER_SUCCESS_NOTICE = "shetiphiancore.team.transfer.success.notice";
    private static final class_2561 TRANSFER_FAIL_SAME = class_2561.method_43471((String)"shetiphiancore.team.transfer.fail.same");
    private static final String DISBAND_SUCCESS = "shetiphiancore.team.disband.success";
    private static final class_2561 NO_TEAMS = class_2561.method_43471((String)"shetiphiancore.team.no_teams");
    private static final class_2561 TEAM_HAS_NO_MEMBERS = class_2561.method_43471((String)"shetiphiancore.team.members.empty");
    private static final class_2561 TEAM_DOESNT_EXIST = class_2561.method_43471((String)"shetiphiancore.team.members.error.noteam");
    private static final class_2561 YOUR_NOT_IN_A_TEAM = class_2561.method_43471((String)"shetiphiancore.team.error.no_team");
    private static final class_2561 YOUR_NOT_THE_TEAM_LEADER = class_2561.method_43471((String)"shetiphiancore.team.error.not_leader");
    private static final class_2561 YOUR_NOT_A_TEAM_MANAGER = class_2561.method_43471((String)"shetiphiancore.team.error.not_manager.self");
    private static final class_2561 PLAYER_NOT_A_TEAM_MANAGER = class_2561.method_43471((String)"shetiphiancore.team.error.not_manager.other");
    private static final String SYSADMIN_CREATE_TEAM = "shetiphiancore.team.sysadmin.create.success";
    private static final String SYSADMIN_RENAME_SUCCESS = "shetiphiancore.team.sysadmin.rename.success";
    private static final String SYSADMIN_KICK_SUCCESS = "shetiphiancore.team.sysadmin.kick.success";
    private static final String SYSADMIN_KICKED_FROM_TEAM = "shetiphiancore.team.sysadmin.kick.inform";
    private static final String SYSADMIN_ADD_SUCCESS = "shetiphiancore.team.sysadmin.add.success";
    private static final String SYSADMIN_ADDED_TO_TEAM = "shetiphiancore.team.sysadmin.add.inform";
    private static final String SYSADMIN_TRANSFER_SUCCESS = "shetiphiancore.team.sysadmin.transfer.success";
    private static final String SYSADMIN_DISBAND_SUCCESS = "shetiphiancore.team.sysadmin.disband.success";
    private static final String SYSADMIN_TEAM_DISBANDED = "shetiphiancore.team.sysadmin.disband.inform";
    private static final Cache<class_3222, Pair<PlayerTeam, class_1657>> INVITE_CACHE = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build();
    private static final String RANK_LEADER = "\u25c6 ";
    private static final String RANK_MANAGER = "\u25c7 ";

    public static void registerArguments() {
        ArgumentTypeRegistry.registerArgumentType((class_2960)new class_2960("shetiphiancore", "team_string"), TeamArgument.class, (class_2314)class_2319.method_41999(TeamArgument::new));
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spc_teams").then(class_2170.method_9247((String)"create").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"teamId", (ArgumentType)class_2232.method_9441()).executes(context -> TeamCommand.createTeam((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"teamId")))).then(class_2170.method_9244((String)"displayName", (ArgumentType)class_2178.method_9281()).executes(context -> TeamCommand.createTeam((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"teamId"), class_2178.method_9280((CommandContext)context, (String)"displayName"))))))).then(class_2170.method_9247((String)"rename").then(class_2170.method_9244((String)"displayName", (ArgumentType)class_2178.method_9281()).executes(context -> TeamCommand.rename((class_2168)context.getSource(), class_2178.method_9280((CommandContext)context, (String)"displayName")))))).then(class_2170.method_9247((String)"invite").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> TeamCommand.invite((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"accept").executes(context -> TeamCommand.accept((class_2168)context.getSource())))).then(class_2170.method_9247((String)"leave").executes(context -> TeamCommand.leave((class_2168)context.getSource())))).then(class_2170.method_9247((String)"kick").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> TeamCommand.kick((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"promote").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> TeamCommand.promote((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"demote").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> TeamCommand.demote((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"transfer").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> TeamCommand.transfer((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"disband").executes(context -> TeamCommand.disband((class_2168)context.getSource())))).then(class_2170.method_9247((String)"teams").executes(context -> TeamCommand.teams((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"info").executes(context -> TeamCommand.info((class_2168)context.getSource(), null))).then(class_2170.method_9244((String)"teamId", (ArgumentType)new TeamArgument()).executes(context -> TeamCommand.info((class_2168)context.getSource(), TeamArgument.get((CommandContext<class_2168>)context, "teamId"))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spc_teams_sysadmin").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"create").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"teamId", (ArgumentType)class_2232.method_9441()).executes(context -> TeamCommand.sysadmin_createTeam((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"teamId")))).then(class_2170.method_9244((String)"displayName", (ArgumentType)class_2178.method_9281()).executes(context -> TeamCommand.sysadmin_createTeam((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"teamId"), class_2178.method_9280((CommandContext)context, (String)"displayName"))))))).then(class_2170.method_9247((String)"rename").then(class_2170.method_9244((String)"teamId", (ArgumentType)new TeamArgument()).then(class_2170.method_9244((String)"displayName", (ArgumentType)class_2178.method_9281()).executes(context -> TeamCommand.sysadmin_rename((class_2168)context.getSource(), TeamArgument.get((CommandContext<class_2168>)context, "teamId"), class_2178.method_9280((CommandContext)context, (String)"displayName"))))))).then(class_2170.method_9247((String)"kick").then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"inform", (ArgumentType)BoolArgumentType.bool()).executes(context -> TeamCommand.sysadmin_kick((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"players"), BoolArgumentType.getBool((CommandContext)context, (String)"inform"))))))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"teamId", (ArgumentType)new TeamArgument()).then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(context -> TeamCommand.sysadmin_add((class_2168)context.getSource(), TeamArgument.get((CommandContext<class_2168>)context, "teamId"), class_2186.method_9312((CommandContext)context, (String)"players"), BoolArgumentType.getBool((CommandContext)context, (String)"force")))))))).then(class_2170.method_9247((String)"transfer").then(class_2170.method_9244((String)"teamId", (ArgumentType)new TeamArgument()).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(context -> TeamCommand.sysadmin_transfer((class_2168)context.getSource(), TeamArgument.get((CommandContext<class_2168>)context, "teamId"), class_2186.method_9315((CommandContext)context, (String)"player"), BoolArgumentType.getBool((CommandContext)context, (String)"force")))))))).then(class_2170.method_9247((String)"disband").then(class_2170.method_9244((String)"teamId", (ArgumentType)new TeamArgument()).executes(context -> TeamCommand.sysadmin_disband((class_2168)context.getSource(), TeamArgument.get((CommandContext<class_2168>)context, "teamId"))))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"msg_team").then(class_2170.method_9244((String)"message", (ArgumentType)class_2196.method_9340()).executes(context -> TeamCommand.teamMessage((class_2168)context.getSource(), class_2196.method_9339((CommandContext)context, (String)"message")))));
    }

    private static int createTeam(class_2168 source, class_2960 teamId) {
        return TeamCommand.createTeam(source, teamId, (class_2561)class_2561.method_43470((String)teamId.method_12832()));
    }

    private static int createTeam(class_2168 source, class_2960 teamId, class_2561 displayName) {
        class_1297 e = source.method_9228();
        if (e instanceof class_3222) {
            class_3222 executor = (class_3222)e;
            if (!TeamHelper.doesTeamExist(teamId.method_12832())) {
                if (TeamHelper.getTeam((class_1657)executor) == null) {
                    PlayerTeam.create(teamId.method_12832(), (class_1657)executor, displayName);
                    source.method_9226(() -> CREATE_TEAM_SUCCESS, false);
                } else {
                    source.method_9213(CREATE_TEAM_FAIL_IN_TEAM);
                }
            } else {
                source.method_9213(CREATE_TEAM_FAIL_EXISTS);
            }
        }
        return 0;
    }

    private static int rename(class_2168 source, class_2561 displayName) {
        class_1297 e = source.method_9228();
        if (e instanceof class_3222) {
            class_3222 executor = (class_3222)e;
            PlayerTeam eTeam = TeamHelper.getTeam((class_1657)executor);
            if (eTeam != null) {
                if (eTeam.isManager(executor.method_5667())) {
                    class_2561 oldName = eTeam.getDisplayName();
                    if (eTeam.changeDisplayName(displayName)) {
                        class_5250 message = class_2561.method_43469((String)RENAME_SUCCESS, (Object[])new Object[]{oldName, eTeam.getDisplayName()});
                        source.method_9226(() -> message, false);
                    } else {
                        source.method_9213(RENAME_FAIL);
                    }
                } else {
                    source.method_9213(YOUR_NOT_A_TEAM_MANAGER);
                }
            } else {
                source.method_9213(YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int invite(class_2168 source, class_3222 target) {
        class_1297 e = source.method_9228();
        if (e instanceof class_3222) {
            class_3222 executor = (class_3222)e;
            PlayerTeam eTeam = TeamHelper.getTeam((class_1657)executor);
            if (eTeam != null) {
                if (eTeam.isManager(executor.method_5667())) {
                    Pair cachedInvite = (Pair)INVITE_CACHE.getIfPresent((Object)executor);
                    if (cachedInvite == null) {
                        if (!eTeam.equals(TeamHelper.getTeam(target.method_5667()))) {
                            class_5250 invite = class_2561.method_43469((String)INVITE_NOTICE, (Object[])new Object[]{eTeam.getDisplayName(), "'/spc_teams accept'", 15});
                            target.method_43496((class_2561)invite);
                            INVITE_CACHE.put((Object)target, (Object)Pair.of((Object)eTeam, (Object)executor));
                            source.method_9226(() -> SEND_INVITE_SUCCESS, false);
                        } else {
                            source.method_9213(SEND_INVITE_FAIL_ALREADY_MEMBER);
                        }
                    } else {
                        class_5250 invite = class_2561.method_43469((String)SEND_INVITE_FAIL_PENDING, (Object[])new Object[]{((PlayerTeam)cachedInvite.getLeft()).getDisplayName()});
                        target.method_43496((class_2561)invite);
                    }
                } else {
                    source.method_9213(YOUR_NOT_A_TEAM_MANAGER);
                }
            } else {
                source.method_9213(YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int accept(class_2168 source) {
        class_1297 e = source.method_9228();
        if (e instanceof class_3222) {
            class_3222 executor = (class_3222)e;
            Pair cachedInvite = (Pair)INVITE_CACHE.getIfPresent((Object)executor);
            if (cachedInvite != null) {
                PlayerTeam eTeam = TeamHelper.getTeam((class_1657)executor);
                if (eTeam == null) {
                    PlayerTeam team = (PlayerTeam)cachedInvite.getLeft();
                    if (team.isManager(((class_1657)cachedInvite.getRight()).method_5667())) {
                        TeamCommand.notifyTeam(source.method_9211(), team.getMembers(), executor, true);
                        team.add((class_1657)executor);
                        class_5250 invite = class_2561.method_43469((String)ACCEPT_INVITE_SUCCESS, (Object[])new Object[]{team.getDisplayName()});
                        source.method_9226(() -> invite, false);
                    } else {
                        source.method_9213(ACCEPT_INVITE_FAIL_PERMISSIONS);
                    }
                } else if (eTeam.equals(cachedInvite.getLeft())) {
                    source.method_9213(ACCEPT_INVITE_FAIL_MEMBER);
                } else {
                    source.method_9213(ACCEPT_INVITE_FAIL_IN_TEAM);
                }
            } else {
                source.method_9213(ACCEPT_INVITE_FAIL_NO_INVITE);
            }
        }
        return 0;
    }

    private static int leave(class_2168 source) {
        class_1297 e = source.method_9228();
        if (e instanceof class_3222) {
            class_3222 executor = (class_3222)e;
            PlayerTeam eTeam = TeamHelper.getTeam((class_1657)executor);
            if (eTeam != null) {
                UUID eId = executor.method_5667();
                if (!eId.equals(eTeam.getLeader())) {
                    eTeam.leave((class_1657)executor);
                    source.method_9226(() -> LEAVE_SUCCESS, false);
                    TeamCommand.notifyTeam(source.method_9211(), eTeam.getMembers(), executor, false);
                } else {
                    source.method_9213(LEAVE_FAILED_LEADER);
                }
            } else {
                source.method_9213(YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static void notifyTeam(MinecraftServer server, List<UUID> members, class_3222 player, boolean joining) {
        class_5250 message = class_2561.method_43469((String)(joining ? ACCEPT_INVITE_SUCCESS_NOTICE : LEAVE_SUCCESS_NOTICE), (Object[])new Object[]{player.method_5476()});
        server.method_3760().method_14571().forEach(serverPlayer -> {
            if (members.contains(serverPlayer.method_5667())) {
                serverPlayer.method_43496((class_2561)message);
            }
        });
    }

    private static int kick(class_2168 source, class_3222 target) {
        class_1297 e = source.method_9228();
        if (e instanceof class_3222) {
            class_3222 executor = (class_3222)e;
            if (executor.equals((Object)target)) {
                return TeamCommand.leave(source);
            }
            PlayerTeam eTeam = TeamHelper.getTeam((class_1657)executor);
            if (eTeam != null) {
                UUID eID = executor.method_5667();
                if (eTeam.equals(TeamHelper.getTeam(target.method_5667()))) {
                    if (eID.equals(eTeam.getLeader()) || eTeam.isManager(eID) && !eTeam.isManager(target.method_5667())) {
                        eTeam.kick((class_1657)target);
                        target.method_43496(KICK_SUCCESS_NOTICE);
                        source.method_9226(() -> KICK_SUCCESS, false);
                    } else {
                        source.method_9213(KICK_FAIL_RANK);
                    }
                } else {
                    source.method_9213(KICK_FAIL_WRONG_TEAM);
                }
            } else {
                source.method_9213(YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int promote(class_2168 source, class_3222 target) {
        class_1297 e = source.method_9228();
        if (e instanceof class_3222) {
            class_3222 executor = (class_3222)e;
            PlayerTeam eTeam = TeamHelper.getTeam((class_1657)executor);
            if (eTeam != null) {
                if (eTeam.isManager(executor.method_5667())) {
                    if (eTeam.getMembers().contains(target.method_5667())) {
                        if (eTeam.promote((class_1657)target)) {
                            target.method_43496(PROMOTED);
                            source.method_9226(() -> PROMOTE_SUCCESS, false);
                        } else {
                            source.method_9213(PROMOTE_FAIL_ALREADY_MANAGER);
                        }
                    } else {
                        source.method_9213(PROMOTE_FAIL_USER_NOT_IN_TEAM);
                    }
                } else {
                    source.method_9213(YOUR_NOT_A_TEAM_MANAGER);
                }
            } else {
                source.method_9213(YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int demote(class_2168 source, class_3222 target) {
        class_1297 e = source.method_9228();
        if (e instanceof class_3222) {
            class_3222 executor = (class_3222)e;
            PlayerTeam eTeam = TeamHelper.getTeam((class_1657)executor);
            if (eTeam != null) {
                if (eTeam.isManager(executor.method_5667())) {
                    if (eTeam.demote((class_1657)target)) {
                        if (executor.equals((Object)target)) {
                            source.method_9226(() -> DEMOTE_SELF_SUCCESS, false);
                        } else {
                            target.method_43496(DEMOTED);
                            source.method_9226(() -> DEMOTE_SUCCESS, false);
                        }
                    } else {
                        source.method_9213(PLAYER_NOT_A_TEAM_MANAGER);
                    }
                } else {
                    source.method_9213(YOUR_NOT_A_TEAM_MANAGER);
                }
            } else {
                source.method_9213(YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int transfer(class_2168 source, class_3222 target) {
        class_1297 e = source.method_9228();
        if (e instanceof class_3222) {
            class_3222 executor = (class_3222)e;
            PlayerTeam eTeam = TeamHelper.getTeam((class_1657)executor);
            if (eTeam != null) {
                if (executor.method_5667().equals(eTeam.getLeader())) {
                    if (eTeam.isManager(target.method_5667())) {
                        if (eTeam.transfer((class_1657)target)) {
                            class_5250 message = class_2561.method_43469((String)TRANSFER_SUCCESS_NOTICE, (Object[])new Object[]{eTeam.getDisplayName()});
                            target.method_43496((class_2561)message);
                            source.method_9226(() -> TRANSFER_SUCCESS, false);
                        } else {
                            source.method_9213(TRANSFER_FAIL_SAME);
                        }
                    } else {
                        source.method_9213(PLAYER_NOT_A_TEAM_MANAGER);
                    }
                } else {
                    source.method_9213(YOUR_NOT_THE_TEAM_LEADER);
                }
            } else {
                source.method_9213(YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int disband(class_2168 source) {
        class_1297 e = source.method_9228();
        if (e instanceof class_3222) {
            class_3222 executor = (class_3222)e;
            PlayerTeam eTeam = TeamHelper.getTeam((class_1657)executor);
            if (eTeam != null) {
                if (executor.method_5667().equals(eTeam.getLeader())) {
                    class_5250 message = class_2561.method_43469((String)DISBAND_SUCCESS, (Object[])new Object[]{eTeam.getDisplayName()});
                    List<UUID> players = TeamHelper.deleteTeam(eTeam.getId());
                    source.method_9211().method_3760().method_14571().forEach(serverPlayer -> {
                        UUID uuid = serverPlayer.method_5667();
                        if (players.contains(uuid)) {
                            serverPlayer.method_43496((class_2561)message);
                        }
                    });
                } else {
                    source.method_9213(YOUR_NOT_THE_TEAM_LEADER);
                }
            } else {
                source.method_9213(YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static int teams(class_2168 source) {
        Set<String> teams = TeamHelper.getTeams();
        if (!teams.isEmpty()) {
            class_5250 message = class_2561.method_43470((String)"\u00a77\u00a7o<teamId> ['<displayName>']\u00a7r");
            teams.forEach(id -> message.method_27693("\u00a75 :: \u00a7f").method_27693(id).method_27693("\u00a77 ['\u00a7f").method_10852(TeamHelper.getTeamDisplayName(id)).method_27693("\u00a77']"));
            message.method_27693("\u00a7r");
            source.method_9226(() -> message, false);
            if (source.method_9211().method_3860() && source.method_44023() != null) {
                NetworkHandler.sendToPlayer(new PacketTeamIdSync(teams), source.method_44023());
            }
        } else {
            source.method_9213(NO_TEAMS);
        }
        return 0;
    }

    private static int info(class_2168 source, String teamId) {
        class_1297 e;
        if (teamId == null && (e = source.method_9228()) instanceof class_3222) {
            class_3222 executor = (class_3222)e;
            PlayerTeam eTeam = TeamHelper.getTeam((class_1657)executor);
            if (eTeam != null) {
                teamId = eTeam.getId();
            } else {
                source.method_9213(YOUR_NOT_IN_A_TEAM);
                return 0;
            }
        }
        if (TeamHelper.doesTeamExist(teamId)) {
            PlayerTeam eTeam = TeamHelper.getTeam(teamId);
            if (eTeam != null) {
                class_5250 message = class_2561.method_43470((String)"\u00a7f").method_27693(teamId).method_27693("\u00a77 ['\u00a7f").method_10852(eTeam.getDisplayName()).method_27693("\u00a77']");
                List<UUID> members = eTeam.getMembers();
                if (!members.isEmpty()) {
                    UUID leader = eTeam.getLeader();
                    if (leader != null) {
                        message.method_27693("\n");
                        message.method_27693(RANK_LEADER + NameHelper.getLastKnownUsername(leader));
                    }
                    StringBuilder bldManagers = new StringBuilder();
                    eTeam.getManagers().forEach(manager -> {
                        if (!manager.equals(leader)) {
                            bldManagers.append(NameHelper.getLastKnownUsername(manager)).append(", ");
                        }
                    });
                    if (bldManagers.length() > 0) {
                        String names = bldManagers.toString();
                        names = names.substring(0, names.length() - 2);
                        message.method_27693("\n");
                        message.method_27693(RANK_MANAGER + names);
                    }
                    StringBuilder bldMembers = new StringBuilder();
                    members.forEach(member -> {
                        if (!eTeam.isManager((UUID)member)) {
                            bldMembers.append(NameHelper.getLastKnownUsername(member)).append(", ");
                        }
                    });
                    if (bldMembers.length() > 0) {
                        String names = bldMembers.toString();
                        names = names.substring(0, names.length() - 2);
                        message.method_27693("\n");
                        message.method_27693(names);
                    }
                } else {
                    message.method_10852(TEAM_HAS_NO_MEMBERS);
                }
                source.method_9226(() -> message, false);
            }
        } else {
            source.method_9213(TEAM_DOESNT_EXIST);
        }
        return 0;
    }

    private static int sysadmin_createTeam(class_2168 source, class_2960 teamId) {
        return TeamCommand.sysadmin_createTeam(source, teamId, (class_2561)class_2561.method_43470((String)teamId.method_12832()));
    }

    private static int sysadmin_createTeam(class_2168 source, class_2960 teamId, class_2561 displayName) {
        if (!TeamHelper.doesTeamExist(teamId.method_12832())) {
            PlayerTeam team = PlayerTeam.create(teamId.method_12832(), null, displayName);
            source.method_9226(() -> class_2561.method_43469((String)SYSADMIN_CREATE_TEAM, (Object[])new Object[]{team.getId(), team.getDisplayName()}), true);
        } else {
            source.method_9213(CREATE_TEAM_FAIL_EXISTS);
        }
        return 0;
    }

    private static int sysadmin_rename(class_2168 source, String teamId, class_2561 displayName) {
        PlayerTeam eTeam = TeamHelper.SAVEDATA.TEAMS.get(teamId);
        if (eTeam != null) {
            class_2561 oldName = eTeam.getDisplayName();
            if (eTeam.changeDisplayName(displayName)) {
                source.method_9226(() -> class_2561.method_43469((String)SYSADMIN_RENAME_SUCCESS, (Object[])new Object[]{teamId, oldName, eTeam.getDisplayName()}), true);
            } else {
                source.method_9213(RENAME_FAIL);
            }
        } else {
            source.method_9213(YOUR_NOT_IN_A_TEAM);
        }
        return 0;
    }

    private static int sysadmin_kick(class_2168 source, Collection<class_3222> players, boolean inform) {
        AtomicInteger counter = new AtomicInteger();
        class_5250 names = class_2561.method_43470((String)" [");
        players.forEach(player -> {
            PlayerTeam current = TeamHelper.getTeam((class_1657)player);
            if (current != null) {
                current.kick((class_1657)player);
                if (inform) {
                    class_5250 message = class_2561.method_43469((String)SYSADMIN_KICKED_FROM_TEAM, (Object[])new Object[]{current.getDisplayName()});
                    player.method_43496((class_2561)message);
                }
                TeamCommand.notifyTeam(source.method_9211(), current.getMembers(), player, false);
                if (counter.get() > 0) {
                    names.method_27693(", ");
                }
                counter.getAndIncrement();
                names.method_10852(player.method_5476());
            }
        });
        if (counter.get() > 0) {
            names.method_27693("]");
            source.method_9226(() -> class_2561.method_43469((String)SYSADMIN_KICK_SUCCESS, (Object[])new Object[]{counter.get()}).method_10852((class_2561)names), true);
        }
        return 0;
    }

    private static int sysadmin_add(class_2168 source, String teamId, Collection<class_3222> players, boolean force) {
        PlayerTeam team = TeamHelper.SAVEDATA.TEAMS.get(teamId);
        if (team != null) {
            AtomicInteger counter = new AtomicInteger();
            class_5250 names = class_2561.method_43470((String)" [");
            players.forEach(player -> {
                class_5250 message;
                PlayerTeam current = TeamHelper.getTeam((class_1657)player);
                if (current != null && force) {
                    current.kick((class_1657)player);
                    message = class_2561.method_43469((String)SYSADMIN_KICKED_FROM_TEAM, (Object[])new Object[]{current.getDisplayName()});
                    player.method_43496((class_2561)message);
                    TeamCommand.notifyTeam(source.method_9211(), team.getMembers(), player, false);
                    current = null;
                }
                if (current == null) {
                    TeamCommand.notifyTeam(source.method_9211(), team.getMembers(), player, true);
                    team.add((class_1657)player);
                    message = class_2561.method_43469((String)SYSADMIN_ADDED_TO_TEAM, (Object[])new Object[]{team.getDisplayName()});
                    player.method_43496((class_2561)message);
                    if (counter.get() > 0) {
                        names.method_27693(", ");
                    }
                    counter.getAndIncrement();
                    names.method_10852(player.method_5476());
                }
            });
            if (counter.get() > 0) {
                names.method_27693("]");
                source.method_9226(() -> class_2561.method_43469((String)SYSADMIN_ADD_SUCCESS, (Object[])new Object[]{counter.get(), teamId}).method_10852((class_2561)names), true);
            }
        } else {
            source.method_9213(TEAM_DOESNT_EXIST);
        }
        return 0;
    }

    private static int sysadmin_transfer(class_2168 source, String teamId, class_3222 player, boolean force) {
        PlayerTeam team = TeamHelper.SAVEDATA.TEAMS.get(teamId);
        if (team != null) {
            class_5250 message;
            PlayerTeam current = TeamHelper.getTeam((class_1657)player);
            if (current != null && force) {
                current.kick((class_1657)player);
                message = class_2561.method_43469((String)SYSADMIN_KICKED_FROM_TEAM, (Object[])new Object[]{current.getDisplayName()});
                player.method_43496((class_2561)message);
                current = null;
            }
            if (current == null) {
                if (team.transfer((class_1657)player)) {
                    message = class_2561.method_43469((String)TRANSFER_SUCCESS_NOTICE, (Object[])new Object[]{team.getDisplayName()});
                    player.method_43496((class_2561)message);
                    source.method_9226(() -> class_2561.method_43469((String)SYSADMIN_TRANSFER_SUCCESS, (Object[])new Object[]{teamId, player.method_5476()}), true);
                } else {
                    source.method_9213(TRANSFER_FAIL_SAME);
                }
            }
        } else {
            source.method_9213(TEAM_DOESNT_EXIST);
        }
        return 0;
    }

    private static int sysadmin_disband(class_2168 source, String teamId) {
        if (TeamHelper.doesTeamExist(teamId)) {
            class_5250 message = class_2561.method_43469((String)SYSADMIN_TEAM_DISBANDED, (Object[])new Object[]{TeamHelper.getTeamDisplayName(teamId)});
            List<UUID> players = TeamHelper.deleteTeam(teamId);
            source.method_9211().method_3760().method_14571().forEach(serverPlayer -> {
                UUID uuid = serverPlayer.method_5667();
                if (players.contains(uuid)) {
                    serverPlayer.method_43496((class_2561)message);
                }
            });
            source.method_9226(() -> class_2561.method_43469((String)SYSADMIN_DISBAND_SUCCESS, (Object[])new Object[]{teamId}), true);
        } else {
            source.method_9213(TEAM_DOESNT_EXIST);
        }
        return 0;
    }

    private static int teamMessage(class_2168 source, class_2561 message) {
        class_1297 entity = source.method_9228();
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            PlayerTeam team = TeamHelper.getTeam((class_1657)player);
            if (team != null) {
                String rank = player.method_5667().equals(team.getLeader()) ? RANK_LEADER : (team.isManager(player.method_5667()) ? RANK_MANAGER : "");
                class_5250 textComponent = class_2561.method_43470((String)("\u00a7a[team]\u00a7r " + rank)).method_10852(player.method_5476()).method_27693("\u00a7a:\u00a7r ").method_10852(message);
                List<UUID> members = team.getMembers();
                source.method_9211().method_3760().method_14571().forEach(arg_0 -> TeamCommand.lambda$teamMessage$49(members, (class_2561)textComponent, arg_0));
            } else {
                source.method_9213(YOUR_NOT_IN_A_TEAM);
            }
        }
        return 0;
    }

    private static /* synthetic */ void lambda$teamMessage$49(List members, class_2561 textComponent, class_3222 serverPlayer) {
        UUID uuid = serverPlayer.method_5667();
        if (members.contains(uuid)) {
            serverPlayer.method_43496(textComponent);
        }
    }

    private static class TeamArgument
    implements ArgumentType<String> {
        public static String get(CommandContext<class_2168> context, String key) {
            return (String)context.getArgument(key, String.class);
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return class_2172.method_9265(TeamHelper.getTeams(), (SuggestionsBuilder)builder);
        }

        public String parse(StringReader reader) {
            return reader.readUnquotedString();
        }
    }
}

